/*
 * Decompiled with CFR 0.152.
 */
package projects.talGA;

import de.jstacs.data.DataSet;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.data.sequences.SimpleDiscreteSequence;
import de.jstacs.data.sequences.annotation.ReferenceSequenceAnnotation;
import de.jstacs.data.sequences.annotation.SequenceAnnotation;
import de.jstacs.optimization.geneticAlgorithms.fitnessFunctions.FitnessFunction;
import de.jstacs.optimization.geneticAlgorithms.populations.individuals.DiscreteSequenceIndividual;
import de.jstacs.results.Result;
import de.jstacs.utils.SafeOutputStream;
import projects.talGA.MatchFinder;
import projects.tals.LimitedSortedList;
import projects.tals.TALgetterDiffSM;

public class OffTargetFitnessFunction
implements FitnessFunction<DiscreteSequenceIndividual> {
    DataSet positives;
    MatchFinder pst;
    TALgetterDiffSM model;
    SafeOutputStream stream;
    private boolean thresholdOnBestScore;

    public OffTargetFitnessFunction(TALgetterDiffSM model, DataSet positives, MatchFinder pst, boolean thresholdOnBestScore) throws CloneNotSupportedException {
        this.pst = pst;
        this.model = model.clone();
        this.positives = positives;
        this.stream = SafeOutputStream.getSafeOutputStream(null);
        this.thresholdOnBestScore = thresholdOnBestScore;
    }

    @Override
    public void setOutputStream(SafeOutputStream stream) {
        this.stream = stream;
    }

    @Override
    public Double getFitness(DiscreteSequenceIndividual individual) throws Exception {
        SimpleDiscreteSequence rvds = individual.getSequence();
        ReferenceSequenceAnnotation rvdAnn = new ReferenceSequenceAnnotation("seq", rvds, new Result[0]);
        double min = Double.POSITIVE_INFINITY;
        int i = 0;
        while (i < this.positives.getNumberOfElements()) {
            Sequence seq = this.positives.getElementAt(i);
            double max = Double.NEGATIVE_INFINITY;
            int j = 0;
            while (j < seq.getLength() - rvds.getLength()) {
                SequenceAnnotation[] sequenceAnnotationArray = new SequenceAnnotation[]{rvdAnn};
                double temp = this.model.getLogScoreFor(seq.getSubSequence(j, rvds.getLength() + 1).annotate(false, sequenceAnnotationArray));
                if (temp > max) {
                    max = temp;
                }
                ++j;
            }
            if (max < min) {
                min = max;
            }
            ++i;
        }
        if (this.thresholdOnBestScore) {
            min = this.model.getBestPossibleScore(rvds, null);
        }
        LimitedSortedList<MatchFinder.Match> sc = this.pst.getScoresAbove(rvds, min - (double)(rvds.getLength() + 1) * Math.log(2.0), 10000, false, false);
        int l = Math.min(sc.getLength(), 10000);
        this.stream.writeln("pst: " + min + "<->" + l);
        if (!this.stream.doesNothing() && sc.getLength() <= 10) {
            this.stream.writeln(String.valueOf(min) + " <-> " + sc);
        }
        return Math.exp((double)(10 - l) / 1000.0);
    }

    @Override
    public void reset() {
        this.pst.reset();
    }
}

