/*
 * Decompiled with CFR 0.152.
 */
package projects.talAlign;

import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.alphabets.DiscreteAlphabet;
import de.jstacs.sequenceScores.statisticalModels.trainable.hmm.HMMFactory;
import de.jstacs.sequenceScores.statisticalModels.trainable.hmm.models.HigherOrderHMM;
import de.jstacs.sequenceScores.statisticalModels.trainable.hmm.states.emissions.DifferentiableEmission;
import de.jstacs.sequenceScores.statisticalModels.trainable.hmm.states.emissions.SilentEmission;
import de.jstacs.sequenceScores.statisticalModels.trainable.hmm.states.emissions.discrete.DiscreteEmission;
import de.jstacs.sequenceScores.statisticalModels.trainable.hmm.training.HMMTrainingParameterSet;
import de.jstacs.sequenceScores.statisticalModels.trainable.hmm.transitions.BasicHigherOrderTransition;
import de.jstacs.utils.Pair;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;

public class HMMBuilder {
    public static HigherOrderHMM buildHMM(int numNTerm, int numPerRepeat, int numRepeatHalf, int numCTerm, double ess, HMMTrainingParameterSet trainingParameterSet, AlphabetContainer alphabet, String[] repeatConsensus) throws Exception {
        int curr;
        ArrayList<Class<? extends DifferentiableEmission>> emissions = new ArrayList<Class<? extends DifferentiableEmission>>();
        ArrayList<HMMFactory.PseudoTransitionElement> transitions = new ArrayList<HMMFactory.PseudoTransitionElement>();
        ArrayList<String> names = new ArrayList<String>();
        emissions.add(SilentEmission.class);
        names.add("S");
        transitions.add(new HMMFactory.PseudoTransitionElement(null, new int[1], new double[]{15.0}));
        int off = curr = HMMBuilder.addNTerm(0, emissions, transitions, names, 1, numNTerm);
        int off2 = curr = HMMBuilder.addRepeat(curr, emissions, transitions, names, 1 + numNTerm, numPerRepeat, numRepeatHalf);
        curr = HMMBuilder.addCTerm(curr, emissions, transitions, names, 1 + numNTerm + numPerRepeat, numCTerm);
        transitions.add(new HMMFactory.PseudoTransitionElement(new int[]{curr}, null, null));
        Pair<double[][], double[]> hypers = HMMFactory.propagateESS(ess, transitions);
        ArrayList<DifferentiableEmission> emission = new ArrayList<DifferentiableEmission>();
        double[] stateEss = hypers.getSecondElement();
        double[][] transHyp = hypers.getFirstElement();
        int k = 0;
        int i = 0;
        while (i < emissions.size()) {
            if (i > off && i <= off2 && (names.get(i).startsWith("M") || names.get(i).equals("J1"))) {
                if (repeatConsensus[k].equals("X")) {
                    emission.add(new DiscreteEmission(alphabet, stateEss[i]));
                } else {
                    double[] hyperParams = new double[(int)alphabet.getAlphabetLengthAt(0)];
                    double fac = 0.5 / ((double)hyperParams.length - 1.0);
                    Arrays.fill(hyperParams, stateEss[i] * fac);
                    hyperParams[((DiscreteAlphabet)alphabet.getAlphabetAt((int)0)).getCode((String)repeatConsensus[k])] = 0.5 * stateEss[i];
                    emission.add(new DiscreteEmission(alphabet, hyperParams));
                }
                ++k;
            } else if (emissions.get(i).equals(SilentEmission.class)) {
                emission.add(new SilentEmission());
            } else {
                emission.add(new DiscreteEmission(alphabet, stateEss[i]));
            }
            ++i;
        }
        BasicHigherOrderTransition.AbstractTransitionElement[] te = HMMFactory.createTransition(transHyp, transitions);
        HigherOrderHMM hmm = new HigherOrderHMM(trainingParameterSet, names.toArray(new String[0]), emission.toArray(new DifferentiableEmission[0]), te);
        return hmm;
    }

    public static int addNTerm(int startState, AbstractList<Class<? extends DifferentiableEmission>> emissions, AbstractList<HMMFactory.PseudoTransitionElement> transitions, AbstractList<String> names, int nameOff, int numNTerm) {
        int currState = startState;
        emissions.add(SilentEmission.class);
        names.add("D" + nameOff);
        emissions.add(DiscreteEmission.class);
        names.add("I" + nameOff);
        emissions.add(DiscreteEmission.class);
        names.add("M" + nameOff);
        transitions.add(new HMMFactory.PseudoTransitionElement(new int[]{startState}, new int[]{startState + 1, startState + 2, startState + 3}, new double[]{5.0, 5.0, 5.0}));
        currState += 3;
        ++nameOff;
        int i = 0;
        while (i < numNTerm - 1) {
            emissions.add(SilentEmission.class);
            emissions.add(DiscreteEmission.class);
            emissions.add(DiscreteEmission.class);
            names.add("D" + nameOff);
            names.add("I" + nameOff);
            names.add("M" + nameOff);
            transitions.add(new HMMFactory.PseudoTransitionElement(new int[]{startState + 1}, new int[]{currState + 1, currState + 3}, new double[]{2.0, 13.0}));
            transitions.add(new HMMFactory.PseudoTransitionElement(new int[]{startState + 2}, new int[]{startState + 2, currState + 3}, new double[]{2.0, 13.0}));
            transitions.add(new HMMFactory.PseudoTransitionElement(new int[]{startState + 3}, new int[]{currState + 1, currState + 2, currState + 3}, new double[]{1.0, 1.0, 13.0}));
            currState += 3;
            startState += 3;
            ++nameOff;
            ++i;
        }
        emissions.add(DiscreteEmission.class);
        names.add("J1");
        transitions.add(new HMMFactory.PseudoTransitionElement(new int[]{startState + 1}, new int[]{currState + 1}, new double[]{15.0}));
        transitions.add(new HMMFactory.PseudoTransitionElement(new int[]{startState + 2}, new int[]{startState + 2, currState + 1}, new double[]{2.0, 13.0}));
        transitions.add(new HMMFactory.PseudoTransitionElement(new int[]{startState + 3}, new int[]{currState + 1}, new double[]{15.0}));
        return currState + 1;
    }

    public static int addRepeat(int startState, AbstractList<Class<? extends DifferentiableEmission>> emissions, AbstractList<HMMFactory.PseudoTransitionElement> transitions, AbstractList<String> names, int nameOff, int numPerRepeat, int numHalfRepeat) {
        int initStartState = startState;
        int currState = startState;
        emissions.add(SilentEmission.class);
        emissions.add(DiscreteEmission.class);
        emissions.add(DiscreteEmission.class);
        names.add("D" + nameOff);
        names.add("I" + nameOff);
        names.add("M" + nameOff);
        transitions.add(new HMMFactory.PseudoTransitionElement(new int[]{startState}, new int[]{startState + 1, startState + 2, startState + 3}, new double[]{5.0, 5.0, 5.0}));
        currState += 3;
        ++nameOff;
        int endState1 = startState + numPerRepeat * 3 + 1;
        int endState2 = endState1 + 1;
        int i = 0;
        while (i < numPerRepeat - 1) {
            emissions.add(SilentEmission.class);
            emissions.add(DiscreteEmission.class);
            emissions.add(DiscreteEmission.class);
            names.add("D" + nameOff);
            names.add("I" + nameOff);
            names.add("M" + nameOff);
            if (i + 1 == numHalfRepeat) {
                transitions.add(new HMMFactory.PseudoTransitionElement(new int[]{startState + 1}, new int[]{currState + 1, currState + 3, endState2}, new double[]{2.0, 12.0, 1.0}));
                transitions.add(new HMMFactory.PseudoTransitionElement(new int[]{startState + 2}, new int[]{startState + 2, currState + 3, endState2}, new double[]{2.0, 12.0, 1.0}));
                transitions.add(new HMMFactory.PseudoTransitionElement(new int[]{startState + 3}, new int[]{currState + 1, currState + 2, currState + 3, endState2}, new double[]{1.0, 1.0, 12.0, 1.0}));
            } else {
                transitions.add(new HMMFactory.PseudoTransitionElement(new int[]{startState + 1}, new int[]{currState + 1, currState + 3}, new double[]{2.0, 13.0}));
                transitions.add(new HMMFactory.PseudoTransitionElement(new int[]{startState + 2}, new int[]{startState + 2, currState + 3}, new double[]{2.0, 13.0}));
                transitions.add(new HMMFactory.PseudoTransitionElement(new int[]{startState + 3}, new int[]{currState + 1, currState + 2, currState + 3}, new double[]{1.0, 1.0, 13.0}));
            }
            currState += 3;
            startState += 3;
            ++nameOff;
            ++i;
        }
        emissions.add(SilentEmission.class);
        names.add("J2");
        emissions.add(SilentEmission.class);
        names.add("J3");
        transitions.add(new HMMFactory.PseudoTransitionElement(new int[]{startState + 1}, new int[]{endState1}, new double[]{15.0}));
        transitions.add(new HMMFactory.PseudoTransitionElement(new int[]{startState + 2}, new int[]{startState + 2, endState1}, new double[]{2.0, 13.0}));
        transitions.add(new HMMFactory.PseudoTransitionElement(new int[]{startState + 3}, new int[]{endState1}, new double[]{15.0}));
        transitions.add(new HMMFactory.PseudoTransitionElement(new int[]{endState1}, new int[]{initStartState}, new double[]{15.0}));
        return endState2;
    }

    public static int addCTerm(int startState, AbstractList<Class<? extends DifferentiableEmission>> emissions, AbstractList<HMMFactory.PseudoTransitionElement> transitions, AbstractList<String> names, int nameOff, int numCTerm) {
        int currState = startState;
        emissions.add(SilentEmission.class);
        emissions.add(DiscreteEmission.class);
        emissions.add(DiscreteEmission.class);
        names.add("D" + nameOff);
        names.add("I" + nameOff);
        names.add("M" + nameOff);
        transitions.add(new HMMFactory.PseudoTransitionElement(new int[]{startState}, new int[]{startState + 1, startState + 2, startState + 3}, new double[]{5.0, 5.0, 5.0}));
        currState += 3;
        ++nameOff;
        int endState = startState + numCTerm * 3 + 1;
        int i = 0;
        while (i < numCTerm - 1) {
            emissions.add(SilentEmission.class);
            emissions.add(DiscreteEmission.class);
            emissions.add(DiscreteEmission.class);
            names.add("D" + nameOff);
            names.add("I" + nameOff);
            names.add("M" + nameOff);
            transitions.add(new HMMFactory.PseudoTransitionElement(new int[]{startState + 1}, new int[]{currState + 1, currState + 3, endState}, new double[]{2.0, 12.0, 1.0}));
            transitions.add(new HMMFactory.PseudoTransitionElement(new int[]{startState + 2}, new int[]{startState + 2, currState + 3}, new double[]{2.0, 13.0}));
            transitions.add(new HMMFactory.PseudoTransitionElement(new int[]{startState + 3}, new int[]{currState + 1, currState + 2, currState + 3}, new double[]{1.0, 1.0, 13.0}));
            currState += 3;
            startState += 3;
            ++nameOff;
            ++i;
        }
        emissions.add(SilentEmission.class);
        names.add("E");
        transitions.add(new HMMFactory.PseudoTransitionElement(new int[]{startState + 1}, new int[]{endState}, new double[]{15.0}));
        transitions.add(new HMMFactory.PseudoTransitionElement(new int[]{startState + 2}, new int[]{endState}, new double[]{15.0}));
        transitions.add(new HMMFactory.PseudoTransitionElement(new int[]{startState + 3}, new int[]{endState}, new double[]{15.0}));
        return endState;
    }
}

