/*
 * Decompiled with CFR 0.152.
 */
package projects.mirnas;

import de.jstacs.NotTrainedException;
import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.DataSet;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.io.NonParsableException;
import de.jstacs.io.XMLParser;
import de.jstacs.sequenceScores.differentiable.logistic.LogisticConstraint;
import de.jstacs.sequenceScores.differentiable.logistic.LogisticDiffSS;
import de.jstacs.sequenceScores.statisticalModels.differentiable.DifferentiableStatisticalModel;
import de.jstacs.utils.DoubleList;
import de.jstacs.utils.IntList;
import de.jstacs.utils.Normalisation;

public class LogisticSSWithPrior
extends LogisticDiffSS
implements DifferentiableStatisticalModel {
    private double var;

    public LogisticSSWithPrior(AlphabetContainer con, int length, double var, LogisticConstraint ... constraint) throws CloneNotSupportedException {
        super(con, length, constraint);
        this.var = var;
    }

    public LogisticSSWithPrior(StringBuffer xml) throws NonParsableException {
        super(xml);
    }

    @Override
    public int getSizeOfEventSpaceForRandomVariablesOfParameter(int index) {
        return 1;
    }

    @Override
    public double getLogNormalizationConstant() {
        return 0.0;
    }

    @Override
    public double getLogPartialNormalizationConstant(int parameterIndex) throws Exception {
        return Double.NEGATIVE_INFINITY;
    }

    @Override
    public double getESS() {
        return 0.0;
    }

    @Override
    public double getLogScoreFor(Sequence seq, int start) {
        double score = super.getLogScoreFor(seq, start);
        score = -Normalisation.getLogSum(0.0, score);
        return score;
    }

    @Override
    public double getLogScoreAndPartialDerivation(Sequence seq, int start, IntList indices, DoubleList partialDer) {
        int start2 = partialDer.length();
        double score = super.getLogScoreAndPartialDerivation(seq, start, indices, partialDer);
        double res = -Normalisation.getLogSum(0.0, score);
        double fac = -Math.exp(score + res);
        partialDer.multiply(start2, partialDer.length(), fac);
        return res;
    }

    @Override
    public double getLogPriorTerm() {
        double lp = 0.0;
        int i = 0;
        while (i < this.parameter.length) {
            lp -= this.parameter[i] * this.parameter[i];
            ++i;
        }
        return lp /= 2.0 * this.var;
    }

    @Override
    public void addGradientOfLogPriorTerm(double[] grad, int start) throws Exception {
        int i = 0;
        while (i < this.parameter.length) {
            int n = start + i;
            grad[n] = grad[n] - this.parameter[i] / this.var;
            ++i;
        }
    }

    @Override
    public boolean isNormalized() {
        return true;
    }

    @Override
    public LogisticSSWithPrior clone() throws CloneNotSupportedException {
        return (LogisticSSWithPrior)super.clone();
    }

    @Override
    public StringBuffer toXML() {
        StringBuffer xml = super.toXML();
        XMLParser.addTags(xml, "super");
        XMLParser.appendObjectWithTags(xml, this.var, "var");
        XMLParser.addTags(xml, "LogisticSSWithPrior");
        return xml;
    }

    @Override
    protected void fromXML(StringBuffer xml) throws NonParsableException {
        xml = XMLParser.extractForTag(xml, "LogisticSSWithPrior");
        super.fromXML(XMLParser.extractForTag(xml, "super"));
        this.var = XMLParser.extractObjectForTags(xml, "var", Double.TYPE);
    }

    @Override
    public double getLogProbFor(Sequence sequence, int startpos, int endpos) throws Exception {
        return this.getLogScoreFor(sequence, startpos, endpos);
    }

    @Override
    public double getLogProbFor(Sequence sequence, int startpos) throws Exception {
        return this.getLogScoreFor(sequence, startpos);
    }

    @Override
    public double getLogProbFor(Sequence sequence) throws Exception {
        return this.getLogScoreFor(sequence);
    }

    @Override
    public DataSet emitDataSet(int numberOfSequences, int ... seqLength) throws NotTrainedException, Exception {
        throw new Exception();
    }

    @Override
    public byte getMaximalMarkovOrder() throws UnsupportedOperationException {
        return 0;
    }
}

