/*
 * Decompiled with CFR 0.152.
 */
package projects.kmermotifs;

import de.jstacs.data.DataSet;
import de.jstacs.data.EmptyDataSetException;
import de.jstacs.data.WrongAlphabetException;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.data.sequences.annotation.SequenceAnnotation;
import de.jstacs.results.Result;
import de.jstacs.utils.ComparableElement;
import de.jstacs.utils.Pair;
import java.util.Arrays;
import java.util.HashMap;
import projects.kmermotifs.PositionStatisticsFunction;

public class KMerStatistic {
    private HashMap<Sequence, KMerEntry> kmers;
    private PositionStatisticsFunction fun;

    public KMerStatistic(DataSet data, double[][] weights, int[] offsets, int k, int maxRequiredMoment, PositionStatisticsFunction fun) throws CloneNotSupportedException {
        this.kmers = new HashMap();
        this.fun = fun.clone();
        HashMap<Sequence, KMerEntry> temp = new HashMap<Sequence, KMerEntry>();
        int i = 0;
        while (i < data.getNumberOfElements()) {
            KMerEntry en;
            Sequence seq = data.getElementAt(i);
            temp.clear();
            int j = 0;
            while (j < seq.getLength() - k + 1) {
                Sequence sub = seq.getSubSequence(j, k);
                en = (KMerEntry)temp.get(sub);
                if (en == null) {
                    en = new KMerEntry(sub, maxRequiredMoment);
                    temp.put(sub, en);
                }
                if (weights[i].length == 1) {
                    en.add(weights[i][0], offsets[i] + j);
                } else {
                    en.add(weights[i][j], offsets[i] + j);
                }
                ++j;
            }
            for (Sequence key : temp.keySet()) {
                en = (KMerEntry)temp.get(key);
                en.norm();
                KMerEntry en2 = this.kmers.get(key);
                if (en2 == null) {
                    en2 = new KMerEntry(key, maxRequiredMoment);
                    this.kmers.put(key, en2);
                }
                en2.add(en);
            }
            ++i;
        }
        System.out.println("size " + this.kmers.size());
    }

    private KMerStatistic(HashMap<Sequence, KMerEntry> kmers, PositionStatisticsFunction fun) {
        this.kmers = kmers;
        this.fun = fun;
    }

    public KMerEntry[] getSortedEntries(Integer topN, KMerStatistic subtract) {
        double totWeightSub = subtract.getTotalWeight();
        double totWeightThis = this.getTotalWeight();
        KMerEntry[] entries = this.kmers.values().toArray(new KMerEntry[0]);
        Object[] el = new ComparableElement[entries.length];
        int i = 0;
        while (i < el.length) {
            KMerEntry temp = subtract.kmers.get(entries[i].getKMer());
            el[i] = new ComparableElement<Integer, Double>(i, (temp == null ? 0.0 : temp.getN() / totWeightSub) - entries[i].getN() / totWeightThis);
            ++i;
        }
        Arrays.sort(el);
        KMerEntry[] res = new KMerEntry[Math.min(topN, entries.length)];
        int i2 = 0;
        while (i2 < res.length) {
            res[i2] = entries[(Integer)((ComparableElement)el[i2]).getElement()];
            System.out.println(res[i2]);
            ++i2;
        }
        return res;
    }

    public KMerEntry[] getSortedEntries(Integer topN) {
        Object[] entries = this.kmers.values().toArray(new KMerEntry[0]);
        Arrays.sort(entries);
        if (topN < entries.length) {
            KMerEntry[] sub = new KMerEntry[topN.intValue()];
            System.arraycopy(entries, 0, sub, 0, topN);
            return sub;
        }
        return entries;
    }

    public Pair<DataSet, double[]> getWeightedDataSet() throws EmptyDataSetException, WrongAlphabetException {
        KMerEntry[] entries = this.kmers.values().toArray(new KMerEntry[0]);
        Sequence[] seqs = new Sequence[entries.length];
        double[] weights = new double[entries.length];
        int i = 0;
        while (i < entries.length) {
            seqs[i] = entries[i].getKMer();
            seqs[i] = seqs[i].annotate(true, new KMerEntrySequenceAnnotation(entries[i]));
            weights[i] = entries[i].n;
            ++i;
        }
        return new Pair<DataSet, double[]>(new DataSet("", seqs), weights);
    }

    public static DataSet getAnnotatedSample(KMerEntry[] entries) throws EmptyDataSetException, WrongAlphabetException {
        Sequence[] seqs = new Sequence[entries.length];
        int i = 0;
        while (i < seqs.length) {
            seqs[i] = entries[i].getKMer();
            seqs[i] = seqs[i].annotate(true, new KMerEntrySequenceAnnotation(entries[i]));
            ++i;
        }
        return new DataSet("", seqs);
    }

    private double getTotalWeight() {
        double totWeight = 0.0;
        for (Sequence seq : this.kmers.keySet()) {
            totWeight += this.kmers.get(seq).n;
        }
        return totWeight;
    }

    public int getNumberOfKMers() {
        return this.kmers.size();
    }

    public KMerStatistic filter(double minW) {
        HashMap<Sequence, KMerEntry> newMap = new HashMap<Sequence, KMerEntry>();
        for (Sequence seq : this.kmers.keySet()) {
            KMerEntry en = this.kmers.get(seq);
            if (!(en.n >= minW)) continue;
            newMap.put(seq, en);
        }
        return new KMerStatistic(newMap, this.fun);
    }

    public KMerStatistic subtract(KMerStatistic sub, double fac) {
        double totWeightSub = sub.getTotalWeight();
        double totWeightThis = this.getTotalWeight();
        HashMap<Sequence, KMerEntry> newMap = new HashMap<Sequence, KMerEntry>();
        for (Sequence seq : this.kmers.keySet()) {
            KMerEntry en = this.kmers.get(seq);
            KMerEntry subEn = sub.kmers.get(seq);
            if (subEn == null) {
                newMap.put(seq, en);
                continue;
            }
            if (!(en.n / totWeightThis > subEn.n / totWeightSub * fac) && !(en.n / totWeightThis < subEn.n / totWeightSub / fac)) continue;
            newMap.put(seq, en);
        }
        return new KMerStatistic(newMap, this.fun);
    }

    public class KMerEntry
    implements Comparable<KMerEntry> {
        private Sequence kmer;
        private Object statistic;
        private double n;
        private int multiplicity;

        public KMerEntry(Sequence seq, int maxRequiredMoment) {
            this.kmer = seq;
            this.n = 0.0;
            this.statistic = KMerStatistic.this.fun.getEmptyStatistics();
            this.multiplicity = 0;
        }

        private void add(double weight, int position) {
            KMerStatistic.this.fun.addToStatistics(this.statistic, position, weight);
            this.n += weight;
            ++this.multiplicity;
        }

        private void norm() {
            KMerStatistic.this.fun.normalize(this.statistic, this.multiplicity);
            this.n /= (double)this.multiplicity;
            this.multiplicity = 1;
        }

        private void add(KMerEntry en) {
            if (!this.kmer.equals(en.kmer)) {
                throw new RuntimeException();
            }
            KMerStatistic.this.fun.addToStatistic(this.statistic, en.statistic);
            this.n += en.n;
            this.multiplicity += en.multiplicity;
        }

        public double getN() {
            return this.n;
        }

        public Sequence getKMer() {
            return this.kmer;
        }

        private int noverk(int n, int k) {
            return this.factorial(n) / (this.factorial(k) * this.factorial(n - k));
        }

        private int factorial(int n) {
            if (n <= 1) {
                return 1;
            }
            return n * this.factorial(n - 1);
        }

        @Override
        public int compareTo(KMerEntry entry) {
            return -((int)Math.signum(this.n - entry.n));
        }

        public String toString() {
            return this.kmer + " " + this.n + " " + KMerStatistic.this.fun.toString(this.statistic);
        }

        public Object getStatistic() {
            return this.statistic;
        }
    }

    public static class KMerEntrySequenceAnnotation
    extends SequenceAnnotation {
        private KMerEntry entry;
        public static final String KEY = "KMerEntry";

        public KMerEntrySequenceAnnotation(KMerEntry entry) {
            super(KEY, "", (Result[][])new Result[0][]);
            this.entry = entry;
        }

        public KMerEntry getEntry() {
            return this.entry;
        }
    }
}

