/*
 * Decompiled with CFR 0.152.
 */
package projects.kmermotifs;

import de.jstacs.data.DataSet;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.io.ArrayHandler;
import de.jstacs.io.NonParsableException;
import de.jstacs.sequenceScores.statisticalModels.differentiable.AbstractDifferentiableStatisticalModel;
import de.jstacs.sequenceScores.statisticalModels.differentiable.homogeneous.HomogeneousDiffSM;
import de.jstacs.utils.DoubleList;
import de.jstacs.utils.IntList;
import de.jstacs.utils.Normalisation;
import de.jstacs.utils.random.DirichletMRG;
import de.jstacs.utils.random.DirichletMRGParams;
import java.text.NumberFormat;
import java.util.Arrays;
import projects.kmermotifs.DeconvolvableDiffSM;

public class DeconvolvedDiffSM
extends AbstractDifferentiableStatisticalModel {
    public DeconvolvableDiffSM[] diffSMs;
    public HomogeneousDiffSM flanking;
    private double[][] shiftsPars;
    double[] motifsProbs;
    private int[] offsets;
    private int shiftLeft;
    private int shiftRight;
    private double ess;
    private double[][] hyps;
    private boolean isInitialized;
    private IntList[][] tempIndices;
    private DoubleList[][] tempPartialDers;
    private boolean learnShifts;

    public DeconvolvedDiffSM(DeconvolvableDiffSM[] diffSMs, HomogeneousDiffSM flanking, double ess, int length, int shiftLeft, int shiftRight, boolean learnShifts) throws CloneNotSupportedException {
        super(diffSMs[0].getAlphabetContainer(), length);
        this.diffSMs = (DeconvolvableDiffSM[])ArrayHandler.clone((Cloneable[])diffSMs);
        this.flanking = (HomogeneousDiffSM)flanking.clone();
        this.shiftLeft = shiftLeft;
        this.shiftRight = shiftRight;
        this.shiftsPars = new double[diffSMs.length][shiftLeft + shiftRight + 1];
        this.hyps = new double[diffSMs.length][shiftLeft + shiftRight + 1];
        this.motifsProbs = new double[diffSMs.length + 1];
        this.offsets = new int[diffSMs.length + 1];
        this.ess = ess;
        int i = 0;
        while (i < diffSMs.length) {
            Arrays.fill(this.hyps[i], diffSMs[i].getESS() / (double)this.hyps[i].length);
            ++i;
        }
        this.tempIndices = new IntList[diffSMs.length + 1][];
        this.tempPartialDers = new DoubleList[diffSMs.length + 1][];
        this.learnShifts = learnShifts;
    }

    @Override
    public DeconvolvedDiffSM clone() throws CloneNotSupportedException {
        DeconvolvedDiffSM clone = (DeconvolvedDiffSM)super.clone();
        clone.diffSMs = (DeconvolvableDiffSM[])ArrayHandler.clone((Cloneable[])this.diffSMs);
        clone.flanking = (HomogeneousDiffSM)this.flanking.clone();
        clone.hyps = (double[][])ArrayHandler.clone((Cloneable[])this.hyps);
        clone.shiftsPars = (double[][])ArrayHandler.clone((Cloneable[])this.shiftsPars);
        clone.motifsProbs = (double[])this.motifsProbs.clone();
        clone.offsets = (int[])this.offsets.clone();
        clone.tempIndices = new IntList[this.diffSMs.length + 2][];
        clone.tempPartialDers = new DoubleList[this.diffSMs.length + 2][];
        return clone;
    }

    @Override
    public int getSizeOfEventSpaceForRandomVariablesOfParameter(int index) {
        if (index < this.motifsProbs.length) {
            return this.motifsProbs.length;
        }
        index -= this.motifsProbs.length;
        int i = 0;
        while (i < this.shiftsPars.length) {
            if (index < this.shiftsPars[i].length) {
                return this.shiftsPars[i].length;
            }
            index -= this.shiftsPars[i].length;
            ++i;
        }
        i = 0;
        while (i < this.diffSMs.length) {
            if (index < this.diffSMs[i].getNumberOfParameters()) {
                return this.diffSMs[i].getSizeOfEventSpaceForRandomVariablesOfParameter(index);
            }
            index -= this.diffSMs[i].getNumberOfParameters();
            ++i;
        }
        return this.flanking.getSizeOfEventSpaceForRandomVariablesOfParameter(index);
    }

    @Override
    public double getLogNormalizationConstant() {
        double[] temp = new double[this.motifsProbs.length];
        int i = 0;
        while (i < this.diffSMs.length) {
            temp[i] = this.motifsProbs[i] + this.getLogNormalizationConstant(i);
            ++i;
        }
        temp[temp.length - 1] = this.motifsProbs[this.motifsProbs.length - 1] + this.flanking.getLogNormalizationConstant(this.length);
        return Normalisation.getLogSum(temp);
    }

    private double getLogNormalizationConstant(int component, int shiftIndex) {
        double temp = 0.0;
        int off = 0;
        if (shiftIndex < this.shiftLeft) {
            off = -(this.shiftLeft - shiftIndex);
            temp = this.flanking.getLogNormalizationConstant(this.length - off - this.diffSMs[component].getLength());
        } else if (shiftIndex > this.shiftLeft) {
            off = shiftIndex - this.shiftLeft;
            temp = this.flanking.getLogNormalizationConstant(off);
        }
        return temp += this.shiftsPars[component][shiftIndex] + this.diffSMs[component].getLogNormalizationConstant(shiftIndex < this.shiftLeft ? this.shiftLeft - shiftIndex : 0, shiftIndex > this.shiftLeft ? shiftIndex - this.shiftLeft : 0);
    }

    private double getLogNormalizationConstant(int component) {
        double[] temp = new double[this.shiftsPars[component].length];
        int i = 0;
        while (i < temp.length) {
            temp[i] = this.getLogNormalizationConstant(component, i);
            ++i;
        }
        return Normalisation.getLogSum(temp);
    }

    @Override
    public double getLogPartialNormalizationConstant(int parameterIndex) throws Exception {
        if (parameterIndex < this.motifsProbs.length - 1) {
            return this.motifsProbs[parameterIndex] + this.getLogNormalizationConstant(parameterIndex);
        }
        if (parameterIndex == this.motifsProbs.length - 1) {
            return this.motifsProbs[parameterIndex] + this.flanking.getLogNormalizationConstant(this.length);
        }
        if (parameterIndex < this.offsets[0]) {
            if (!this.learnShifts) {
                return Double.NEGATIVE_INFINITY;
            }
            parameterIndex -= this.motifsProbs.length;
            int i = 0;
            while (parameterIndex - this.shiftsPars[i].length >= 0) {
                parameterIndex -= this.shiftsPars[i].length;
                ++i;
            }
            return this.motifsProbs[i] + this.getLogNormalizationConstant(i, parameterIndex);
        }
        if (parameterIndex >= this.offsets[this.offsets.length - 1]) {
            double[] temp = new double[this.motifsProbs.length];
            int i = 0;
            while (i < this.diffSMs.length) {
                temp[i] = this.motifsProbs[i] + this.getLogPartialNormalizationConstant(parameterIndex, i);
                ++i;
            }
            temp[temp.length - 1] = this.motifsProbs[this.motifsProbs.length - 1] + this.flanking.getLogPartialNormalizationConstant(parameterIndex - this.offsets[this.offsets.length - 1], this.length);
            return Normalisation.getLogSum(temp);
        }
        int i = 0;
        while (parameterIndex >= this.offsets[i + 1]) {
            ++i;
        }
        return this.motifsProbs[i] + this.getLogPartialNormalizationConstant(parameterIndex, i);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private double getLogPartialNormalizationConstant(int parameterIndex, int component) throws Exception {
        double[] temp = new double[this.shiftsPars[component].length];
        if (parameterIndex < this.offsets[this.offsets.length - 1]) {
            if (parameterIndex < this.offsets[component] || parameterIndex >= this.offsets[component + 1]) throw new RuntimeException(String.valueOf(parameterIndex) + " " + Arrays.toString(this.offsets));
            parameterIndex -= this.offsets[component];
            int i = 0;
            while (i < temp.length) {
                int off = 0;
                if (i < this.shiftLeft) {
                    off = -(this.shiftLeft - i);
                    temp[i] = this.flanking.getLogNormalizationConstant(this.length - off - this.diffSMs[component].getLength());
                } else if (i > this.shiftLeft) {
                    off = i - this.shiftLeft;
                    temp[i] = this.flanking.getLogNormalizationConstant(off);
                }
                int n = i;
                temp[n] = temp[n] + (this.shiftsPars[component][i] + this.diffSMs[component].getLogPartialNormalizationConstant(i < this.shiftLeft ? this.shiftLeft - i : 0, i > this.shiftLeft ? i - this.shiftLeft : 0, parameterIndex));
                ++i;
            }
            return Normalisation.getLogSum(temp);
        } else {
            parameterIndex -= this.offsets[this.offsets.length - 1];
            int i = 0;
            while (i < temp.length) {
                int off = 0;
                if (i < this.shiftLeft) {
                    off = -(this.shiftLeft - i);
                    temp[i] = this.flanking.getLogPartialNormalizationConstant(parameterIndex, this.length - off - this.diffSMs[component].getLength());
                } else if (i > this.shiftLeft) {
                    off = i - this.shiftLeft;
                    temp[i] = this.flanking.getLogPartialNormalizationConstant(parameterIndex, off);
                } else {
                    temp[i] = Double.NEGATIVE_INFINITY;
                }
                int n = i;
                temp[n] = temp[n] + (this.shiftsPars[component][i] + this.diffSMs[component].getLogNormalizationConstant(i < this.shiftLeft ? this.shiftLeft - i : 0, i > this.shiftLeft ? i - this.shiftLeft : 0));
                ++i;
            }
        }
        return Normalisation.getLogSum(temp);
    }

    @Override
    public double getLogPriorTerm() {
        double lp = 0.0;
        double temp = 0.0;
        int i = 0;
        while (i < this.motifsProbs.length - 1) {
            lp += this.diffSMs[i].getESS() * this.motifsProbs[i];
            temp += this.diffSMs[i].getESS();
            ++i;
        }
        lp += (this.ess - temp) * this.motifsProbs[this.motifsProbs.length - 1];
        i = 0;
        while (i < this.shiftsPars.length) {
            int j = 0;
            while (j < this.shiftsPars[i].length) {
                lp += this.hyps[i][j] * this.shiftsPars[i][j];
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < this.diffSMs.length) {
            lp += this.diffSMs[i].getLogPriorTerm();
            ++i;
        }
        return lp += this.flanking.getLogPriorTerm();
    }

    @Override
    public void addGradientOfLogPriorTerm(double[] grad, int start) throws Exception {
        double temp = 0.0;
        int i = 0;
        while (i < this.motifsProbs.length - 1) {
            int n = start++;
            grad[n] = grad[n] + this.diffSMs[i].getESS();
            temp += this.diffSMs[i].getESS();
            ++i;
        }
        int n = start++;
        grad[n] = grad[n] + (this.ess - temp);
        i = 0;
        while (i < this.shiftsPars.length) {
            int j = 0;
            while (j < this.shiftsPars[i].length) {
                if (this.learnShifts) {
                    int n2 = start;
                    grad[n2] = grad[n2] + this.hyps[i][j];
                }
                ++start;
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < this.diffSMs.length) {
            this.diffSMs[i].addGradientOfLogPriorTerm(grad, start);
            start += this.diffSMs[i].getNumberOfParameters();
            ++i;
        }
        this.flanking.addGradientOfLogPriorTerm(grad, start);
    }

    @Override
    public double getESS() {
        return this.ess;
    }

    public double getMotifESS(int motif) {
        return this.diffSMs[motif].getESS();
    }

    public void initializeMotif(DataSet data, double[] weights, int motif) throws Exception {
        this.diffSMs[motif].initializeFunction(0, false, new DataSet[]{data}, new double[][]{weights});
        Arrays.fill(this.shiftsPars[motif], -Math.log(this.shiftsPars[motif].length));
        this.isInitialized = true;
        int i = 0;
        while (i < this.diffSMs.length) {
            this.isInitialized &= this.diffSMs[i].isInitialized();
            ++i;
        }
        if (this.isInitialized) {
            int off = 0;
            double[] hyp = new double[this.motifsProbs.length];
            double temp = 0.0;
            int i2 = 0;
            while (i2 < this.diffSMs.length) {
                hyp[i2] = this.diffSMs[i2].getESS();
                temp += hyp[i2];
                ++i2;
            }
            hyp[hyp.length - 1] = this.ess - temp;
            System.out.println(String.valueOf(Arrays.toString(hyp)) + " " + this.ess);
            off += this.motifsProbs.length;
            i2 = 0;
            while (i2 < this.diffSMs.length) {
                hyp[i2] = Math.log(hyp[i2]) - Math.log(this.ess);
                ++i2;
            }
            hyp[hyp.length - 1] = Math.log(hyp[hyp.length - 1]) - Math.log(this.ess);
            System.arraycopy(hyp, 0, this.motifsProbs, 0, hyp.length);
            i2 = 0;
            while (i2 < this.motifsProbs.length - 1) {
                hyp[i2] = this.motifsProbs[i2] - this.getLogNormalizationConstant(i2) + this.getLogNormalizationConstant();
                ++i2;
            }
            hyp[hyp.length - 1] = this.motifsProbs[this.motifsProbs.length - 1] - this.flanking.getLogNormalizationConstant(this.length) + this.getLogNormalizationConstant();
            System.arraycopy(hyp, 0, this.motifsProbs, 0, hyp.length);
            System.out.println(Arrays.toString(this.motifsProbs));
            i2 = 0;
            while (i2 < this.shiftsPars.length) {
                off += this.shiftsPars[i2].length;
                ++i2;
            }
            i2 = 0;
            while (i2 < this.diffSMs.length) {
                this.offsets[i2] = off;
                off += this.diffSMs[i2].getNumberOfParameters();
                ++i2;
            }
            this.offsets[this.offsets.length - 1] = off;
        }
    }

    @Override
    public void initializeFunction(int index, boolean freeParams, DataSet[] data, double[][] weights) throws Exception {
        this.initializeFunctionRandomly(freeParams);
    }

    @Override
    public void initializeFunctionRandomly(boolean freeParams) throws Exception {
        int off = 0;
        double[] hyp = new double[this.motifsProbs.length];
        double temp = 0.0;
        int i = 0;
        while (i < this.diffSMs.length) {
            hyp[i] = this.diffSMs[i].getESS();
            temp += hyp[i];
            ++i;
        }
        hyp[hyp.length - 1] = this.ess - temp;
        off += this.motifsProbs.length;
        DirichletMRGParams params = new DirichletMRGParams(hyp);
        DirichletMRG.DEFAULT_INSTANCE.generateLog(this.motifsProbs, 0, hyp.length, params);
        int i2 = 0;
        while (i2 < this.shiftsPars.length) {
            if (this.shiftsPars[i2].length > 1 && this.learnShifts) {
                params = new DirichletMRGParams(this.diffSMs[i2].getESS() / (double)this.shiftsPars[i2].length, this.shiftsPars[i2].length);
                DirichletMRG.DEFAULT_INSTANCE.generateLog(this.shiftsPars[i2], 0, this.shiftsPars[i2].length, params);
            } else {
                Arrays.fill(this.shiftsPars[i2], Math.log(1.0 / (double)this.shiftsPars[i2].length));
            }
            off += this.shiftsPars[i2].length;
            ++i2;
        }
        i2 = 0;
        while (i2 < this.diffSMs.length) {
            this.offsets[i2] = off;
            this.diffSMs[i2].initializeFunctionRandomly(freeParams);
            off += this.diffSMs[i2].getNumberOfParameters();
            ++i2;
        }
        this.offsets[this.offsets.length - 1] = off;
        this.flanking.initializeFunctionRandomly(freeParams);
        this.isInitialized = true;
    }

    private double logScoreAndPartialDerivation(int component, Sequence seq, int start, IntList indices, DoubleList partialDer) throws CloneNotSupportedException {
        int j;
        int motifOffset = this.offsets[component];
        int flankingOffset = this.offsets[this.offsets.length - 1];
        if (this.tempIndices[component] == null) {
            this.tempIndices[component] = (IntList[])ArrayHandler.createArrayOf((Cloneable)new IntList(), (int)(this.shiftsPars[component].length * 2));
            this.tempPartialDers[component] = (DoubleList[])ArrayHandler.createArrayOf((Cloneable)new DoubleList(), (int)(this.shiftsPars[component].length * 2));
        } else {
            int i = 0;
            while (i < this.tempIndices[component].length) {
                this.tempIndices[component][i].clear();
                this.tempPartialDers[component][i].clear();
                ++i;
            }
        }
        double[] temp = new double[this.shiftsPars[component].length];
        int i = 0;
        while (i < temp.length) {
            int off = 0;
            if (i < this.shiftLeft) {
                off = -(this.shiftLeft - i);
                temp[i] = this.flanking.getLogScoreAndPartialDerivation(seq, start + off + this.diffSMs[component].getLength(), start + this.length - 1, this.tempIndices[component][this.shiftsPars[component].length + i], this.tempPartialDers[component][this.shiftsPars[component].length + i]);
            } else if (i > this.shiftLeft) {
                off = i - this.shiftLeft;
                temp[i] = this.flanking.getLogScoreAndPartialDerivation(seq, start, start + off - 1, this.tempIndices[component][this.shiftsPars[component].length + i], this.tempPartialDers[component][this.shiftsPars[component].length + i]);
            }
            int n = i;
            temp[n] = temp[n] + (this.shiftsPars[component][i] + this.diffSMs[component].getLogProbAndPartialDerivation(seq, start + off, i < this.shiftLeft ? this.shiftLeft - i : 0, i > this.shiftLeft ? i - this.shiftLeft : 0, this.tempIndices[component][i], this.tempPartialDers[component][i]));
            ++i;
        }
        double score = Normalisation.logSumNormalisation(temp);
        int off = this.motifsProbs.length;
        int i2 = 0;
        while (i2 < component) {
            off += this.shiftsPars[i2].length;
            ++i2;
        }
        i2 = 0;
        while (i2 < this.shiftsPars[component].length) {
            if (this.learnShifts) {
                indices.add(off + i2);
                partialDer.add(temp[i2]);
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < this.shiftsPars[component].length) {
            j = 0;
            while (j < this.tempIndices[component][i2].length()) {
                indices.add(this.tempIndices[component][i2].get(j) + motifOffset);
                partialDer.add(this.tempPartialDers[component][i2].get(j) * temp[i2]);
                ++j;
            }
            ++i2;
        }
        i2 = this.shiftsPars[component].length;
        while (i2 < 2 * this.shiftsPars[component].length) {
            j = 0;
            while (j < this.tempIndices[component][i2].length()) {
                indices.add(this.tempIndices[component][i2].get(j) + flankingOffset);
                partialDer.add(this.tempPartialDers[component][i2].get(j) * temp[i2 - this.shiftsPars[component].length]);
                ++j;
            }
            ++i2;
        }
        return score;
    }

    @Override
    public double getLogScoreAndPartialDerivation(Sequence seq, int start, IntList indices, DoubleList partialDer) {
        try {
            if (this.tempIndices[this.tempIndices.length - 1] == null) {
                this.tempIndices[this.tempIndices.length - 1] = (IntList[])ArrayHandler.createArrayOf((Cloneable)new IntList(), (int)(this.diffSMs.length + 1));
                this.tempPartialDers[this.tempIndices.length - 1] = (DoubleList[])ArrayHandler.createArrayOf((Cloneable)new DoubleList(), (int)(this.diffSMs.length + 1));
            } else {
                int i = 0;
                while (i < this.tempIndices[this.tempIndices.length - 1].length) {
                    this.tempIndices[this.tempIndices.length - 1][i].clear();
                    this.tempPartialDers[this.tempIndices.length - 1][i].clear();
                    ++i;
                }
            }
            double[] temp = new double[this.diffSMs.length + 1];
            int i = 0;
            while (i < this.diffSMs.length) {
                temp[i] = this.motifsProbs[i] + this.logScoreAndPartialDerivation(i, seq, start, this.tempIndices[this.tempIndices.length - 1][i], this.tempPartialDers[this.tempIndices.length - 1][i]);
                ++i;
            }
            temp[temp.length - 1] = this.motifsProbs[this.motifsProbs.length - 1] + this.flanking.getLogScoreAndPartialDerivation(seq, start, start + this.length - 1, this.tempIndices[this.tempIndices.length - 1][this.diffSMs.length], this.tempPartialDers[this.tempIndices.length - 1][this.diffSMs.length]);
            double score = Normalisation.logSumNormalisation(temp);
            int i2 = 0;
            while (i2 < this.motifsProbs.length) {
                indices.add(i2);
                partialDer.add(temp[i2]);
                ++i2;
            }
            i2 = 0;
            while (i2 < temp.length) {
                int j = 0;
                while (j < this.tempIndices[this.tempIndices.length - 1][i2].length()) {
                    indices.add(this.tempIndices[this.tempIndices.length - 1][i2].get(j) + (i2 < this.diffSMs.length ? 0 : this.offsets[this.offsets.length - 1]));
                    partialDer.add(this.tempPartialDers[this.tempIndices.length - 1][i2].get(j) * temp[i2]);
                    ++j;
                }
                ++i2;
            }
            return score;
        }
        catch (CloneNotSupportedException doesnothappen) {
            throw new RuntimeException();
        }
    }

    @Override
    public int getNumberOfParameters() {
        int num = this.motifsProbs.length;
        int i = 0;
        while (i < this.shiftsPars.length) {
            num += this.shiftsPars[i].length;
            ++i;
        }
        i = 0;
        while (i < this.diffSMs.length) {
            num += this.diffSMs[i].getNumberOfParameters();
            ++i;
        }
        return num += this.flanking.getNumberOfParameters();
    }

    @Override
    public double[] getCurrentParameterValues() throws Exception {
        double[] pars = new double[this.getNumberOfParameters()];
        System.arraycopy(this.motifsProbs, 0, pars, 0, this.motifsProbs.length);
        int off = this.motifsProbs.length;
        int i = 0;
        while (i < this.shiftsPars.length) {
            System.arraycopy(this.shiftsPars[i], 0, pars, off, this.shiftsPars[i].length);
            off += this.shiftsPars[i].length;
            ++i;
        }
        i = 0;
        while (i < this.diffSMs.length) {
            System.arraycopy(this.diffSMs[i].getCurrentParameterValues(), 0, pars, off, this.diffSMs[i].getNumberOfParameters());
            off += this.diffSMs[i].getNumberOfParameters();
            ++i;
        }
        System.arraycopy(this.flanking.getCurrentParameterValues(), 0, pars, off, this.flanking.getNumberOfParameters());
        return pars;
    }

    @Override
    public void setParameters(double[] params, int start) {
        System.arraycopy(params, start, this.motifsProbs, 0, this.motifsProbs.length);
        start += this.motifsProbs.length;
        int i = 0;
        while (i < this.shiftsPars.length) {
            if (this.learnShifts) {
                System.arraycopy(params, start, this.shiftsPars[i], 0, this.shiftsPars[i].length);
            }
            start += this.shiftsPars[i].length;
            ++i;
        }
        i = 0;
        while (i < this.diffSMs.length) {
            this.diffSMs[i].setParameters(params, start);
            start += this.diffSMs[i].getNumberOfParameters();
            ++i;
        }
        this.flanking.setParameters(params, start);
    }

    @Override
    public String getInstanceName() {
        return "Deconv";
    }

    private double logScoreFor(int component, Sequence seq, int start) {
        double[] temp = new double[this.shiftsPars[component].length];
        int i = 0;
        while (i < temp.length) {
            int off = 0;
            if (i < this.shiftLeft) {
                off = -(this.shiftLeft - i);
                temp[i] = this.flanking.getLogScoreFor(seq, start + off + this.diffSMs[component].getLength(), start + this.length - 1);
            } else if (i > this.shiftLeft) {
                off = i - this.shiftLeft;
                temp[i] = this.flanking.getLogScoreFor(seq, start, start + off - 1);
            }
            int n = i;
            temp[n] = temp[n] + (this.shiftsPars[component][i] + this.diffSMs[component].getLogProbFor(seq, start + off, i < this.shiftLeft ? this.shiftLeft - i : 0, i > this.shiftLeft ? i - this.shiftLeft : 0));
            ++i;
        }
        return this.motifsProbs[component] + Normalisation.getLogSum(temp);
    }

    @Override
    public double getLogScoreFor(Sequence seq, int start) {
        double[] temp = new double[this.motifsProbs.length];
        int i = 0;
        while (i < this.diffSMs.length) {
            temp[i] = this.logScoreFor(i, seq, start);
            ++i;
        }
        temp[temp.length - 1] = this.motifsProbs[this.motifsProbs.length - 1] + this.flanking.getLogProbFor(seq, start, start + this.length - 1);
        return Normalisation.getLogSum(temp);
    }

    @Override
    public boolean isInitialized() {
        return this.isInitialized;
    }

    @Override
    public StringBuffer toXML() {
        return null;
    }

    @Override
    protected void fromXML(StringBuffer xml) throws NonParsableException {
    }

    @Override
    public String toString() {
        throw new Error("Unresolved compilation problem: \n\tCannot override the final method from AbstractDifferentiableStatisticalModel\n");
    }

    public int getNumberOfMotifs() {
        return this.diffSMs.length;
    }

    public HomogeneousDiffSM getFlankingModel() throws CloneNotSupportedException {
        return (HomogeneousDiffSM)this.flanking.clone();
    }

    public void setFlankingParameters(double[] pars, int start) {
        this.flanking.setParameters(pars, start);
    }

    @Override
    public /* synthetic */ String toString(NumberFormat numberFormat) {
        throw new Error("Unresolved compilation problem: \n\tThe type DeconvolvedDiffSM must implement the inherited abstract method SequenceScore.toString(NumberFormat)\n");
    }
}

