/*
 * Decompiled with CFR 0.152.
 */
package projects.crispr;

import de.jstacs.DataType;
import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.DNADataSet;
import de.jstacs.data.DataSet;
import de.jstacs.data.DiscreteSequenceEnumerator;
import de.jstacs.data.WrongAlphabetException;
import de.jstacs.data.alphabets.Alphabet;
import de.jstacs.data.alphabets.DNAAlphabetContainer;
import de.jstacs.data.alphabets.DiscreteAlphabet;
import de.jstacs.data.alphabets.DoubleSymbolException;
import de.jstacs.data.sequences.IntSequence;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.data.sequences.WrongSequenceTypeException;
import de.jstacs.data.sequences.annotation.SequenceAnnotationParser;
import de.jstacs.data.sequences.annotation.SimpleSequenceAnnotationParser;
import de.jstacs.data.sequences.annotation.StrandedLocatedSequenceAnnotationWithLength;
import de.jstacs.io.NonParsableException;
import de.jstacs.io.SparseStringExtractor;
import de.jstacs.parameters.FileParameter;
import de.jstacs.parameters.Parameter;
import de.jstacs.parameters.ParameterSet;
import de.jstacs.parameters.ParameterSetTagger;
import de.jstacs.parameters.SelectionParameter;
import de.jstacs.parameters.SimpleParameter;
import de.jstacs.parameters.SimpleParameterSet;
import de.jstacs.parameters.validation.NumberValidator;
import de.jstacs.results.Result;
import de.jstacs.utils.Pair;
import de.jstacs.utils.galaxy.GalaxyAdaptor;
import de.jstacs.utils.galaxy.MultilineSimpleParameter;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.PrintWriter;
import java.io.StringReader;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import projects.tals.FastTALENScanner;

public class CRISPRer {
    public static ParameterSet getParameters(boolean flat) throws Exception {
        LinkedList<Parameter> params = new LinkedList<Parameter>();
        MultilineSimpleParameter prots = new MultilineSimpleParameter("Protospacers", "Protospacers (without PAM sequence) to assess genome-wide, FastA format", false, null);
        SimpleParameter ortho = new SimpleParameter(DataType.BOOLEAN, "Unique seeds", "If true, CRISPRer searches for protospacers with unique seeds. Otherwise, it searches for orthogonal seeds.", true, true);
        MultilineSimpleParameter loc = new MultilineSimpleParameter("Chromosomal locations", "The chromosomal locations for which to filter the reported protospacers. " + (flat ? "Enter different location separated by semicolons. Ignored if parameter proto set." : "Different locations separated by semicolons and/or one per line."), false, null);
        SimpleParameter gff = new SimpleParameter(DataType.BOOLEAN, "Use GFF2", "Use GFF2 output format instead of GFF3", true, false);
        SelectionParameter filter = new SelectionParameter(DataType.PARAMETERSET, new String[]{"No filter", "Filter by chromosomal location"}, new Object[]{new SimpleParameterSet(new Parameter[0]), new SimpleParameterSet(loc)}, "Filter", "Define a filter for reported results. If no filter is set, all unique protospacers are reported and assessed. Given chromosomal coordinates, reported protospacers are limited so those overlapping these coordinates." + (flat ? " Ignored if proto is set or unique=false." : ""), true);
        SelectionParameter task = new SelectionParameter(DataType.PARAMETERSET, new String[]{"Find protospacers with unique seeds", "Find orthogonal seeds", "Assess user-defined protospacers"}, new Object[]{new SimpleParameterSet(filter, gff), new SimpleParameterSet(new Parameter[0]), new SimpleParameterSet(prots)}, "CRISPRer task", "CRISPRer can be used for different tasks. First, it can find protospacers with seeds (of the length defined below), which are unqiue in the input genome. Second, it can find protospacers with seeds that are orthogonal to the input genome, i.e., which do not occurr in the input genome. Finally, it can assess a user-specified list of protospacers for genome-wide perfect seed matches, shortened seed matches, and non-optimal matches.", true);
        task.setDefault("Find protospacers with unique seeds");
        if (!flat) {
            params.add(task);
        }
        params.add(new FileParameter("Input data", "The genome for that CRISPR/Cas protospacers/seeds are selected, FastA format", "fasta", true));
        params.add(new SimpleParameter(DataType.INT, "Length", "The length of the protospacer", true, 20));
        params.add(new SimpleParameter(DataType.INT, "Seed length", "The length of the seed at the 3' end of the protospacer", true, new NumberValidator<Integer>(1, flat ? 13 : 12), 12));
        params.add(new SimpleParameter(DataType.STRING, "PAM", "The PAM pattern, all IUPAC DNA symbols allowed", true, "NGG"));
        if (flat) {
            params.add(loc);
            params.add(prots);
            params.add(ortho);
        }
        params.add(new SimpleParameter(DataType.BOOLEAN, "Include PAM", "Include sequence matching PAM pattern in output", true, true));
        if (flat) {
            params.add(new SimpleParameter(DataType.STRING, "Output prefix", "Common prefix of all output files, may include path", true, "./CRISPRer"));
            params.add(gff);
        }
        return new SimpleParameterSet(params.toArray(new Parameter[0]));
    }

    public static void main(String[] args) throws Exception {
        SimpleParameterSet params = (SimpleParameterSet)CRISPRer.getParameters(true);
        ParameterSetTagger pst = new ParameterSetTagger(new String[]{"input", "length", "seed", "pam", "filter", "proto", "unique", "include", "prefix", "gff2"}, params);
        pst.fillParameters("=", args);
        System.err.println("parameters:");
        System.err.println(pst);
        System.err.println("_________________________________");
        if (!params.hasDefaultOrIsSet()) {
            System.err.println("Some of the required parameters are not specified.");
            System.exit(1);
        }
        Result[] ress = CRISPRer.run(params, true);
        CRISPRerResult res2 = (CRISPRerResult)ress[0];
        String outPrefix = (String)params.getParameterForName("Output prefix").getValue();
        if (ress.length > 1) {
            CRISPRerResult res = (CRISPRerResult)ress[1];
            PrintWriter out = new PrintWriter(String.valueOf(outPrefix) + ".gff");
            int n = 0;
            res.reset();
            String line = null;
            while ((line = res.getNextLine(true)) != null) {
                out.println(line);
                ++n;
            }
            out.close();
        }
        PrintWriter out = new PrintWriter(String.valueOf(outPrefix) + ".txt");
        res2.reset();
        String line = null;
        while ((line = res2.getNextLine(true)) != null) {
            out.println(line);
        }
        out.close();
    }

    public static Result[] run(ParameterSet params, boolean flat) throws Exception {
        FastTALENScanner scan = new FastTALENScanner();
        Pair<int[][], DataSet> curr = null;
        StringBuffer lastHeader = new StringBuffer();
        BufferedReader read = new BufferedReader(new FileReader((String)params.getParameterForName("Input data").getValue()));
        int length = (Integer)params.getParameterForName("Length").getValue();
        int seedLength = (Integer)params.getParameterForName("Seed length").getValue();
        String pam = (String)params.getParameterForName("PAM").getValue();
        if (pam.length() > 7) {
            throw new RuntimeException("PAM sequence may be at most 7 bp long");
        }
        String filter = null;
        DataSet protos = null;
        boolean gff3 = true;
        int num = 1;
        if (flat) {
            filter = (String)params.getParameterForName("Chromosomal locations").getValue();
            if (params.getParameterForName("Protospacers").isSet()) {
                protos = new DNADataSet((String)params.getParameterForName("Protospacers").getValue(), '>', new SimpleSequenceAnnotationParser());
            }
            num = (Boolean)params.getParameterForName("Unique seeds").getValue() != false ? 1 : 0;
            gff3 = (Boolean)params.getParameterForName("Use GFF2").getValue() == false;
        } else {
            SimpleParameterSet ps;
            SelectionParameter task = (SelectionParameter)params.getParameterForName("CRISPRer task");
            if (task.isSelected(0)) {
                num = 1;
                ps = (SimpleParameterSet)((SimpleParameterSet)task.getValue()).getParameterForName("Filter").getValue();
                if (ps.getNumberOfParameters() > 0) {
                    Parameter temp = ps.getParameterAt(0);
                    if (temp.getName().equals("Chromosomal locations")) {
                        filter = (String)temp.getValue();
                    } else {
                        read.close();
                        throw new RuntimeException("Unkown filter");
                    }
                }
                gff3 = (Boolean)((SimpleParameterSet)task.getValue()).getParameterForName("Use GFF2").getValue() == false;
            } else if (task.isSelected(1)) {
                num = 0;
            } else if (task.isSelected(2)) {
                num = 1;
                ps = (SimpleParameterSet)task.getValue();
                protos = new DataSet(DNAAlphabetContainer.SINGLETON, new SparseStringExtractor(new BufferedReader(new StringReader((String)ps.getParameterForName("Protospacers").getValue())), '>', "", (SequenceAnnotationParser)new SimpleSequenceAnnotationParser()));
            } else {
                read.close();
                throw new RuntimeException("Unkown task");
            }
        }
        boolean includePam = (Boolean)params.getParameterForName("Include PAM").getValue();
        boolean[] acceptedPAMs = CRISPRer.getPAMs(pam);
        int pamlength = pam.length();
        int[] counts = new int[(int)Math.pow(4.0, seedLength)];
        String[] sid = new String[(int)Math.pow(4.0, seedLength)];
        long[] seqs = new long[(int)Math.pow(4.0, seedLength)];
        Arrays.fill(seqs, -1L);
        int[] pos = new int[(int)Math.pow(4.0, seedLength)];
        long[] powers = new long[length + (includePam ? pamlength : 0)];
        powers[0] = 1L;
        int i = 1;
        while (i < powers.length) {
            powers[i] = powers[i - 1] * 4L;
            ++i;
        }
        int pl = (int)powers[seedLength - 1];
        int pl2 = (int)powers[pam.length() - 1];
        long pl3 = powers[powers.length - 1];
        int off = length - seedLength;
        while ((curr = scan.readNextSequences(1, null, read, lastHeader)) != null) {
            DataSet dat = curr.getSecondElement();
            int[][] offs = curr.getFirstElement();
            int i2 = 0;
            while (i2 < dat.getNumberOfElements()) {
                Sequence seq = dat.getElementAt(i2);
                String id = (String)seq.getSequenceAnnotationByType("unparsed comment line", 0).getResultForName("unparsed comment").getValue();
                id = id.trim();
                boolean rc = false;
                int r = 0;
                while (r < 2) {
                    if (seq.getLength() >= length + pamlength) {
                        int idx = (int)CRISPRer.getIndex(seq, off, seedLength, powers);
                        idx -= seq.discreteVal(length - 1) * pl;
                        idx *= 4;
                        int idx2 = (int)CRISPRer.getIndex(seq, length, pamlength, powers);
                        idx2 -= seq.discreteVal(length + pamlength - 1) * pl2;
                        idx2 *= 4;
                        long idx3 = CRISPRer.getIndex(seq, 0, length + (includePam ? pamlength : 0), powers);
                        idx3 -= (long)seq.discreteVal(length - 1 + (includePam ? pamlength : 0)) * pl3;
                        idx3 *= 4L;
                        int j = off;
                        int l = length - 1;
                        int k = length + pamlength - 1;
                        int m = length - 1 + (includePam ? pamlength : 0);
                        while (j < seq.getLength() - length - pamlength + 1) {
                            idx = idx / 4 + seq.discreteVal(l) * pl;
                            idx2 = idx2 / 4 + seq.discreteVal(k) * pl2;
                            idx3 = idx3 / 4L + (long)seq.discreteVal(m) * pl3;
                            if (acceptedPAMs[idx2]) {
                                int n = idx;
                                counts[n] = counts[n] + 1;
                                if (counts[idx] == num) {
                                    sid[idx] = id;
                                    pos[idx] = rc ? -(offs[0][i2] + (seq.getLength() - (j - off) - 1 - (length + 1 + (includePam ? pamlength : 0)))) - 1 : offs[0][i2] + (j - off);
                                    seqs[idx] = idx3;
                                }
                            }
                            ++j;
                            ++l;
                            ++k;
                            ++m;
                        }
                    }
                    seq = seq.reverseComplement();
                    rc = true;
                    ++r;
                }
                ++i2;
            }
        }
        Integer[] order = CRISPRer.getOrder(sid, pos);
        CRISPRerResult res2 = new CRISPRerResult("CRISPRer result", "", counts, sid, seqs, pos, Format.TAB, filter, protos, powers, seedLength, num, length, pam, pamlength, includePam, order);
        if (protos == null && num == 1) {
            CRISPRerResult res = new CRISPRerResult("CRISPRer result", "", counts, sid, seqs, pos, gff3 ? Format.GFF3 : Format.GFF2, filter, protos, powers, seedLength, num, length, pam, pamlength, includePam, order);
            return new Result[]{res2, res};
        }
        return new Result[]{res2};
    }

    private static Integer[] getOrder(final String[] sid, final int[] pos) {
        Integer[] order = new Integer[sid.length];
        int i = 0;
        while (i < order.length) {
            order[i] = i;
            ++i;
        }
        Arrays.sort(order, new Comparator<Integer>(){

            @Override
            public int compare(Integer o1, Integer o2) {
                if (sid[o1] == null || sid[o2] == null) {
                    if (sid[o1] == null && sid[o2] == null) {
                        return 0;
                    }
                    if (sid[o1] == null) {
                        return -1;
                    }
                    return 1;
                }
                int c = sid[o1].compareTo(sid[o2]);
                if (c == 0) {
                    int pos1 = pos[o1];
                    int pos2 = pos[o2];
                    if (pos1 < 0) {
                        pos1 = -pos1 + 1;
                    }
                    if (pos2 < 0) {
                        pos2 = -pos2 + 1;
                    }
                    c = pos1 == pos2 ? 0 : (pos1 > pos2 ? 1 : -1);
                }
                return c;
            }
        });
        return order;
    }

    public static int[] getAway(int idx, int[] seq, long[] powers, int[] counts) {
        CRISPRer.decode(seq, idx, powers);
        int sum = 0;
        int sum2 = 0;
        int sum3 = 0;
        int sum4 = 0;
        int sum5 = 0;
        int i = 0;
        while (i < seq.length) {
            int temp = idx;
            temp = (int)((long)temp - (long)seq[i] * powers[i]);
            int j = 0;
            while (j < 4) {
                int temp2 = temp + j * (int)powers[i];
                sum += counts[temp2];
                if (i == 0) {
                    sum3 += counts[temp2];
                }
                int k = i + 1;
                while (k < seq.length) {
                    if (k != i) {
                        int temp3 = temp2 - seq[k] * (int)powers[k];
                        int l = 0;
                        while (l < 4) {
                            int temp4 = temp3 + l * (int)powers[k];
                            sum2 += counts[temp4];
                            if (i == 0 && k == 1) {
                                sum4 += counts[temp4];
                                int temp5 = temp4 - seq[2] * (int)powers[2];
                                int m = 0;
                                while (m < 4) {
                                    int temp6 = temp5 + m * (int)powers[2];
                                    sum5 += counts[temp6];
                                    ++m;
                                }
                            }
                            ++l;
                        }
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return new int[]{sum, sum2, sum3, sum4, sum5};
    }

    private static String getSequence(long idx, int length, long[] powers) throws WrongAlphabetException, WrongSequenceTypeException {
        int[] seq = new int[length];
        CRISPRer.decode(seq, idx, powers);
        return new IntSequence((AlphabetContainer)DNAAlphabetContainer.SINGLETON, seq).toString();
    }

    private static void decode(int[] seq, long idx, long[] powers) {
        int i = seq.length - 1;
        while (i >= 0) {
            int sym;
            seq[i] = sym = (int)(idx / powers[i]);
            idx %= powers[i];
            --i;
        }
    }

    private static boolean[] getPAMs(String pams) throws IllegalArgumentException, WrongAlphabetException, DoubleSymbolException {
        Sequence pam = Sequence.create(new AlphabetContainer((Alphabet)new DiscreteAlphabet(true, "A", "C", "G", "T", "N", "S", "W", "R", "Y", "M", "K", "B", "D", "H", "V")), pams);
        int[][] nArrayArray = new int[15][];
        nArrayArray[0] = new int[1];
        nArrayArray[1] = new int[]{1};
        nArrayArray[2] = new int[]{2};
        nArrayArray[3] = new int[]{3};
        int[] nArray = new int[4];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        nArrayArray[4] = nArray;
        nArrayArray[5] = new int[]{1, 2};
        int[] nArray2 = new int[2];
        nArray2[1] = 3;
        nArrayArray[6] = nArray2;
        int[] nArray3 = new int[2];
        nArray3[1] = 2;
        nArrayArray[7] = nArray3;
        nArrayArray[8] = new int[]{1, 3};
        int[] nArray4 = new int[2];
        nArray4[1] = 1;
        nArrayArray[9] = nArray4;
        nArrayArray[10] = new int[]{2, 3};
        nArrayArray[11] = new int[]{1, 2, 3};
        int[] nArray5 = new int[3];
        nArray5[1] = 2;
        nArray5[2] = 3;
        nArrayArray[12] = nArray5;
        int[] nArray6 = new int[3];
        nArray6[1] = 1;
        nArray6[2] = 3;
        nArrayArray[13] = nArray6;
        int[] nArray7 = new int[3];
        nArray7[1] = 1;
        nArray7[2] = 2;
        nArrayArray[14] = nArray7;
        int[][] map = nArrayArray;
        boolean[] accept = new boolean[(int)Math.pow(4.0, pams.length())];
        DiscreteSequenceEnumerator en = new DiscreteSequenceEnumerator(DNAAlphabetContainer.SINGLETON, pams.length(), false);
        int[][] pama = new int[pam.getLength()][];
        int i = 0;
        while (i < pam.getLength()) {
            pama[i] = map[pam.discreteVal(i)];
            ++i;
        }
        int k = -1;
        block1: while (en.hasMoreElements()) {
            ++k;
            Object curr = en.nextElement();
            int i2 = 0;
            while (i2 < pama.length) {
                boolean found = false;
                int v = ((Sequence)curr).discreteVal(i2);
                int j = 0;
                while (j < pama[i2].length) {
                    if (pama[i2][j] == v) {
                        found = true;
                    }
                    ++j;
                }
                if (!found) continue block1;
                ++i2;
            }
            accept[k] = true;
        }
        return accept;
    }

    private static long getIndex(Sequence seq, int off, int length, long[] powers) {
        long idx = 0L;
        int i = 0;
        while (i < length) {
            idx += (long)seq.discreteVal(off + i) * powers[i];
            ++i;
        }
        return idx;
    }

    private static class CRISPRerResult
    extends GalaxyAdaptor.LineBasedResult {
        private int[] counts;
        private String[] sid;
        private long[] seqs;
        private int[] pos;
        private Format format;
        private int curr;
        private ChromLocs chromLocs;
        private DataSet protos;
        private long[] powers;
        private int seedLength;
        private int num;
        private String pam;
        private int length;
        private int pamlength;
        private boolean includePam;
        private int[] temp;
        private Integer[] order;

        protected CRISPRerResult(String name, String comment, int[] counts, String[] sid, long[] seqs, int[] pos, Format format, String filter, DataSet protos, long[] powers, int seedLength, int num, int length, String pam, int pamLength, boolean includePam, Integer[] order) {
            super(name, comment, DataType.STRING);
            this.counts = counts;
            this.sid = sid;
            this.seqs = seqs;
            this.pos = pos;
            this.format = format;
            this.curr = -1;
            this.chromLocs = new ChromLocs(filter);
            this.order = order;
            if (this.chromLocs.defined()) {
                this.protos = null;
            } else if (protos != null) {
                this.protos = protos;
                Integer[] protoIdx = new Integer[protos.getNumberOfElements()];
                int i = 0;
                while (i < protos.getNumberOfElements()) {
                    Sequence seq = protos.getElementAt(i);
                    if (seq.getLength() < seedLength) {
                        throw new RuntimeException("Protospacer " + i + " is shorter than seed length.");
                    }
                    Sequence sub = seq.getSubSequence(seq.getLength() - seedLength);
                    int idx = (int)CRISPRer.getIndex(sub, 0, seedLength, powers);
                    protoIdx[i] = idx;
                    ++i;
                }
                this.order = protoIdx;
            }
            this.powers = powers;
            this.seedLength = seedLength;
            this.num = num;
            this.length = length;
            this.pam = pam;
            this.pamlength = pamLength;
            this.includePam = includePam;
            this.temp = new int[seedLength];
        }

        @Override
        public void reset() {
            this.curr = 0;
        }

        @Override
        public String getNextLine(boolean forExport) {
            if (this.curr == -1) {
                if (this.format == Format.GFF2) {
                    return "##gff-version 2";
                }
                if (this.format == Format.GFF3) {
                    return "##gff-version 3";
                }
                ++this.curr;
            }
            String nn = "";
            if (this.num == 0) {
                StringBuffer sb = new StringBuffer();
                int i = this.seedLength;
                while (i < this.length) {
                    sb.append("N");
                    ++i;
                }
                nn = sb.toString();
            }
            while (this.curr < this.order.length) {
                if (this.counts[this.order[this.curr]] == this.num || this.protos != null) {
                    int start = this.pos[this.order[this.curr]] + 1;
                    StrandedLocatedSequenceAnnotationWithLength.Strand strand = StrandedLocatedSequenceAnnotationWithLength.Strand.FORWARD;
                    if (start < 0) {
                        start = -this.pos[this.order[this.curr]] + 1 + 1;
                        strand = StrandedLocatedSequenceAnnotationWithLength.Strand.REVERSE;
                    }
                    String id = this.sid[this.order[this.curr]];
                    int end = start + this.length + (this.includePam ? this.pamlength : 0) - 1;
                    if (this.num == 0 || this.protos != null) {
                        id = "NA";
                        if (this.protos != null) {
                            id = (String)this.protos.getElementAt(this.curr).getSequenceAnnotationByType("unparsed comment line", 0).getResultForName("unparsed comment").getValue();
                            id.replaceAll("\t", " ");
                        }
                        start = 0;
                        end = 0;
                        strand = StrandedLocatedSequenceAnnotationWithLength.Strand.UNKNOWN;
                    }
                    if (this.chromLocs.contained(this.sid[this.order[this.curr]], start, end)) {
                        int[] away = CRISPRer.getAway(this.order[this.curr], this.temp, this.powers, this.counts);
                        StringBuffer sb = new StringBuffer();
                        String seq = null;
                        try {
                            seq = this.num == 0 && this.seqs[this.order[this.curr]] < 0L ? String.valueOf(nn) + CRISPRer.getSequence(this.order[this.curr].intValue(), this.seedLength, this.powers) + (this.includePam ? this.pam : "") : (this.num == 1 && this.protos == null ? CRISPRer.getSequence(this.seqs[this.order[this.curr]], this.length + (this.includePam ? this.pamlength : 0), this.powers) : String.valueOf(this.protos.getElementAt(this.curr).toString()) + (this.includePam ? this.pam : ""));
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        if (this.format == Format.TAB) {
                            sb.append(id);
                            sb.append("\t");
                            sb.append(start);
                            sb.append("\t");
                            sb.append(end);
                            sb.append("\t");
                            sb.append(strand == StrandedLocatedSequenceAnnotationWithLength.Strand.FORWARD ? "+\t" : (strand == StrandedLocatedSequenceAnnotationWithLength.Strand.REVERSE ? "-\t" : ".\t"));
                            sb.append(seq);
                            sb.append("\t");
                            sb.append(this.counts[this.order[this.curr]]);
                            sb.append("\t");
                            sb.append(away[2]);
                            sb.append("\t");
                            sb.append(away[3]);
                            sb.append("\t");
                            sb.append(away[4]);
                            sb.append("\t");
                            sb.append(away[0]);
                            sb.append("\t");
                            sb.append(away[1]);
                        } else {
                            sb.append(id);
                            sb.append("\t");
                            sb.append("CRISPRer");
                            sb.append("\t");
                            sb.append("region");
                            sb.append("\t");
                            sb.append(start);
                            sb.append("\t");
                            sb.append(end);
                            sb.append("\t");
                            sb.append(away[0]);
                            sb.append("\t");
                            sb.append(strand == StrandedLocatedSequenceAnnotationWithLength.Strand.FORWARD ? "+\t" : (strand == StrandedLocatedSequenceAnnotationWithLength.Strand.REVERSE ? "-\t" : ".\t"));
                            sb.append(".\t");
                            if (this.format == Format.GFF3) {
                                sb.append("ID=CRISPRer");
                                sb.append(this.order[this.curr]);
                                sb.append("; Name=CRISPRer_target");
                                sb.append(this.order[this.curr]);
                                sb.append("; Note=site:");
                                sb.append(seq);
                                sb.append(" one_nucleotide_away:");
                                sb.append(away[0]);
                                sb.append(" one_nucleotide_shorter:");
                                sb.append(away[2]);
                                sb.append(";");
                            } else if (this.format == Format.GFF2) {
                                sb.append("CRISPRer");
                                sb.append(this.order[this.curr]);
                                sb.append("; Note \"site:");
                                sb.append(seq);
                                sb.append("\"; Note \"one_nucleotide_away:");
                                sb.append(away[0]);
                                sb.append("\"; Note \"one_nucleotide_shorter:");
                                sb.append(away[2]);
                                sb.append("\";");
                            }
                        }
                        ++this.curr;
                        return sb.toString();
                    }
                }
                ++this.curr;
            }
            return null;
        }

        @Override
        public String getXMLTag() {
            return this.getClass().getSimpleName();
        }

        @Override
        protected void appendFurtherInfos(StringBuffer buf) {
            throw new RuntimeException();
        }

        @Override
        protected void extractFurtherInfos(StringBuffer buf) throws NonParsableException {
            throw new RuntimeException();
        }

        @Override
        public Object getValue() {
            return "[CRISPR result]";
        }

        private static class ChromLocs {
            private String[] chrs;
            private int[] starts;
            private int[] ends;

            public ChromLocs(String locs) {
                if (locs == null || "null".equals(locs) || locs.trim().length() == 0) {
                    this.chrs = new String[0];
                    this.starts = new int[0];
                    this.ends = new int[0];
                } else {
                    String[] parts = locs.split("[\\n\\;]");
                    LinkedList<String> chrs = new LinkedList<String>();
                    LinkedList<int[]> pos = new LinkedList<int[]>();
                    int i = 0;
                    while (i < parts.length) {
                        parts[i] = parts[i].trim();
                        if (parts[i].length() > 0) {
                            String[] parts2 = parts[i].split("[\\:\\-]");
                            chrs.add(parts2[0]);
                            pos.add(new int[]{Integer.parseInt(parts2[1].replaceAll("[\\,\\s]", "")), Integer.parseInt(parts2[2].replaceAll("[\\,\\s]", ""))});
                        }
                        ++i;
                    }
                    this.chrs = chrs.toArray(new String[0]);
                    this.starts = new int[pos.size()];
                    this.ends = new int[pos.size()];
                    Iterator it = pos.iterator();
                    int i2 = 0;
                    while (it.hasNext()) {
                        int[] temp = (int[])it.next();
                        this.starts[i2] = temp[0];
                        this.ends[i2] = temp[1];
                        ++i2;
                    }
                }
            }

            public boolean defined() {
                return this.chrs.length > 0;
            }

            public boolean contained(String chr, int start, int end) {
                if (this.chrs.length == 0) {
                    return true;
                }
                int i = 0;
                while (i < this.chrs.length) {
                    if (this.chrs[i].equals(chr) && (start >= this.starts[i] && start <= this.ends[i] || end >= this.starts[i] && end <= this.ends[i])) {
                        return true;
                    }
                    ++i;
                }
                return false;
            }
        }
    }

    private static enum Format {
        GFF3,
        GFF2,
        TAB;

    }
}

