/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio;

import java.util.Collection;
import java.util.Iterator;
import org.biojava.bio.CardinalityConstraint;
import org.biojava.bio.NoneCollectionConstraint;
import org.biojava.bio.PropertyConstraint;
import org.biojava.bio.symbol.Location;

public interface CollectionConstraint {
    public static final CollectionConstraint ANY = new AllValuesIn(PropertyConstraint.ANY, CardinalityConstraint.ANY);
    public static final CollectionConstraint EMPTY = new AllValuesIn(PropertyConstraint.NONE, CardinalityConstraint.ZERO);
    public static final CollectionConstraint NONE = new NoneCollectionConstraint();

    public boolean accept(Object var1);

    public boolean subConstraintOf(CollectionConstraint var1);

    public boolean validateAddValue(Collection var1, Object var2);

    public boolean validateRemoveValue(Collection var1, Object var2);

    public static class Or
    implements CollectionConstraint {
        private CollectionConstraint c1;
        private CollectionConstraint c2;

        public Or(CollectionConstraint c1, CollectionConstraint c2) {
            this.c1 = c1;
            this.c2 = c2;
        }

        public CollectionConstraint getChild1() {
            return this.c1;
        }

        public CollectionConstraint getChild2() {
            return this.c2;
        }

        public boolean accept(Object object) {
            return this.c1.accept(object) || this.c2.accept(object);
        }

        public boolean subConstraintOf(CollectionConstraint pc) {
            return this.c1.subConstraintOf(pc) || this.c2.subConstraintOf(pc);
        }

        public boolean validateAddValue(Collection oldcoll, Object newvalue) {
            return this.c1.validateAddValue(oldcoll, newvalue) || this.c2.validateAddValue(oldcoll, newvalue);
        }

        public boolean validateRemoveValue(Collection oldcoll, Object victim) {
            return this.c1.validateAddValue(oldcoll, victim) || this.c2.validateAddValue(oldcoll, victim);
        }

        public String toString() {
            return "Or(" + this.c1 + ", " + this.c2 + ")";
        }
    }

    public static class And
    implements CollectionConstraint {
        private CollectionConstraint c1;
        private CollectionConstraint c2;

        public And(CollectionConstraint c1, CollectionConstraint c2) {
            this.c1 = c1;
            this.c2 = c2;
        }

        public CollectionConstraint getChild1() {
            return this.c1;
        }

        public CollectionConstraint getChild2() {
            return this.c2;
        }

        public boolean accept(Object object) {
            return this.c1.accept(object) && this.c2.accept(object);
        }

        public boolean subConstraintOf(CollectionConstraint pc) {
            return this.c1.subConstraintOf(pc) && this.c2.subConstraintOf(pc);
        }

        public boolean validateAddValue(Collection oldcoll, Object newvalue) {
            return this.c1.validateAddValue(oldcoll, newvalue) && this.c2.validateAddValue(oldcoll, newvalue);
        }

        public boolean validateRemoveValue(Collection oldcoll, Object victim) {
            return this.c1.validateAddValue(oldcoll, victim) && this.c2.validateAddValue(oldcoll, victim);
        }

        public String toString() {
            return "And(" + this.c1 + ", " + this.c2 + ")";
        }
    }

    public static class Contains
    implements CollectionConstraint {
        private PropertyConstraint pc;
        private Location card;

        public Contains(PropertyConstraint pc, Location card) {
            this.pc = pc;
            this.card = card;
        }

        public PropertyConstraint getPropertyConstraint() {
            return this.pc;
        }

        public Location getCardinalityConstraint() {
            return this.card;
        }

        public boolean accept(Object o) {
            if (o instanceof Collection) {
                return this.card.contains(this.countMembers((Collection)o));
            }
            if (this.pc.accept(o)) {
                return this.card.contains(1);
            }
            return this.card.contains(0);
        }

        private int countMembers(Collection co) {
            int members = 0;
            Iterator i = co.iterator();
            while (i.hasNext()) {
                if (!this.pc.accept(i.next())) continue;
                ++members;
            }
            return members;
        }

        public int hashCode() {
            return this.pc.hashCode() + 178;
        }

        public boolean equals(Object o) {
            if (o instanceof Contains) {
                Contains avo = (Contains)o;
                return ((Object)avo.getCardinalityConstraint()).equals(this.getCardinalityConstraint()) && avo.getPropertyConstraint().equals(this.getPropertyConstraint());
            }
            return false;
        }

        public boolean validateAddValue(Collection oldCol, Object newValue) {
            int members = this.countMembers(oldCol);
            if (this.pc.accept(newValue)) {
                ++members;
            }
            return this.card.contains(members);
        }

        public boolean validateRemoveValue(Collection oldCol, Object newValue) {
            int members = this.countMembers(oldCol);
            if (this.pc.accept(newValue)) {
                --members;
            }
            return this.card.contains(members);
        }

        public boolean subConstraintOf(CollectionConstraint cc) {
            if (cc instanceof NoneCollectionConstraint) {
                return true;
            }
            if (cc instanceof AllValuesIn) {
                AllValuesIn ccavi = (AllValuesIn)cc;
                return this.getCardinalityConstraint().contains(ccavi.getCardinalityConstraint()) && this.getPropertyConstraint().subConstraintOf(ccavi.getPropertyConstraint());
            }
            if (cc instanceof Contains) {
                Contains ccavi = (Contains)cc;
                return this.getCardinalityConstraint().contains(ccavi.getCardinalityConstraint()) && this.getPropertyConstraint().subConstraintOf(ccavi.getPropertyConstraint());
            }
            if (cc instanceof And) {
                And cca = (And)cc;
                return this.subConstraintOf(cca.getChild1()) || this.subConstraintOf(cca.getChild2());
            }
            if (cc instanceof Or) {
                Or cco = (Or)cc;
                return this.subConstraintOf(cco.getChild1()) && this.subConstraintOf(cco.getChild2());
            }
            return false;
        }

        public String toString() {
            return "Contains: (" + this.pc.toString() + ", " + this.card.toString() + ")";
        }
    }

    public static class AllValuesIn
    implements CollectionConstraint {
        private PropertyConstraint pc;
        private Location card;

        public AllValuesIn(PropertyConstraint pc, Location card) {
            this.pc = pc;
            this.card = card;
        }

        public PropertyConstraint getPropertyConstraint() {
            return this.pc;
        }

        public Location getCardinalityConstraint() {
            return this.card;
        }

        public boolean accept(Object o) {
            if (o instanceof Collection) {
                Collection co = (Collection)o;
                if (!this.card.contains(co.size())) {
                    return false;
                }
                Iterator i = co.iterator();
                while (i.hasNext()) {
                    if (this.pc.accept(i.next())) continue;
                    return false;
                }
                return true;
            }
            return this.card.contains(1) && this.pc.accept(o);
        }

        public boolean validateAddValue(Collection oldcol, Object newValue) {
            if (!this.pc.accept(newValue)) {
                return false;
            }
            if (!this.card.contains(oldcol.size() + 1)) {
                return false;
            }
            Iterator i = oldcol.iterator();
            while (i.hasNext()) {
                if (this.pc.accept(i.next())) continue;
                return false;
            }
            return true;
        }

        public boolean validateRemoveValue(Collection oldcol, Object victim) {
            if (!this.card.contains(oldcol.size() - 1)) {
                return false;
            }
            for (Object o : oldcol) {
                if (o.equals(victim) || this.pc.accept(o)) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            return this.pc.hashCode() + 87;
        }

        public boolean equals(Object o) {
            if (o instanceof AllValuesIn) {
                AllValuesIn avo = (AllValuesIn)o;
                return ((Object)avo.getCardinalityConstraint()).equals(this.getCardinalityConstraint()) && avo.getPropertyConstraint().equals(this.getPropertyConstraint());
            }
            return false;
        }

        public boolean subConstraintOf(CollectionConstraint cc) {
            if (cc instanceof NoneCollectionConstraint) {
                return true;
            }
            if (cc instanceof AllValuesIn) {
                AllValuesIn ccavi = (AllValuesIn)cc;
                return this.getCardinalityConstraint().contains(ccavi.getCardinalityConstraint()) && this.getPropertyConstraint().subConstraintOf(ccavi.getPropertyConstraint());
            }
            if (cc instanceof Contains) {
                if (!this.getCardinalityConstraint().contains(Integer.MAX_VALUE)) {
                    return false;
                }
                Contains ccc = (Contains)cc;
                return this.getPropertyConstraint().subConstraintOf(ccc.getPropertyConstraint());
            }
            if (cc instanceof And) {
                And cca = (And)cc;
                return this.subConstraintOf(cca.getChild1()) || this.subConstraintOf(cca.getChild2());
            }
            if (cc instanceof Or) {
                Or cco = (Or)cc;
                return this.subConstraintOf(cco.getChild1()) && this.subConstraintOf(cco.getChild2());
            }
            return false;
        }

        public String toString() {
            return "AllValuesIn: (" + this.pc.toString() + ", " + this.card.toString() + ")";
        }
    }
}

