/*
 * Decompiled with CFR 0.152.
 */
package dimont;

import de.jstacs.DataType;
import de.jstacs.parameters.Parameter;
import de.jstacs.parameters.ParameterSet;
import de.jstacs.parameters.SimpleParameter;
import de.jstacs.parameters.validation.NumberValidator;

class ChipperParameterSet
extends ParameterSet {
    public static final String HOME = "home";
    public static final String FG = "fg";
    public static final String INFIX = "infix";
    public static final String LENGTH = "length";
    public static final String MOTIFS = "motifs";
    public static final String STARTS = "starts";
    public static final String FLANKING_ORDER = "flankOrder";
    public static final String POSITION_TAG = "position";
    public static final String VALUE_TAG = "value";
    public static final String WEIGHTING_FACTOR = "weightingFactor";
    public static final String THREADS = "threads";
    static final String[] PREFIX = new String[]{"home", "fg", "infix", "length", "motifs", "starts", "flankOrder", "position", "value", "weightingFactor", "threads"};

    public ChipperParameterSet() throws Exception {
        this.parameters.add(new Parameter[]{new SimpleParameter(DataType.STRING, "home directory", "the path to the data directory", true, "./")});
        this.parameters.add(new Parameter[]{new SimpleParameter(DataType.STRING, "foreground file", "the file name of the foreground data file (the file containing sequences which are expected to contain binding sites of a common motif)", true)});
        this.parameters.add(new Parameter[]{new SimpleParameter(DataType.STRING, INFIX, "an infix to be used for all output file (XML, PDF, ...)", true)});
        this.parameters.add(new Parameter[]{new SimpleParameter(DataType.INT, "initial motif length", "the motif length that is used at the beginning", true, new NumberValidator<Integer>(1, 50), 15)});
        this.parameters.add(new Parameter[]{new SimpleParameter(DataType.INT, "number of motifs", "the number of motifs to be searched for", true, new NumberValidator<Integer>(1, 5), 1)});
        this.parameters.add(new Parameter[]{new SimpleParameter(DataType.INT, STARTS, "the number of starts in preoptimization", true, new NumberValidator<Integer>(1, 100), 3)});
        this.parameters.add(new Parameter[]{new SimpleParameter(DataType.INT, "Markov order for background models", "the Markov order of the model for the background sequence and the background sequence", true, new NumberValidator<Integer>(-1, 5), -1)});
        this.parameters.add(new Parameter[]{new SimpleParameter(DataType.STRING, "position tag", "the tag for the position information in the foreground data file", true)});
        this.parameters.add(new Parameter[]{new SimpleParameter(DataType.STRING, "value tag", "the tag for the value information in the foreground data file", true)});
        this.parameters.add(new Parameter[]{new SimpleParameter(DataType.STRING, "weighting factor", " the value for weighting the data; either a value between 0 and 1, or a description relative to the standard deviation (e.g. +4sd)", true, "0.2")});
        this.parameters.add(new Parameter[]{new SimpleParameter(DataType.INT, "compute threads", "the number of threads that are use to evaluate the objective function and its gradient", false, new NumberValidator<Integer>(1, 128))});
    }
}

