/*
 * Decompiled with CFR 0.152.
 */
package dimont;

import challenges.dream5.Interpolation;
import de.jstacs.classifiers.differentiableSequenceScoreBased.gendismix.GenDisMixClassifier;
import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.DataSet;
import de.jstacs.data.alphabets.DNAAlphabetContainer;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.data.sequences.SparseSequence;
import de.jstacs.data.sequences.annotation.SequenceAnnotation;
import de.jstacs.data.sequences.annotation.SplitSequenceAnnotationParser;
import de.jstacs.io.FileManager;
import de.jstacs.motifDiscovery.SignificantMotifOccurrencesFinder;
import de.jstacs.parameters.ParameterSetTagger;
import de.jstacs.results.Result;
import de.jstacs.utils.Pair;
import de.jstacs.utils.ToolBox;
import dimont.ChIPperPredictorBgParameterSet;
import dimont.ThresholdedStrandChIPper;
import java.io.File;
import java.util.Arrays;

public class ChIPperPredictorBgCount {
    public static void main(String[] args) throws Exception {
        ParameterSetTagger cParams = new ParameterSetTagger(ChIPperPredictorBgParameterSet.PREFIX, new ChIPperPredictorBgParameterSet());
        cParams.fillParameters("=", args);
        System.out.println("parameters:");
        System.out.println(cParams);
        System.out.println("_________________________________");
        if (!cParams.hasDefaultOrIsSet()) {
            System.out.println("Some of the required parameters are not specified.");
            System.exit(1);
        }
        String home = cParams.getValueFromTag("home", String.class);
        String fgData = String.valueOf(home) + File.separator + cParams.getValueFromTag("fg", String.class);
        String bgData = String.valueOf(home) + File.separator + cParams.getValueFromTag("bg", String.class);
        String infix = cParams.getValueFromTag("infix", String.class);
        String value = cParams.getValueFromTag("value", String.class);
        String weightingFactor = cParams.getValueFromTag("weightingFactor", String.class);
        String chipper = cParams.getValueFromTag("chipper", String.class);
        double pval = cParams.getValueFromTag("p-value", Double.class);
        GenDisMixClassifier cl = new GenDisMixClassifier(FileManager.readFile(chipper));
        ThresholdedStrandChIPper model = (ThresholdedStrandChIPper)cl.getDifferentiableSequenceScore(0);
        SplitSequenceAnnotationParser parser = new SplitSequenceAnnotationParser(":", ";");
        Result[][] res = ChIPperPredictorBgCount.run(SparseSequence.getDataSet((AlphabetContainer)DNAAlphabetContainer.SINGLETON, fgData, parser), SparseSequence.getDataSet((AlphabetContainer)DNAAlphabetContainer.SINGLETON, bgData, parser), value, weightingFactor, model, pval);
    }

    public static Result[][] run(DataSet data, DataSet bg, String value, String weightingFactor, ThresholdedStrandChIPper model, double pval) throws Exception {
        double wf;
        double[][] weights = new double[2][data.getNumberOfElements()];
        double[] raw = (double[])weights[0].clone();
        int j = 0;
        while (j < weights[0].length) {
            Sequence seq = data.getElementAt(j);
            SequenceAnnotation[] seqAn = seq.getAnnotation();
            int i = 0;
            while (i < seqAn.length) {
                if (seqAn[i].getType().equals(value)) {
                    raw[j] = Double.parseDouble(seqAn[i].getIdentifier());
                }
                ++i;
            }
            ++j;
        }
        if (weightingFactor.endsWith("sd")) {
            double h = Double.parseDouble(weightingFactor.substring(0, weightingFactor.length() - 2));
            double meanRaw = ToolBox.sum(raw) / (double)raw.length;
            double sdRaw = 0.0;
            int i = 0;
            while (i < raw.length) {
                sdRaw += (raw[i] - meanRaw) * (raw[i] - meanRaw);
                ++i;
            }
            sdRaw = Math.sqrt(sdRaw / (double)raw.length);
            h = meanRaw + h * sdRaw;
            double anz = 0.0;
            int i2 = 0;
            while (i2 < raw.length) {
                if (raw[i2] >= h) {
                    anz += 1.0;
                }
                ++i2;
            }
            anz = Math.max(50.0, anz);
            wf = anz / (double)raw.length;
        } else {
            wf = Double.parseDouble(weightingFactor);
        }
        weights[0] = Interpolation.getWeight(data, raw, wf, Interpolation.RANK_LOG);
        weights[1] = Interpolation.getBgWeight(weights[0]);
        double[] bgWeights = new double[bg.getNumberOfElements()];
        Arrays.fill(bgWeights, 1.0);
        SignificantMotifOccurrencesFinder smof = new SignificantMotifOccurrencesFinder(model, bg, bgWeights, pval);
        Pair<double[][][], int[][]> pair = smof.getPWMAndPositions(0, data, weights[0], 0, 0);
        int[][] pos = pair.getSecondElement();
        double wNone = 0.0;
        double wSome = 0.0;
        int off = 50;
        int none = 0;
        int some = 0;
        int i = 0;
        while (i < pos.length) {
            if (pos[i].length == 0) {
                ++none;
                wNone += weights[0][i];
            } else {
                ++some;
                wSome += weights[0][i];
            }
            ++i;
        }
        System.out.println("all=" + pos.length + "\tnone=" + none + "\tsome=" + some);
        System.out.println("wAll=" + ToolBox.sum(weights[0]) + "\twNone=" + wNone + "\twSome=" + wSome);
        return null;
    }
}

