/*
 * Decompiled with CFR 0.152.
 */
package dimont;

import challenges.dream5.Interpolation;
import de.jstacs.classifiers.differentiableSequenceScoreBased.gendismix.GenDisMixClassifier;
import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.DataSet;
import de.jstacs.data.alphabets.DNAAlphabet;
import de.jstacs.data.alphabets.DNAAlphabetContainer;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.data.sequences.SparseSequence;
import de.jstacs.data.sequences.annotation.SequenceAnnotation;
import de.jstacs.data.sequences.annotation.SplitSequenceAnnotationParser;
import de.jstacs.io.FileManager;
import de.jstacs.motifDiscovery.SignificantMotifOccurrencesFinder;
import de.jstacs.parameters.ParameterSetTagger;
import de.jstacs.results.ImageResult;
import de.jstacs.results.Result;
import de.jstacs.utils.PFMComparator;
import de.jstacs.utils.Pair;
import de.jstacs.utils.SeqLogoPlotter;
import de.jstacs.utils.ToolBox;
import dimont.Dimont;
import dimont.DimontPredictorParameterSet;
import dimont.ThresholdedStrandChIPper;
import java.io.File;
import java.io.FileOutputStream;
import java.util.LinkedList;

public class ChIPperPredictor2 {
    public static void main(String[] args) throws Exception {
        ParameterSetTagger cParams = new ParameterSetTagger(DimontPredictorParameterSet.PREFIX, new DimontPredictorParameterSet());
        cParams.fillParameters("=", args);
        System.out.println("parameters:");
        System.out.println(cParams);
        System.out.println("_________________________________");
        if (!cParams.hasDefaultOrIsSet()) {
            System.out.println("Some of the required parameters are not specified.");
            System.exit(1);
        }
        String home = cParams.getValueFromTag("home", String.class);
        String fgData = String.valueOf(home) + File.separator + cParams.getValueFromTag("data", String.class);
        String infix = cParams.getValueFromTag("infix", String.class);
        String value = cParams.getValueFromTag("value", String.class);
        String weightingFactor = cParams.getValueFromTag("weightingFactor", String.class);
        String chipper = cParams.getValueFromTag("dimont", String.class);
        double pval = cParams.getValueFromTag("p-value", Double.class);
        GenDisMixClassifier cl = new GenDisMixClassifier(FileManager.readFile(chipper));
        ThresholdedStrandChIPper model = (ThresholdedStrandChIPper)cl.getDifferentiableSequenceScore(0);
        SplitSequenceAnnotationParser parser = new SplitSequenceAnnotationParser(":", ";");
        Result[][] res = ChIPperPredictor2.run(SparseSequence.getDataSet((AlphabetContainer)DNAAlphabetContainer.SINGLETON, fgData, parser), value, weightingFactor, model, pval);
    }

    public static Result[][] run(DataSet data, String value, String weightingFactor, ThresholdedStrandChIPper model, double pval) throws Exception {
        double wf;
        double[][] weights = new double[2][data.getNumberOfElements()];
        double[] raw = (double[])weights[0].clone();
        int j = 0;
        while (j < weights[0].length) {
            Sequence seq = data.getElementAt(j);
            SequenceAnnotation[] seqAn = seq.getAnnotation();
            int i = 0;
            while (i < seqAn.length) {
                if (seqAn[i].getType().equals(value)) {
                    raw[j] = Double.parseDouble(seqAn[i].getIdentifier());
                }
                ++i;
            }
            ++j;
        }
        if (weightingFactor.endsWith("sd")) {
            double h = Double.parseDouble(weightingFactor.substring(0, weightingFactor.length() - 2));
            double meanRaw = ToolBox.sum(raw) / (double)raw.length;
            double sdRaw = 0.0;
            int i = 0;
            while (i < raw.length) {
                sdRaw += (raw[i] - meanRaw) * (raw[i] - meanRaw);
                ++i;
            }
            sdRaw = Math.sqrt(sdRaw / (double)raw.length);
            h = meanRaw + h * sdRaw;
            double anz = 0.0;
            int i2 = 0;
            while (i2 < raw.length) {
                if (raw[i2] >= h) {
                    anz += 1.0;
                }
                ++i2;
            }
            anz = Math.max(50.0, anz);
            wf = anz / (double)raw.length;
        } else {
            wf = Double.parseDouble(weightingFactor);
        }
        weights[0] = Interpolation.getWeight(data, raw, wf, Interpolation.RANK_LOG);
        weights[1] = Interpolation.getBgWeight(weights[0]);
        SignificantMotifOccurrencesFinder smof = new SignificantMotifOccurrencesFinder(model, data, weights[1], pval);
        Pair<double[][][], int[][]> pair = smof.getPWMAndPositions(0, data, weights[0], 0, 0);
        int[][] pos = pair.getSecondElement();
        LinkedList<Sequence> left = new LinkedList<Sequence>();
        LinkedList<Sequence> right = new LinkedList<Sequence>();
        LinkedList<Sequence> none = new LinkedList<Sequence>();
        int off = 50;
        int i = 0;
        while (i < pos.length) {
            if (pos[i].length == 0) {
                none.add(data.getElementAt(i));
            } else {
                int j2 = 0;
                while (j2 < pos[i].length) {
                    int curr = pos[i][j2];
                    boolean rc = false;
                    if (curr < 0) {
                        curr = -curr - 1;
                        rc = true;
                    }
                    Sequence sub1 = null;
                    if (curr - off - 1 > 0) {
                        sub1 = data.getElementAt(i).getSubSequence(curr - off - 1, off);
                    }
                    Sequence sub2 = null;
                    if (curr + model.getMotifLength(0) + off < data.getElementAt(i).getLength()) {
                        sub2 = data.getElementAt(i).getSubSequence(curr + model.getMotifLength(0), 50);
                    }
                    if (rc) {
                        Sequence temp = sub1;
                        if (sub2 != null) {
                            sub1 = sub2.reverseComplement();
                        }
                        if (temp != null) {
                            sub2 = temp.reverseComplement();
                        }
                    }
                    if (sub1 != null) {
                        left.add(sub1.annotate(false, data.getElementAt(i).getAnnotation()));
                    }
                    if (sub2 != null) {
                        right.add(sub2.annotate(false, data.getElementAt(i).getAnnotation()));
                    }
                    ++j2;
                }
            }
            ++i;
        }
        SplitSequenceAnnotationParser pars = new SplitSequenceAnnotationParser(":", ";");
        new DataSet("", none.toArray(new Sequence[0])).save(new FileOutputStream("/Users/dev/Downloads/CTCF_none.fa"), '>', pars);
        new DataSet("", left.toArray(new Sequence[0])).save(new FileOutputStream("/Users/dev/Downloads/CTCF_left.fa"), '>', pars);
        new DataSet("", right.toArray(new Sequence[0])).save(new FileOutputStream("/Users/dev/Downloads/CTCF_right.fa"), '>', pars);
        LinkedList<Result> result = new LinkedList<Result>();
        result.add(Dimont.getListResult(data, weights[0], pair, model.getMotifLength(0), 0));
        double[][] pwm = pair.getFirstElement()[0];
        if (!Double.isNaN(pwm[0][0])) {
            try {
                int height = SeqLogoPlotter.getHeight(750, pwm);
                result.add(new ImageResult("Motif", "Sequence logo of the motif", SeqLogoPlotter.plotLogoToBufferedImage(height, pwm)));
                result.add(new ImageResult("Motif (rc)", "Sequence logo of the reverse complement of the motif", SeqLogoPlotter.plotLogoToBufferedImage(height, PFMComparator.getReverseComplement(DNAAlphabet.SINGLETON, pwm))));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new Result[][]{result.toArray(new Result[0])};
    }
}

