/*
 * Decompiled with CFR 0.152.
 */
package dimont;

import de.jstacs.algorithms.optimization.ConstantStartDistance;
import de.jstacs.algorithms.optimization.NegativeDifferentiableFunction;
import de.jstacs.algorithms.optimization.Optimizer;
import de.jstacs.algorithms.optimization.termination.CombinedCondition;
import de.jstacs.algorithms.optimization.termination.IterationCondition;
import de.jstacs.algorithms.optimization.termination.MultipleIterationsCondition;
import de.jstacs.algorithms.optimization.termination.SmallDifferenceOfFunctionEvaluationsCondition;
import de.jstacs.classifiers.differentiableSequenceScoreBased.AbstractMultiThreadedOptimizableFunction;
import de.jstacs.classifiers.differentiableSequenceScoreBased.OptimizableFunction;
import de.jstacs.classifiers.differentiableSequenceScoreBased.gendismix.GenDisMixClassifier;
import de.jstacs.classifiers.differentiableSequenceScoreBased.gendismix.GenDisMixClassifierParameterSet;
import de.jstacs.classifiers.differentiableSequenceScoreBased.gendismix.LearningPrinciple;
import de.jstacs.classifiers.differentiableSequenceScoreBased.gendismix.LogGenDisMixFunction;
import de.jstacs.classifiers.differentiableSequenceScoreBased.logPrior.CompositeLogPrior;
import de.jstacs.classifiers.differentiableSequenceScoreBased.logPrior.LogPrior;
import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.DataSet;
import de.jstacs.data.alphabets.Alphabet;
import de.jstacs.data.alphabets.ContinuousAlphabet;
import de.jstacs.data.alphabets.DNAAlphabetContainer;
import de.jstacs.data.sequences.ByteSequence;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.data.sequences.SparseSequence;
import de.jstacs.data.sequences.annotation.SequenceAnnotationParser;
import de.jstacs.io.FileManager;
import de.jstacs.io.XMLParser;
import de.jstacs.motifDiscovery.MutableMotifDiscoverer;
import de.jstacs.motifDiscovery.MutableMotifDiscovererToolbox;
import de.jstacs.motifDiscovery.SignificantMotifOccurrencesFinder;
import de.jstacs.parameters.ParameterSetTagger;
import de.jstacs.sequenceScores.differentiable.DifferentiableSequenceScore;
import de.jstacs.sequenceScores.statisticalModels.differentiable.DifferentiableStatisticalModel;
import de.jstacs.sequenceScores.statisticalModels.differentiable.directedGraphicalModels.MarkovModelDiffSM;
import de.jstacs.sequenceScores.statisticalModels.differentiable.homogeneous.HomogeneousDiffSM;
import de.jstacs.sequenceScores.statisticalModels.differentiable.homogeneous.HomogeneousMMDiffSM;
import de.jstacs.sequenceScores.statisticalModels.differentiable.homogeneous.UniformHomogeneousDiffSM;
import de.jstacs.utils.ComparableElement;
import de.jstacs.utils.PFMComparator;
import de.jstacs.utils.REnvironment;
import de.jstacs.utils.SafeOutputStream;
import de.jstacs.utils.Time;
import de.jstacs.utils.ToolBox;
import dimont.AbstractSingleMotifChIPper;
import dimont.ChipperParameterSetTAL;
import dimont.MyLogGenDisMixFunctionTAL;
import dimont.ThresholdedStrandChIPper;
import java.io.File;
import java.util.Arrays;

public class ChIPperMainSingleMotifTAL {
    private static double ALPHA = 0.001;

    public static void main(String[] args) throws Exception {
        Time time;
        block34: {
            ParameterSetTagger cParams = new ParameterSetTagger(ChipperParameterSetTAL.PREFIX, new ChipperParameterSetTAL());
            cParams.fillParameters("=", args);
            System.out.println("parameters:");
            System.out.println(cParams);
            System.out.println("_________________________________");
            if (!cParams.hasDefaultOrIsSet()) {
                System.out.println("Some of the required parameters are not specified.");
                System.exit(1);
            }
            int sd = 75;
            boolean modifyProfile = false;
            String home = cParams.getValueFromTag("home", String.class);
            String fgData = String.valueOf(home) + cParams.getValueFromTag("fg", String.class);
            String bgData = String.valueOf(home) + cParams.getValueFromTag("bg", String.class);
            String infix = cParams.getValueFromTag("infix", String.class);
            int motifLength = cParams.getValueFromTag("length", Integer.class);
            int motifNumber = cParams.getValueFromTag("motifs", Integer.class);
            int restarts = cParams.getValueFromTag("starts", Integer.class);
            int bgOrder = cParams.getValueFromTag("flankOrder", Integer.class);
            String position = cParams.getValueFromTag("position", String.class);
            String value = cParams.getValueFromTag("value", String.class);
            String weightingFactor = cParams.getValueFromTag("weightingFactor", String.class);
            int threads = cParams.isSet("threads") ? cParams.getValueFromTag("threads", Integer.class) : AbstractMultiThreadedOptimizableFunction.getNumberOfAvailableProcessors();
            DNAAlphabetContainer con = DNAAlphabetContainer.SINGLETON;
            AlphabetContainer ref = new AlphabetContainer((Alphabet)new ContinuousAlphabet());
            double ess = 4.0;
            boolean free = false;
            time = Time.getTimeInstance(System.out);
            SequenceAnnotationParser parser = null;
            DataSet[] data = new DataSet[]{SparseSequence.getDataSet((AlphabetContainer)con, fgData, parser), SparseSequence.getDataSet((AlphabetContainer)con, bgData, parser)};
            System.out.println("data");
            System.out.println(String.valueOf(data[0].getAnnotation()) + "\t" + data[0].getNumberOfElements() + "\t" + "[" + data[0].getMinimalElementLength() + " .. " + data[0].getAverageElementLength() + " .. " + data[0].getMaximalElementLength() + "]");
            Sequence[] annotated = new Sequence[data[0].getNumberOfElements()];
            Sequence[] annotatedBg = new Sequence[data[1].getNumberOfElements()];
            double[][] weights = new double[][]{new double[data[0].getNumberOfElements()], new double[data[1].getNumberOfElements()]};
            Arrays.fill(weights[0], 1.0);
            Arrays.fill(weights[1], 1.0);
            int j = 0;
            while (j < weights[0].length) {
                annotated[j] = data[0].getElementAt(j);
                ++j;
            }
            j = 0;
            while (j < weights[1].length) {
                annotatedBg[j] = data[1].getElementAt(j);
                ++j;
            }
            data[0] = new DataSet("", annotated);
            data[1] = new DataSet("", annotatedBg);
            MarkovModelDiffSM motif = new MarkovModelDiffSM((AlphabetContainer)con, motifLength, ess, true, 0, null);
            ThresholdedStrandChIPper fg = new ThresholdedStrandChIPper(1, 0.5, motif);
            fg.initializeFunctionRandomly(false);
            HomogeneousDiffSM bg = ChIPperMainSingleMotifTAL.getHomSF(con, bgOrder, 2.0 * ess, data[0].getAverageElementLength());
            DifferentiableSequenceScore[] score = new DifferentiableStatisticalModel[]{fg, bg};
            double[] beta = LearningPrinciple.getBeta(LearningPrinciple.MSP);
            SafeOutputStream stream = SafeOutputStream.getSafeOutputStream(System.out);
            LearningPrinciple initKey = beta[0] > 0.0 ? LearningPrinciple.MCL : LearningPrinciple.ML;
            String initMethod = "best-random-plugin=100";
            String v = initMethod.substring(initMethod.indexOf(61) + 1);
            MyLogGenDisMixFunctionTAL initObjective = new MyLogGenDisMixFunctionTAL(threads, score, data, weights, new CompositeLogPrior(), LearningPrinciple.getBeta(initKey), true, free);
            MyLogGenDisMixFunctionTAL objective = new MyLogGenDisMixFunctionTAL(threads, score, data, weights, new CompositeLogPrior(), beta, true, free);
            NegativeDifferentiableFunction neg = new NegativeDifferentiableFunction(objective);
            double eps = 1.0E-4;
            CombinedCondition stop = new CombinedCondition(2, new MultipleIterationsCondition(5, new SmallDifferenceOfFunctionEvaluationsCondition(eps)), new IterationCondition(100));
            ConstantStartDistance start = new ConstantStartDistance(1.0);
            MutableMotifDiscovererToolbox.InitMethodForDiffSM[] initMeth = new MutableMotifDiscovererToolbox.InitMethodForDiffSM[]{MutableMotifDiscovererToolbox.InitMethodForDiffSM.NOTHING, MutableMotifDiscovererToolbox.InitMethodForDiffSM.NOTHING};
            if (initMethod.startsWith("best-random=")) {
                initMeth[0] = MutableMotifDiscovererToolbox.InitMethodForDiffSM.RANDOMLY;
            } else if (initMethod.startsWith("best-random-plugin=")) {
                initMeth[0] = MutableMotifDiscovererToolbox.InitMethodForDiffSM.PLUG_IN;
            } else if (initMethod.startsWith("best-random-motif=")) {
                initMeth[0] = MutableMotifDiscovererToolbox.InitMethodForDiffSM.MOTIF_RANDOMLY;
            }
            if (initMeth[0] == MutableMotifDiscovererToolbox.InitMethodForDiffSM.NOTHING) {
                throw new IllegalArgumentException("Initialization method not correctly set.");
            }
            double[] params = null;
            MutableMotifDiscoverer[] best = new MutableMotifDiscoverer[motifNumber];
            double[][] pwm = null;
            double[] entropy = new double[motifLength];
            double[] kl = new double[motifLength];
            byte algo = 18;
            GenDisMixClassifierParameterSet genDisMixParams = new GenDisMixClassifierParameterSet(con, 0, algo, eps, eps * 0.1, 1.0, free, OptimizableFunction.KindOfParameter.PLUGIN, true, threads);
            objective.reset(score);
            int m = 0;
            while (m < motifNumber) {
                double[] p;
                best[m] = (MutableMotifDiscoverer)((Object)score[0]);
                boolean lengthAdjust = false;
                int j2 = 0;
                while (j2 < best[m].getNumberOfMotifs()) {
                    if (best[m].getMotifLength(j2) != motifLength) {
                        lengthAdjust = true;
                        best[m].modifyMotif(j2, 0, motifLength - best[m].getMotifLength(j2));
                    }
                    System.out.println("motif " + j2 + ": " + best[m].getMotifLength(j2));
                    ++j2;
                }
                ((AbstractSingleMotifChIPper)score[0]).reset();
                initObjective.setDataAndWeights(data, weights);
                initObjective.reset(score);
                objective.reset(score);
                ComparableElement<double[], Double>[] pars = MutableMotifDiscovererToolbox.getSortedInitialParameters(score, initMeth, initObjective, Integer.parseInt(v), stream, 0);
                double bestVal = Double.NEGATIVE_INFINITY;
                int r = 0;
                while (r < restarts) {
                    System.out.println("---------------------------------------------------------");
                    System.out.println("start : " + r);
                    objective.setDataAndWeights(data, weights);
                    objective.resetHeuristics();
                    start.reset();
                    p = pars[pars.length - r - 1].getElement();
                    objective.setParams(p);
                    Optimizer.optimize(algo, neg, p, stop, eps * 0.1, start, stream);
                    objective.setParams(p);
                    System.out.println(score[0]);
                    objective.setDataAndWeights(data, weights);
                    objective.resetHeuristics();
                    double optVal = objective.evaluateFunction(p);
                    System.out.println(optVal);
                    if (optVal > bestVal) {
                        bestVal = optVal;
                        params = p;
                        best[m] = (MutableMotifDiscoverer)score[0].clone();
                    }
                    ++r;
                }
                score[0] = (DifferentiableStatisticalModel)((Object)best[m]);
                ((AbstractSingleMotifChIPper)score[0]).reset();
                objective.reset(score);
                objective.setParams(params);
                if (ChIPperMainSingleMotifTAL.heuristic(best[m], data[0], weights[0], data[1], objective)) {
                    objective.reset(score);
                }
                p = objective.getParameters(OptimizableFunction.KindOfParameter.LAST);
                objective.setParams(p);
                Optimizer.optimize(algo, neg, p, stop, eps * 0.1, start, stream);
                if (ChIPperMainSingleMotifTAL.heuristic((MutableMotifDiscoverer)((Object)score[0]), data[0], weights[0], data[1], objective)) {
                    ((AbstractSingleMotifChIPper)score[0]).reset();
                    objective.reset(score);
                    p = objective.getParameters(OptimizableFunction.KindOfParameter.LAST);
                    objective.setParams(p);
                    Optimizer.optimize(algo, neg, p, stop, eps * 0.1, start, stream);
                }
                System.out.println("=========================================================");
                GenDisMixClassifier cl = new GenDisMixClassifier(genDisMixParams, (LogPrior)new CompositeLogPrior(), objective.evaluateFunction(p), LearningPrinciple.getBeta(LearningPrinciple.MSP), (DifferentiableStatisticalModel[])score);
                StringBuffer xml = new StringBuffer();
                XMLParser.appendObjectWithTags(xml, cl, "classifier");
                FileManager.writeFile(new File(String.valueOf(home) + "/" + infix + "-motif-" + m + ".xml"), (CharSequence)xml);
                ++m;
            }
            REnvironment re = null;
            try {
                try {
                    re = new REnvironment();
                    re.voidEval("require(seqLogo);");
                    m = 0;
                    while (m < motifNumber) {
                        GenDisMixClassifier cl = (GenDisMixClassifier)XMLParser.extractObjectForTags(FileManager.readFile(String.valueOf(home) + "/" + infix + "-motif-" + m + ".xml"), "classifier");
                        best[m] = (MutableMotifDiscoverer)((Object)cl.getDifferentiableSequenceScore(0));
                        System.out.println("score: " + cl.getLastScore());
                        System.out.println("motif " + m + ":");
                        System.out.println(best[m]);
                        int im = 0;
                        while (im < best[m].getNumberOfMotifs()) {
                            double[][] pwm_pars = ((MarkovModelDiffSM)((AbstractSingleMotifChIPper)best[m]).getFunction(im)).getPWM();
                            re.createMatrix("pwm", pwm_pars);
                            re.plotToPDF("seqLogo(t(pwm))", String.valueOf(home) + "/" + infix + "-motif-" + m + "-as_trained.pdf", true);
                            SignificantMotifOccurrencesFinder smof = new SignificantMotifOccurrencesFinder(best[m], data[1], null, ALPHA);
                            pwm = smof.getPWM(im, data[0], weights[0], 0, 0);
                            int i = 0;
                            while (i < pwm.length) {
                                System.out.println(Arrays.toString(pwm[i]));
                                ++i;
                            }
                            if (!Double.isNaN(pwm[0][0])) {
                                re.createMatrix("pwm", pwm);
                                re.plotToPDF("seqLogo(t(pwm))", String.valueOf(home) + "/" + infix + "-motif-" + m + "-as_predicted.pdf", true);
                            }
                            ++im;
                        }
                        ++m;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    try {
                        if (re != null) {
                            re.close();
                        }
                        break block34;
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                    }
                    break block34;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (re != null) {
                        re.close();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                throw throwable;
            }
            try {
                if (re != null) {
                    re.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        System.out.println(time.getElapsedTime());
    }

    private static ComparableElement<double[], Double>[] removeSimilar(ComparableElement<double[], Double>[] pars, DifferentiableStatisticalModel model, int restarts) throws Exception {
        ComparableElement[] res = new ComparableElement[restarts];
        Sequence[] seqs = new Sequence[pars.length];
        boolean[] used = new boolean[pars.length];
        int i = res.length - 1;
        int j = pars.length - 1;
        res[i] = pars[j];
        seqs[j] = ChIPperMainSingleMotifTAL.getSequence(model, pars[j].getElement());
        used[j] = true;
        System.out.println("best: " + seqs[j]);
        --i;
        --j;
        while (i >= 0 && j >= 0) {
            seqs[j] = ChIPperMainSingleMotifTAL.getSequence(model, pars[j].getElement());
            System.out.println(String.valueOf(j) + " " + seqs[j]);
            int dist = ChIPperMainSingleMotifTAL.getMinimumHammingDistance(seqs, used, j);
            System.out.println("dist: " + dist);
            if (dist > 3) {
                System.out.println("accepted");
                res[i] = pars[j];
                used[j] = true;
                --i;
            }
            --j;
        }
        System.out.println("i: " + i);
        if (i >= 0) {
            j = pars.length - 2;
            while (j >= 0 && i >= 0) {
                if (!used[j]) {
                    res[i] = pars[j];
                    --i;
                }
                --j;
            }
        }
        return res;
    }

    private static int getMinimumHammingDistance(Sequence[] seqs, boolean[] used, int j) throws Exception {
        Sequence curr = seqs[j];
        ++j;
        int min = Integer.MAX_VALUE;
        while (j < seqs.length) {
            int dist;
            if (used[j] && (dist = ChIPperMainSingleMotifTAL.getMinimumHammingDistance(curr, seqs[j])) < min) {
                min = dist;
            }
            ++j;
        }
        return min;
    }

    private static int getMinimumHammingDistance(Sequence curr, Sequence seq2) throws Exception {
        int d2;
        int d1;
        Sequence sub2;
        Sequence subRc;
        Sequence sub1;
        int min = Integer.MAX_VALUE;
        int i = 0;
        while (i <= curr.getLength() / 2) {
            sub1 = curr.getSubSequence(i);
            subRc = curr.reverseComplement().getSubSequence(i);
            sub2 = seq2.getSubSequence(0, seq2.getLength() - i);
            d1 = sub1.getHammingDistance(sub2);
            d2 = subRc.getHammingDistance(sub2);
            if (d1 < min) {
                min = d1;
            }
            if (d2 < min) {
                min = d2;
            }
            ++i;
        }
        i = 1;
        while (i <= curr.getLength() / 2) {
            sub1 = curr.getSubSequence(0, curr.getLength() - i);
            subRc = curr.reverseComplement().getSubSequence(0, curr.getLength() - i);
            sub2 = seq2.getSubSequence(i);
            d1 = sub1.getHammingDistance(sub2);
            d2 = subRc.getHammingDistance(sub2);
            if (d1 < min) {
                min = d1;
            }
            if (d2 < min) {
                min = d2;
            }
            ++i;
        }
        return min;
    }

    private static Sequence getSequence(DifferentiableStatisticalModel model, double[] pars) throws Exception {
        model.setParameters(pars, 2);
        double[][] pwm_pars = ((MarkovModelDiffSM)((AbstractSingleMotifChIPper)model).getFunction(0)).getPWM();
        byte[] cont = new byte[pwm_pars.length];
        int i = 0;
        while (i < pwm_pars.length) {
            cont[i] = (byte)ToolBox.getMaxIndex(pwm_pars[i]);
            ++i;
        }
        return new ByteSequence(model.getAlphabetContainer(), cont);
    }

    private static boolean heuristic(MutableMotifDiscoverer best, DataSet completeFgData, double[] completeFgWeight, DataSet completeBgData, LogGenDisMixFunction objective) throws Exception {
        SignificantMotifOccurrencesFinder smof = new SignificantMotifOccurrencesFinder(best, completeBgData, null, ALPHA);
        boolean modified = false;
        int im = 0;
        while (im < best.getNumberOfMotifs()) {
            System.out.println("before:\n" + best);
            double[][] pwm = smof.getPWM(im, completeFgData, completeFgWeight, 0, 0);
            double[] entropy = new double[pwm.length];
            double[] kl = new double[pwm.length];
            double[] bgDistr = PFMComparator.getCounts(completeFgData);
            PFMComparator.normalize(bgDistr);
            System.out.println("fg: " + Arrays.toString(bgDistr));
            int i = 0;
            while (i < pwm.length) {
                kl[i] = 0.0;
                entropy[i] = 0.0;
                int j = 0;
                while (j < pwm[i].length) {
                    if (pwm[i][j] > 0.0) {
                        int n = i;
                        entropy[n] = entropy[n] - pwm[i][j] * Math.log(pwm[i][j]);
                    }
                    int n = i;
                    kl[n] = kl[n] + (pwm[i][j] - bgDistr[j]) * Math.log(pwm[i][j] / bgDistr[j]);
                    ++j;
                }
                System.out.println(String.valueOf(i) + "\t" + Arrays.toString(pwm[i]) + "\t" + entropy[i] + "\t" + kl[i]);
                ++i;
            }
            int left = 0;
            int right = 0;
            double thresh = 0.7;
            while (left < kl.length && kl[left] < thresh) {
                ++left;
            }
            while (right > -kl.length && kl[kl.length - 1 + right] < thresh) {
                --right;
            }
            System.out.println("left: " + left + ", right: " + right);
            if (left == kl.length || right == -kl.length) {
                System.out.println("tried to remove the complete motif: no modifications");
            } else {
                double normOld = ((DifferentiableStatisticalModel)((Object)best)).getLogNormalizationConstant();
                if (left != 0 || right != 0) {
                    if (best.modifyMotif(im, left, right)) {
                        double w = normOld - ((DifferentiableStatisticalModel)((Object)best)).getLogNormalizationConstant();
                        objective.addTermToClassParameter(0, w);
                    }
                    System.out.println("after:\n" + best);
                    modified = true;
                } else {
                    System.out.println("no modifications for the motif");
                }
            }
            ++im;
        }
        return modified;
    }

    private static HomogeneousDiffSM getHomSF(AlphabetContainer con, int order, double ess, double length) throws Exception {
        if (order >= 0) {
            return new HomogeneousMMDiffSM(con, order, ess, (int)Math.round(length));
        }
        return new UniformHomogeneousDiffSM(con, ess);
    }
}

