/*
 * Decompiled with CFR 0.152.
 */
package dimont;

import de.jstacs.data.DataSet;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.data.sequences.annotation.ReferenceSequenceAnnotation;
import de.jstacs.data.sequences.annotation.SequenceAnnotation;
import de.jstacs.io.NonParsableException;
import de.jstacs.motifDiscovery.MotifDiscoverer;
import de.jstacs.motifDiscovery.Mutable;
import de.jstacs.motifDiscovery.MutableMotifDiscoverer;
import de.jstacs.sequenceScores.statisticalModels.differentiable.DifferentiableStatisticalModel;
import de.jstacs.sequenceScores.statisticalModels.differentiable.NormalizedDiffSM;
import de.jstacs.sequenceScores.statisticalModels.differentiable.mixture.AbstractMixtureDiffSM;
import de.jstacs.sequenceScores.statisticalModels.differentiable.mixture.StrandDiffSM;
import de.jstacs.utils.Normalisation;
import de.jstacs.utils.ToolBox;
import java.text.NumberFormat;
import java.util.HashMap;
import javax.naming.OperationNotSupportedException;

public abstract class AbstractSingleMotifChIPper
extends AbstractMixtureDiffSM
implements MutableMotifDiscoverer {
    protected double logP;
    protected HashMap<Sequence, float[]> positionHash;

    public AbstractSingleMotifChIPper(int starts, DifferentiableStatisticalModel motif) throws CloneNotSupportedException {
        super(0, starts, 2, true, true, motif);
        this.init();
    }

    public AbstractSingleMotifChIPper(StringBuffer xml) throws NonParsableException {
        super(xml);
        this.init();
    }

    protected void init() {
        this.logP = -Math.log(this.function[0].getAlphabetContainer().getAlphabetLengthAt(0));
        this.positionHash = new HashMap();
    }

    @Override
    public AbstractSingleMotifChIPper clone() throws CloneNotSupportedException {
        AbstractSingleMotifChIPper clone = (AbstractSingleMotifChIPper)super.clone();
        clone.positionHash = new HashMap();
        for (Sequence s : this.positionHash.keySet()) {
            clone.positionHash.put(s, (float[])this.positionHash.get(s).clone());
        }
        return clone;
    }

    @Override
    protected boolean determineIsNormalized() {
        return false;
    }

    protected Sequence getReference(Sequence seq) {
        SequenceAnnotation seqAn = seq.getSequenceAnnotationByType("reference", 0);
        return seqAn == null ? null : ((ReferenceSequenceAnnotation)seqAn).getReferenceSequence();
    }

    protected float[] getPosition(Sequence seq, boolean add) {
        float[] res = this.positionHash.get(seq);
        if (res == null) {
            Sequence ref = this.getReference(seq);
            if (ref != null) {
                res = new float[seq.getLength() - this.function[0].getLength() + 1];
                float sum = 0.0f;
                int i = 0;
                while (i < res.length) {
                    res[i] = (float)ref.continuousVal(i);
                    sum += res[i];
                    ++i;
                }
                i = 0;
                while (i < res.length) {
                    res[i] = (float)Math.log(res[i] / sum);
                    ++i;
                }
            }
            if (add) {
                this.positionHash.put(seq, res);
            }
        }
        return res;
    }

    @Override
    public double getHyperparameterForHiddenParameter(int index) {
        return this.function[0].getESS();
    }

    @Override
    protected double getLogNormalizationConstantForComponent(int i) {
        if (i == 0) {
            return this.function[i].getLogNormalizationConstant();
        }
        return 0.0;
    }

    public static int draw(DataSet d, double[] weight) {
        if (weight == null) {
            return r.nextInt(d.getNumberOfElements());
        }
        return AbstractSingleMotifChIPper.draw(weight);
    }

    public static int draw(double[] weight) {
        double s = r.nextDouble() * ToolBox.sum(weight);
        int i = 0;
        while (weight[i] < s) {
            s -= weight[i];
            ++i;
        }
        return i;
    }

    @Override
    protected void initializeUsingPlugIn(int index, boolean freeParams, DataSet[] data, double[][] weights) throws Exception {
        int p;
        int a = (int)this.alphabets.getAlphabetLengthAt(0);
        double d = 0.1 / (double)(a - 1);
        d = (1.0 - (double)a * d) / ((double)a * d);
        int l = this.function[0].getLength();
        int s = AbstractSingleMotifChIPper.draw(data[index], weights == null ? null : weights[index]);
        Sequence seq = data[index].getElementAt(s);
        Sequence ref = this.getReference(seq);
        if (ref == null) {
            p = r.nextInt(seq.getLength() - l + 1);
        } else {
            double[] prof = new double[seq.getLength() - this.function[0].getLength()];
            int i = 0;
            while (i < prof.length) {
                prof[i] = ref.continuousVal(i);
                ++i;
            }
            p = AbstractSingleMotifChIPper.draw(prof);
        }
        seq = seq.getSubSequence(p, l);
        double h = d * this.function[0].getESS();
        this.freeParams = freeParams;
        this.initializeMotif(index, new DataSet("", seq), new double[]{h});
    }

    @Override
    public void initializeMotif(int motifIndex, DataSet data, double[] weights) throws Exception {
        int a = data.getElementLength() - this.function[0].getLength();
        if (a != 0) {
            ((Mutable)((Object)this.function[0])).modify(0, a);
        }
        this.function[motifIndex].initializeFunction(0, this.freeParams, new DataSet[]{data}, new double[][]{weights});
        if (a != 0) {
            double d = (double)a / 2.0;
            ((Mutable)((Object)this.function[0])).modify((int)Math.ceil(d), (int)Math.ceil(-d));
        }
        this.init(this.freeParams);
        this.initializeHiddenUniformly();
        this.positionHash.clear();
    }

    @Override
    public double getESS() {
        double ess = 0.0;
        int i = 0;
        while (i <= this.function.length) {
            ess += this.getHyperparameterForHiddenParameter(i);
            ++i;
        }
        return ess;
    }

    @Override
    public double getLogPartialNormalizationConstant(int parameterIndex) throws Exception {
        int[] ind;
        if (Double.isNaN(this.norm)) {
            this.precomputeNorm();
        }
        double res = (ind = this.getIndices(parameterIndex))[0] == this.function.length ? this.partNorm[ind[1]] : this.logHiddenPotential[ind[0]] + this.function[ind[0]].getLogPartialNormalizationConstant(ind[1]);
        return res;
    }

    @Override
    public String getInstanceName() {
        return String.valueOf(this.getClass().getSimpleName()) + "(" + this.function[0].getInstanceName() + ")";
    }

    @Override
    public int getGlobalIndexOfMotifInComponent(int component, int motif) {
        return component;
    }

    @Override
    public int getIndexOfMaximalComponentFor(Sequence sequence) throws Exception {
        return this.getIndexOfMaximalComponentFor(sequence, 0);
    }

    @Override
    public int getMotifLength(int motif) {
        return this.function[motif].getLength();
    }

    @Override
    public int getNumberOfMotifs() {
        return this.function.length;
    }

    @Override
    public int getNumberOfMotifsInComponent(int component) {
        if (component < this.function.length) {
            return 1;
        }
        return 0;
    }

    protected abstract int fillMotifComponentScoreOf(double[] var1, Sequence var2, int var3);

    public abstract double[] getStrandProfileOfScoresFor(Sequence var1, boolean var2) throws OperationNotSupportedException;

    @Override
    public double[] getProfileOfScoresFor(int component, int motif, Sequence sequence, int startpos, MotifDiscoverer.KindOfProfile kind) throws Exception {
        if (motif == 0 && component < this.function.length) {
            double[] res;
            double d = 0.0;
            int l = sequence.getLength() - startpos - this.function[component].getLength();
            if (l >= 0) {
                res = new double[l + 1];
                int end = this.fillMotifComponentScoreOf(res, sequence, startpos);
                switch (kind) {
                    case UNNORMALIZED_JOINT: {
                        d = this.logHiddenPotential[component];
                    }
                    case UNNORMALIZED_CONDITIONAL: {
                        break;
                    }
                    case NORMALIZED_CONDITIONAL: {
                        d = -Normalisation.getLogSum(0, end, res);
                        break;
                    }
                    default: {
                        throw new IndexOutOfBoundsException();
                    }
                }
                int i = 0;
                while (i < res.length) {
                    int n = i++;
                    res[n] = res[n] + d;
                }
            } else {
                res = new double[]{};
            }
            return res;
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public double[] getStrandProbabilitiesFor(int component, int motif, Sequence sequence, int startpos) throws Exception {
        if (motif > 0 || component > this.function.length) {
            throw new IndexOutOfBoundsException();
        }
        DifferentiableStatisticalModel m = this.function[component];
        while (m instanceof NormalizedDiffSM) {
            m = ((NormalizedDiffSM)m).getFunction();
        }
        if (m instanceof StrandDiffSM) {
            if (startpos == 0) {
                return ((StrandDiffSM)m).getProbsForComponent(sequence);
            }
            return ((StrandDiffSM)m).getProbsForComponent(sequence.getSubSequence(startpos));
        }
        return new double[]{1.0, 0.0};
    }

    @Override
    public void adjustHiddenParameters(int index, DataSet[] data, double[][] weights) throws Exception {
    }

    @Override
    public void initializeMotifRandomly(int motif) throws Exception {
        this.function[motif].initializeFunctionRandomly(this.freeParams);
        this.init(this.freeParams);
    }

    @Override
    protected void init(boolean freeParams) {
        super.init(freeParams);
        if (this.positionHash != null) {
            this.positionHash.clear();
        }
    }

    @Override
    public boolean modifyMotif(int motifIndex, int offsetLeft, int offsetRight) throws Exception {
        if (this.function[motifIndex] instanceof Mutable) {
            double norm_old = this.function[motifIndex].getLogNormalizationConstant();
            boolean res = ((Mutable)((Object)this.function[motifIndex])).modify(offsetLeft, offsetRight);
            if (res) {
                this.init(this.freeParams);
                double norm_new = this.function[motifIndex].getLogNormalizationConstant();
                int n = motifIndex;
                this.hiddenParameter[n] = this.hiddenParameter[n] + (norm_old - norm_new);
                this.setHiddenParameters(this.hiddenParameter, 0);
                this.norm = Double.NaN;
            }
            return res;
        }
        return false;
    }

    @Override
    public String toString(NumberFormat nf) {
        if (Double.isNaN(this.norm)) {
            this.precomputeNorm();
        }
        StringBuffer erg = new StringBuffer(this.function.length * 1000);
        erg.append("\nno motif: " + Math.exp(this.partNorm[this.function.length] - this.norm) + "\texp(" + this.partNorm[this.function.length] + " - " + this.norm + ")\t" + this.logHiddenPotential[this.function.length] + "\n");
        int i = 0;
        while (i < this.function.length) {
            erg.append("\nmotif " + i + ": ");
            erg.append(String.valueOf(Math.exp(this.partNorm[i] - this.norm)) + "\texp(" + this.partNorm[i] + " - " + this.norm + ")\t" + this.logHiddenPotential[i]);
            erg.append("\n" + this.function[i].toString() + "\n");
            ++i;
        }
        return erg.toString();
    }

    public abstract void reset();

    public void resetPositions() {
        this.positionHash.clear();
    }
}

