/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.utils;

import de.jstacs.utils.ComparableElement;
import de.jstacs.utils.DoubleArrayComparator;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;

public class ToolBox {
    public static <K> Hashtable<K, Integer> parseHashSet2IndexHashtable(HashSet<K> set) {
        Hashtable<K, Integer> hash = new Hashtable<K, Integer>();
        if (set != null) {
            Iterator<K> it = set.iterator();
            int i = 0;
            while (it.hasNext()) {
                hash.put(it.next(), i);
                ++i;
            }
        }
        return hash;
    }

    public static double max(double ... array) {
        return ToolBox.max(0, array.length, array);
    }

    public static double min(double ... array) {
        return ToolBox.min(0, array.length, array);
    }

    public static double max(int start, int end, double[] array) {
        if (end <= start) {
            throw new IllegalArgumentException();
        }
        double max = array[start];
        ++start;
        while (start < end) {
            if (max < array[start]) {
                max = array[start];
            }
            ++start;
        }
        return max;
    }

    public static double min(int start, int end, double[] array) {
        if (end <= start) {
            throw new IllegalArgumentException("The start index has to be smaller than the end index.");
        }
        double min = array[start];
        ++start;
        while (start < end) {
            if (min > array[start]) {
                min = array[start];
            }
            ++start;
        }
        return min;
    }

    public static final int getMaxIndex(double[] w) {
        return ToolBox.getMaxIndex(0, w.length, w);
    }

    public static final int getMaxIndex(int start, int end, double[] w) {
        int max = start;
        int i = start + 1;
        while (i < end) {
            if (w[i] > w[max]) {
                max = i;
            }
            ++i;
        }
        return max;
    }

    public static double median(double ... array) {
        return ToolBox.median(0, array.length, array);
    }

    public static double median(int start, int end, double[] array) {
        if (end <= start) {
            throw new IllegalArgumentException("The start index has to be smaller than the end index.");
        }
        double[] ar2 = new double[end - start];
        System.arraycopy(array, start, ar2, 0, ar2.length);
        Arrays.sort(ar2);
        int idx = ar2.length / 2;
        if (ar2.length % 2 == 0) {
            return (ar2[idx - 1] + ar2[idx]) / 2.0;
        }
        return ar2[idx];
    }

    public static double mean(int start, int end, double[] array) {
        if (start >= end) {
            throw new IllegalArgumentException("The start index has to be smaller than the end index.");
        }
        double sum = 0.0;
        int k = start;
        while (k < end) {
            sum += array[k];
            ++k;
        }
        return sum / (double)(end - start);
    }

    public static double sd(int start, int end, double[] array) {
        double mean = ToolBox.mean(start, end, array);
        double var = 0.0;
        int k = start;
        while (k < end) {
            double h = mean - array[k];
            var += h * h;
            ++k;
        }
        return Math.sqrt(var / (double)(end - start));
    }

    public static double percentile(double[] array, double percent) {
        return ToolBox.percentile(0, array.length, array, percent);
    }

    public static double percentile(int start, int end, double[] array, double percent) {
        if (end <= start || percent < 0.0 || percent > 1.0) {
            throw new IllegalArgumentException();
        }
        double[] ar2 = new double[end - start];
        System.arraycopy(array, start, ar2, 0, ar2.length);
        Arrays.sort(ar2);
        int idx = (int)Math.ceil(percent * (double)ar2.length);
        return ar2[idx];
    }

    public static double weightPercentile(double[] array, double percent) {
        double t = ToolBox.sum(array) * percent;
        double[] ar2 = new double[array.length];
        System.arraycopy(array, 0, ar2, 0, array.length);
        Arrays.sort(ar2);
        int j = ar2.length - 1;
        while (j >= 0 && t - ar2[j] > 0.0) {
            t -= ar2[j];
            --j;
        }
        return ar2[j];
    }

    public static final int[] rank(double[] values, boolean sameRank) {
        return ToolBox.rank(values, sameRank ? TiedRanks.CONTIGUOUS : TiedRanks.IN_ORDER);
    }

    public static final int[] order(double[] values, boolean ascending) {
        Object[] comp = new ComparableElement[values.length];
        int i = 0;
        while (i < values.length) {
            comp[i] = new ComparableElement<Integer, Double>(i, ascending ? -values[i] : values[i]);
            ++i;
        }
        Arrays.sort(comp);
        int[] res = new int[values.length];
        int i2 = 0;
        while (i2 < res.length) {
            res[i2] = (Integer)((ComparableElement)comp[i2]).getElement();
            ++i2;
        }
        return res;
    }

    public static final int[] rank(double[] values, TiedRanks ties) {
        int n = values.length;
        double[][] help = new double[n][2];
        int i = 0;
        while (i < n) {
            help[i][0] = values[i];
            help[i][1] = i;
            ++i;
        }
        Arrays.sort(help, new DoubleArrayComparator(0));
        int[] ranks = new int[n];
        int rank = 0;
        int temp = 0;
        int i2 = --n;
        while (i2 >= 0) {
            ranks[(int)Math.round((double)help[i2][1])] = rank;
            if (ties == TiedRanks.IN_ORDER || i2 > 0 && help[i2][0] != help[i2 - 1][0]) {
                rank += temp + 1;
                temp = 0;
            } else if (ties == TiedRanks.CONTIGUOUS) {
                temp = 0;
            } else if (ties == TiedRanks.SPORTS) {
                ++temp;
            } else {
                throw new RuntimeException(String.valueOf(ties.name()) + " not supported.");
            }
            --i2;
        }
        return ranks;
    }

    public static double spearmanCorrelation(double[] v1, double[] v2) throws Exception {
        if (v1.length != v2.length) {
            throw new Exception("Number of values in both vector differ.");
        }
        int[] rankTruth = ToolBox.rank(v2, true);
        int[] rankPred = ToolBox.rank(v1, true);
        double sumTruth = 0.0;
        double sumPred = 0.0;
        double sqTruth = 0.0;
        double sqPred = 0.0;
        double cross = 0.0;
        double n = rankTruth.length;
        int i = 0;
        while (i < rankTruth.length) {
            sumTruth += (double)rankTruth[i];
            sumPred += (double)rankPred[i];
            sqTruth += (double)(rankTruth[i] * rankTruth[i]);
            sqPred += (double)(rankPred[i] * rankPred[i]);
            cross += (double)(rankTruth[i] * rankPred[i]);
            ++i;
        }
        return (cross - sumTruth * sumPred / n) / (Math.sqrt(sqTruth - sumTruth * sumTruth / n) * Math.sqrt(sqPred - sumPred * sumPred / n));
    }

    public static double pearsonCorrelation(double[] v1, double[] v2) throws Exception {
        if (v1.length != v2.length) {
            throw new Exception("Number of values in both vector differ.");
        }
        double sumTruth = 0.0;
        double sumPred = 0.0;
        double sqTruth = 0.0;
        double sqPred = 0.0;
        double cross = 0.0;
        double n = v2.length;
        int i = 0;
        while (i < v2.length) {
            sumTruth += v2[i];
            sumPred += v1[i];
            sqTruth += v2[i] * v2[i];
            sqPred += v1[i] * v1[i];
            cross += v2[i] * v1[i];
            ++i;
        }
        return (cross - sumTruth * sumPred / n) / (Math.sqrt(sqTruth - sumTruth * sumTruth / n) * Math.sqrt(sqPred - sumPred * sumPred / n));
    }

    public static double pearsonCorrelation(double[] v1, double[] v2, int off1, int off2) throws Exception {
        int l1 = v1.length - off1;
        int l2 = v2.length - off2;
        if (l1 < 1 || l2 < 1) {
            return 0.0;
        }
        return ToolBox.pearsonCorrelation(v1, v2, off1, off2, Math.min(l1, l2));
    }

    public static double pearsonCorrelation(double[] v1, double[] v2, int off1, int off2, int length) throws Exception {
        if (length < 1 || v1.length < off1 + length || v2.length < off2 + length) {
            throw new Exception("Wrong length");
        }
        double sumTruth = 0.0;
        double sumPred = 0.0;
        double sqTruth = 0.0;
        double sqPred = 0.0;
        double cross = 0.0;
        double n = length;
        int i = 0;
        while (i < length) {
            sumTruth += v2[off2 + i];
            sumPred += v1[off1 + i];
            sqTruth += v2[off2 + i] * v2[off2 + i];
            sqPred += v1[off1 + i] * v1[off1 + i];
            cross += v2[off2 + i] * v1[off1 + i];
            ++i;
        }
        return (cross - sumTruth * sumPred / n) / (Math.sqrt(sqTruth - sumTruth * sumTruth / n) * Math.sqrt(sqPred - sumPred * sumPred / n));
    }

    public static double sum(double ... array) {
        return ToolBox.sum(0, array.length, array);
    }

    public static double sum(int start, int end, double[] array) {
        double sum = 0.0;
        int i = start;
        while (i < end) {
            sum += array[i];
            ++i;
        }
        return sum;
    }

    public static double[][] transpose(double[][] sp) throws Exception {
        double[][] tr = new double[sp[0].length][sp.length];
        int i = 0;
        while (i < sp.length) {
            if (sp[i].length != tr.length) {
                throw new Exception("Not a matrix.");
            }
            int j = 0;
            while (j < sp[i].length) {
                tr[j][i] = sp[i][j];
                ++j;
            }
            ++i;
        }
        return tr;
    }

    public static double[] getUniqueHueValues(int number) {
        double[] vals = new double[number];
        int i = 0;
        while (i < vals.length) {
            vals[i] = (double)i * 360.0 / (double)number;
            if (vals[i] == 120.0 || vals[i] == 240.0 || vals[i] == 40.0 || vals[i] == 0.0) {
                vals[i] = Double.NaN;
            }
            ++i;
        }
        double[] vals2 = new double[number];
        vals2[0] = 0.3333333333333333;
        vals2[1] = 0.6666666666666666;
        vals2[2] = 0.1111111111111111;
        vals2[3] = 0.0;
        int curr = (int)Math.round((double)number / 2.0);
        int off = (int)Math.round((double)number / 4.0);
        int i2 = 4;
        while (i2 < vals2.length) {
            if (!Double.isNaN(vals[curr])) {
                vals2[i2] = vals[curr] / 360.0;
                vals[curr] = Double.NaN;
            } else {
                --i2;
            }
            if (curr + off < number) {
                curr += off;
            } else {
                curr = off;
                off = (int)Math.round((double)off / 2.0);
            }
            ++i2;
        }
        return vals2;
    }

    public static void sortAlongWith(double[] arrayToBeSorted, double[] ... alongWith) {
        boolean simple;
        boolean bl = simple = alongWith == null;
        if (!simple) {
            int i = 0;
            while (i < alongWith.length && alongWith[i] == null) {
                ++i;
            }
            boolean bl2 = simple = alongWith.length == i;
        }
        if (simple) {
            Arrays.sort(arrayToBeSorted);
        } else {
            int j;
            double[][] h = new double[arrayToBeSorted.length][1 + alongWith.length];
            int i = 0;
            while (i < h.length) {
                h[i][0] = arrayToBeSorted[i];
                j = 1;
                while (j <= alongWith.length) {
                    h[i][j] = alongWith[j - 1][i];
                    ++j;
                }
                ++i;
            }
            Arrays.sort(h, new DoubleArrayComparator(0));
            i = 0;
            while (i < h.length) {
                arrayToBeSorted[i] = h[i][0];
                j = 1;
                while (j <= alongWith.length) {
                    alongWith[j - 1][i] = h[i][j];
                    ++j;
                }
                ++i;
            }
        }
    }

    public static String toString(double[] array, NumberFormat nf) {
        if (array == null) {
            return "null";
        }
        StringBuffer sb = new StringBuffer();
        sb.append("[");
        int i = 0;
        while (i < array.length) {
            sb.append(String.valueOf(i == 0 ? "" : ", ") + nf.format(array[i]));
            ++i;
        }
        sb.append("]");
        return sb.toString();
    }

    public static enum TiedRanks {
        IN_ORDER,
        SPORTS,
        CONTIGUOUS;

    }
}

