/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.optimization.geneticAlgorithms.selection;

import de.jstacs.optimization.geneticAlgorithms.populations.Population;
import de.jstacs.optimization.geneticAlgorithms.populations.individuals.Individual;
import de.jstacs.optimization.geneticAlgorithms.selection.IndividualSelection;
import de.jstacs.utils.Normalisation;
import java.util.LinkedList;

public class RandomByFitnessSelection<T extends Individual>
implements IndividualSelection<T> {
    private boolean withReplacement;

    public RandomByFitnessSelection(boolean withReplacement) {
        this.withReplacement = withReplacement;
    }

    @Override
    public Population<T> selectIndividuals(Population<T> original, int n) {
        LinkedList<T> drawn = new LinkedList<T>();
        double[] fitness = new double[original.getNumberOfIndivuals()];
        int i = 0;
        while (i < fitness.length) {
            fitness[i] = original.getIndividual(i).getFitness();
            ++i;
        }
        Normalisation.sumNormalisation(fitness);
        if (this.withReplacement) {
            do {
                double d = Math.random();
                int idx = 0;
                while (d > fitness[idx]) {
                    d -= fitness[idx];
                    ++idx;
                }
                drawn.add(original.getIndividual(idx));
            } while (drawn.size() < n);
        } else {
            if (n > original.getNumberOfIndivuals()) {
                throw new IllegalArgumentException("You cannot draw more individuals than exist in population without replacement.");
            }
            int[] idxs = new int[fitness.length];
            int i2 = 0;
            while (i2 < idxs.length) {
                idxs[i2] = i2;
                ++i2;
            }
            int last = idxs.length;
            double currSum = 1.0;
            do {
                double d = Math.random();
                int idx = 0;
                while (idx < last && d * currSum > fitness[idxs[idx]]) {
                    d -= fitness[idxs[idx]];
                    ++idx;
                }
                currSum -= fitness[idxs[idx]];
                drawn.add(original.getIndividual(idxs[idx]));
                idxs[idx] = idxs[last - 1];
                --last;
            } while (drawn.size() < n);
        }
        return original.getPopulation(drawn);
    }
}

