/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.optimization.geneticAlgorithms.operations;

import de.jstacs.io.ArrayHandler;
import de.jstacs.optimization.geneticAlgorithms.operations.SimpleMutation;
import de.jstacs.optimization.geneticAlgorithms.populations.individuals.Individual;

public class SymbolDependentMutation<T extends Individual>
extends SimpleMutation<T> {
    private double[][] condProbs;

    public SymbolDependentMutation(boolean drawByFitness, double rate, double[][] condProbs) throws CloneNotSupportedException {
        super(drawByFitness, rate);
        this.condProbs = (double[][])ArrayHandler.clone((Cloneable[])condProbs);
    }

    @Override
    protected int drawSymbol(T individual, int dimension) {
        int curr = individual.getValueAt(dimension);
        double d = r.nextDouble();
        int sym = 0;
        while (d > this.condProbs[curr][sym]) {
            d -= this.condProbs[curr][sym];
            ++sym;
        }
        return sym;
    }
}

