/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.optimization.geneticAlgorithms.operations;

import de.jstacs.data.AlphabetContainer;
import de.jstacs.optimization.geneticAlgorithms.fitnessFunctions.FitnessFunction;
import de.jstacs.optimization.geneticAlgorithms.operations.SimpleMutation;
import de.jstacs.optimization.geneticAlgorithms.populations.Population;
import de.jstacs.optimization.geneticAlgorithms.populations.individuals.Individual;
import de.jstacs.optimization.geneticAlgorithms.selection.IndividualSelection;
import java.util.LinkedList;
import java.util.Random;

public class SimpleShift<T extends Individual>
extends SimpleMutation<T> {
    private static Random r = new Random();

    public SimpleShift(boolean drawByFitness, double rate) {
        super(drawByFitness, rate);
    }

    @Override
    public Population<T> getMutatedPopulation(Population<T> original, FitnessFunction<T> fun) throws Exception {
        LinkedList<Object> ind = new LinkedList<Object>();
        int[][] idxs = this.drawIndexes(this.rate, original);
        int i = 0;
        while (i < idxs[0].length) {
            int j;
            Object in = original.getIndividual(idxs[0][i]);
            int num = this.drawNumberOfShifts(in);
            if (num > in.getDimension()) {
                num = in.getDimension();
            }
            int[] vals = new int[in.getDimension()];
            if (num < 0) {
                j = 0;
                while (j < vals.length + num) {
                    vals[j] = in.getValueAt(j - num);
                    ++j;
                }
                j = vals.length + num;
                while (j < vals.length) {
                    vals[j] = this.drawSymbol(in, j);
                    ++j;
                }
            } else {
                j = 0;
                while (j < num) {
                    vals[j] = this.drawSymbol(in, j);
                    ++j;
                }
                j = num;
                while (j < vals.length) {
                    vals[j] = in.getValueAt(j - num);
                    ++j;
                }
            }
            in = in.getIndividual(vals);
            in.setFitness(fun);
            ind.add(in);
            ++i;
        }
        i = 0;
        while (i < idxs[1].length) {
            ind.add(original.getIndividual(idxs[1][i]));
            ++i;
        }
        return original.getPopulation(ind);
    }

    @Override
    public Population<T> getModifiedPopulation(Population<T> original, FitnessFunction<T> fun, IndividualSelection<T> select) throws Exception {
        LinkedList<Object> ind = new LinkedList<Object>();
        original = select.selectIndividuals(original, (int)Math.ceil((double)original.getNumberOfIndivuals() * this.rate));
        int i = 0;
        while (i < original.getNumberOfIndivuals()) {
            int j;
            Object in = original.getIndividual(i);
            int num = this.drawNumberOfShifts(in);
            if (num > in.getDimension()) {
                num = in.getDimension();
            }
            int[] vals = new int[in.getDimension()];
            if (num < 0) {
                j = 0;
                while (j < vals.length + num) {
                    vals[j] = in.getValueAt(j - num);
                    ++j;
                }
                j = vals.length + num;
                while (j < vals.length) {
                    vals[j] = this.drawSymbol(in, j);
                    ++j;
                }
            } else {
                j = 0;
                while (j < num) {
                    vals[j] = this.drawSymbol(in, j);
                    ++j;
                }
                j = num;
                while (j < vals.length) {
                    vals[j] = in.getValueAt(j - num);
                    ++j;
                }
            }
            in = in.getIndividual(vals);
            in.setFitness(fun);
            ind.add(in);
            ++i;
        }
        return original.getPopulation(ind);
    }

    protected int drawNumberOfShifts(T individual) {
        int length = individual.getDimension();
        double ra = r.nextDouble();
        int num = 1 + (int)Math.ceil(Math.log(2.0 * (1.0 - ra) + Math.pow(0.5, length - 1) * ra) / Math.log(0.5));
        ra = r.nextDouble();
        if (ra < 0.5) {
            num *= -1;
        }
        return num;
    }

    @Override
    protected int drawSymbol(T individual, int dimension) {
        AlphabetContainer con = individual.getEncoding();
        return r.nextInt((int)con.getAlphabetLengthAt(dimension));
    }
}

