/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.optimization.geneticAlgorithms.operations;

import de.jstacs.data.AlphabetContainer;
import de.jstacs.optimization.geneticAlgorithms.fitnessFunctions.FitnessFunction;
import de.jstacs.optimization.geneticAlgorithms.operations.Mutation;
import de.jstacs.optimization.geneticAlgorithms.populations.Population;
import de.jstacs.optimization.geneticAlgorithms.populations.individuals.Individual;
import de.jstacs.optimization.geneticAlgorithms.selection.IndividualSelection;
import de.jstacs.utils.IntList;
import de.jstacs.utils.Normalisation;
import java.util.LinkedList;
import java.util.Random;

public class SimpleMutation<T extends Individual>
implements Mutation<T> {
    protected static Random r = new Random();
    protected boolean drawByFitness;
    protected double rate;

    public SimpleMutation(boolean drawByFitness, double rate) {
        this.drawByFitness = drawByFitness;
        this.rate = rate;
    }

    protected int drawNumberOfMutations(T individual) {
        int length = individual.getDimension();
        double ra = r.nextDouble();
        int num = 1 + (int)Math.ceil(Math.log(2.0 * (1.0 - ra) + Math.pow(0.5, length - 1) * ra) / Math.log(0.5));
        return num;
    }

    protected int drawDimension(T individual) {
        return r.nextInt(individual.getDimension());
    }

    protected int drawSymbol(T individual, int dimension) {
        AlphabetContainer con = individual.getEncoding();
        return r.nextInt((int)con.getAlphabetLengthAt(dimension));
    }

    @Override
    public Population<T> getMutatedPopulation(Population<T> original, FitnessFunction<T> fun) throws Exception {
        LinkedList<T> ind = new LinkedList<T>();
        int[][] idxs = this.drawIndexes(this.rate, original);
        int i = 0;
        while (i < idxs[0].length) {
            Object in = original.getIndividual(idxs[0][i]);
            int num = this.drawNumberOfMutations(in);
            int j = 0;
            while (j < num) {
                int dim = this.drawDimension(in);
                int sym = this.drawSymbol(in, dim);
                in = in.mutate(dim, sym);
                ++j;
            }
            in.setFitness(fun);
            ind.add(in);
            ++i;
        }
        i = 0;
        while (i < idxs[1].length) {
            ind.add(original.getIndividual(idxs[1][i]));
            ++i;
        }
        return original.getPopulation(ind);
    }

    protected int[][] drawIndexes(double rate, Population<T> original) {
        IntList selected = new IntList();
        IntList remaining = new IntList();
        if (this.drawByFitness) {
            double[] fitness = new double[original.getNumberOfIndivuals()];
            int i = 0;
            while (i < fitness.length) {
                fitness[i] = original.getIndividual(i).getFitness();
                ++i;
            }
            Normalisation.sumNormalisation(fitness);
            int[] idxs = new int[fitness.length];
            int i2 = 0;
            while (i2 < idxs.length) {
                idxs[i2] = i2;
                ++i2;
            }
            int last = idxs.length;
            double currSum = 1.0;
            int i3 = 0;
            while ((double)i3 < rate * (double)original.getNumberOfIndivuals()) {
                double d = r.nextDouble();
                int idx = 0;
                while (idx < last && d * currSum > fitness[idxs[idx]]) {
                    d -= fitness[idxs[idx]];
                    ++idx;
                }
                currSum -= fitness[idxs[idx]];
                selected.add(idxs[idx]);
                idxs[idx] = idxs[last - 1];
                --last;
                ++i3;
            }
            i3 = 0;
            while (i3 < last) {
                remaining.add(idxs[i3]);
                ++i3;
            }
        } else {
            int i = 0;
            while (i < original.getNumberOfIndivuals()) {
                double ra = r.nextDouble();
                if (ra < rate) {
                    selected.add(i);
                } else {
                    remaining.add(i);
                }
                ++i;
            }
        }
        return new int[][]{selected.toArray(), remaining.toArray()};
    }

    @Override
    public Population<T> getModifiedPopulation(Population<T> original, FitnessFunction<T> fun, IndividualSelection<T> select) throws Exception {
        LinkedList<T> ind = new LinkedList<T>();
        original = select.selectIndividuals(original, (int)Math.ceil((double)original.getNumberOfIndivuals() * this.rate));
        int i = 0;
        while (i < original.getNumberOfIndivuals()) {
            Object in = original.getIndividual(i);
            int num = this.drawNumberOfMutations(in);
            int j = 0;
            while (j < num) {
                int dim = this.drawDimension(in);
                int sym = this.drawSymbol(in, dim);
                in = in.mutate(dim, sym);
                ++j;
            }
            in.setFitness(fun);
            ind.add(in);
            ++i;
        }
        return original.getPopulation(ind);
    }
}

