/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.optimization.geneticAlgorithms.initialization;

import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.sequences.IntSequence;
import de.jstacs.optimization.geneticAlgorithms.fitnessFunctions.FitnessFunction;
import de.jstacs.optimization.geneticAlgorithms.initialization.PopulationInitializer;
import de.jstacs.optimization.geneticAlgorithms.populations.DiscreteSequencePopulation;
import de.jstacs.optimization.geneticAlgorithms.populations.Population;
import de.jstacs.optimization.geneticAlgorithms.populations.individuals.DiscreteSequenceIndividual;
import java.util.LinkedList;
import java.util.Random;

public class DiscreteSequencePopulationInitializer
implements PopulationInitializer<DiscreteSequenceIndividual> {
    private static Random r = new Random();
    private int length;
    private AlphabetContainer cont;
    private int[] allowed;

    public DiscreteSequencePopulationInitializer(int length, AlphabetContainer cont, int[] allowed) {
        this.length = length;
        this.cont = cont;
        this.allowed = (int[])allowed.clone();
    }

    @Override
    public Population<DiscreteSequenceIndividual> getInitialPopulation(int num, FitnessFunction<DiscreteSequenceIndividual> fun) throws Exception {
        LinkedList<DiscreteSequenceIndividual> indiv = new LinkedList<DiscreteSequenceIndividual>();
        int i = 0;
        while (i < num) {
            int[] seq = new int[this.length];
            int j = 0;
            while (j < seq.length) {
                seq[j] = this.allowed[r.nextInt(this.allowed.length)];
                ++j;
            }
            DiscreteSequenceIndividual temp = new DiscreteSequenceIndividual(new IntSequence(this.cont, seq));
            temp.setFitness((FitnessFunction)fun);
            indiv.add(temp);
            ++i;
        }
        return new DiscreteSequencePopulation(indiv.toArray(new DiscreteSequenceIndividual[0]));
    }
}

