/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.optimization.geneticAlgorithms.fitnessFunctions;

import de.jstacs.optimization.geneticAlgorithms.fitnessFunctions.CachingFitnessFunction;
import de.jstacs.optimization.geneticAlgorithms.fitnessFunctions.FitnessFunction;
import de.jstacs.optimization.geneticAlgorithms.populations.individuals.Individual;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class MultiThreadedFitnessFunction<T extends Individual>
extends CachingFitnessFunction<T> {
    private int curr;
    private Worker[] workers;

    public MultiThreadedFitnessFunction(FitnessFunction<T> fun, int numThreads) {
        super(fun);
        this.workers = new Worker[numThreads];
        int i = 0;
        while (i < this.workers.length) {
            this.workers[i] = new Worker(this, i);
            Thread t = new Thread(this.workers[i]);
            t.setDaemon(true);
            t.start();
            ++i;
        }
        this.curr = 0;
    }

    @Override
    public Double getFitness(T individual) throws Exception {
        this.workers[this.curr].add(individual);
        ++this.curr;
        if (this.curr >= this.workers.length) {
            this.curr = 0;
        }
        return null;
    }

    private Double getSuperFitness(T ind) throws Exception {
        return super.getFitness(ind);
    }

    public void stopWorkers() {
        int i = 0;
        while (i < this.workers.length) {
            this.workers[i].stopWorker();
            ++i;
        }
    }

    private static class Worker<T extends Individual>
    implements Runnable {
        private List<T> individuals;
        private MultiThreadedFitnessFunction<T> fitfun;
        private boolean stop = false;
        private int index;

        public Worker(MultiThreadedFitnessFunction<T> fitfun, int index) {
            this.index = index;
            this.fitfun = fitfun;
            this.individuals = Collections.synchronizedList(new LinkedList());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!this.stop) {
                Object ind;
                if (this.individuals.size() > 0) {
                    ind = null;
                    ind = (Individual)this.individuals.remove(0);
                    try {
                        Double fit = ((MultiThreadedFitnessFunction)this.fitfun).getSuperFitness((Individual)ind);
                        ind.setFitness(fit);
                        Object object = ind;
                        synchronized (object) {
                            ind.notify();
                            continue;
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        throw new RuntimeException();
                    }
                }
                try {
                    ind = this;
                    synchronized (ind) {
                        this.wait();
                    }
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(T ind) {
            this.individuals.add(ind);
            Worker worker = this;
            synchronized (worker) {
                this.notify();
            }
        }

        public synchronized void stopWorker() {
            this.stop = true;
            this.notify();
        }
    }
}

