/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.optimization.geneticAlgorithms;

import de.jstacs.optimization.geneticAlgorithms.fitnessFunctions.FitnessFunction;
import de.jstacs.optimization.geneticAlgorithms.initialization.PopulationInitializer;
import de.jstacs.optimization.geneticAlgorithms.operations.Operation;
import de.jstacs.optimization.geneticAlgorithms.populations.Population;
import de.jstacs.optimization.geneticAlgorithms.populations.individuals.Individual;
import de.jstacs.optimization.geneticAlgorithms.selection.IndividualSelection;
import de.jstacs.utils.SafeOutputStream;
import de.jstacs.utils.Time;

public class GeneticAlgorithm2<T extends Individual> {
    private PopulationInitializer<T> initializer;
    private Operation<T>[] operations;
    private IndividualSelection<T> selection;
    private FitnessFunction<T> fitness;
    private Population<T> finalPopulation;

    public GeneticAlgorithm2(PopulationInitializer<T> initializer, Operation<T>[] operations, IndividualSelection<T> selection, FitnessFunction<T> fitness) {
        this.initializer = initializer;
        this.operations = (Operation[])operations.clone();
        this.selection = selection;
        this.fitness = fitness;
    }

    public void optimize(int numGeneration, int sizePopulation) throws Exception {
        Population<T> population = this.initializer.getInitialPopulation(sizePopulation, this.fitness);
        double percentElitism = 0.2;
        SafeOutputStream printer = SafeOutputStream.getSafeOutputStream(SafeOutputStream.DEFAULT_STREAM);
        SafeOutputStream silent = SafeOutputStream.getSafeOutputStream(null);
        double currFitness = 0.0;
        double lastFitness = 0.0;
        int it = 0;
        int eq = 0;
        Time t = Time.getTimeInstance(null);
        t.reset();
        while (it < numGeneration && (double)eq < (double)numGeneration / 10.0) {
            int nElite = (int)Math.ceil(percentElitism * (double)population.getNumberOfIndivuals());
            Population<T> elite = population.removeDuplicates().getBestIndividuals(nElite);
            Population newPopulation = null;
            int j = 0;
            while (j < this.operations.length) {
                Population<T> opPop = this.operations[j].getModifiedPopulation(population, this.fitness, this.selection);
                newPopulation = newPopulation == null ? opPop : newPopulation.join(opPop);
                ++j;
            }
            newPopulation = newPopulation.removeDuplicates();
            newPopulation = newPopulation.getBestIndividuals(population.getNumberOfIndivuals() - nElite);
            newPopulation = elite.join(newPopulation);
            newPopulation.sortIndividuals();
            System.out.println(newPopulation);
            lastFitness = currFitness;
            currFitness = newPopulation.getIndividual(0).getFitness();
            printer.writeln(String.valueOf(t.getElapsedTime()) + "\t" + newPopulation.getNumberOfIndivuals() + " " + currFitness);
            eq = currFitness == lastFitness ? ++eq : 0;
            population = newPopulation;
            if (it % 100 == 0) {
                this.fitness.setOutputStream(printer);
                this.fitness.getFitness(newPopulation.getIndividual(0));
                this.fitness.setOutputStream(silent);
                System.out.println(newPopulation);
            }
            ++it;
        }
        this.finalPopulation = population;
    }

    public Population<T> getFinalPopulation() {
        return this.finalPopulation;
    }
}

