/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.classifiers.neuralNetworks.activationFunctions;

import de.jstacs.classifiers.neuralNetworks.activationFunctions.ActivationFunction;
import de.jstacs.io.NonParsableException;
import de.jstacs.io.XMLParser;

public class LogisticFunctionActivationFunction
implements ActivationFunction {
    private double beta;

    public LogisticFunctionActivationFunction(double beta) {
        this.beta = beta;
    }

    public LogisticFunctionActivationFunction(StringBuffer xml) throws NonParsableException {
        xml = XMLParser.extractForTag(xml, this.getClass().getSimpleName());
        this.beta = XMLParser.extractObjectForTags(xml, "beta", Double.TYPE);
    }

    @Override
    public String getName() {
        return "Logistic function with beta=" + this.beta;
    }

    @Override
    public double getValue(double x) {
        return 1.0 / (1.0 + Math.exp(-this.beta * x));
    }

    @Override
    public double getDerivation(double x) {
        double a = this.getValue(x);
        return this.beta * a * (1.0 - a);
    }

    @Override
    public double getPositiveValue() {
        return 1.0;
    }

    @Override
    public double getNegativeValue() {
        return 0.0;
    }

    @Override
    public StringBuffer toXML() {
        StringBuffer xml = new StringBuffer();
        XMLParser.appendObjectWithTags(xml, this.beta, "beta");
        XMLParser.addTags(xml, this.getClass().getSimpleName());
        return xml;
    }
}

