/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.algorithms.graphs.tensor;

import de.jstacs.algorithms.graphs.tensor.AsymmetricTensor;
import de.jstacs.algorithms.graphs.tensor.Tensor;
import java.util.Arrays;

public class SymmetricTensor
extends Tensor {
    private int[][] pascal;
    private double[][][] tensor;
    private int[][][] trueEdgeName;
    private int[] indices;
    private int idxOfLastBest;

    public SymmetricTensor(int n, byte k) {
        super(n, k);
        int j = 1;
        int i = 0;
        int l = k + 1;
        this.indices = new int[k];
        this.pascal = new int[this.L][l];
        i = 0;
        while (i < this.L) {
            this.pascal[i][0] = 1;
            ++i;
        }
        i = this.L - 2;
        while (i >= 0) {
            j = 1;
            while (j < l) {
                this.pascal[i][j] = this.pascal[i + 1][j - 1] + this.pascal[i + 1][j];
                ++j;
            }
            --i;
        }
        this.trueEdgeName = new int[l - 1][][];
        this.tensor = new double[l][][];
        this.tensor[0] = new double[n][1];
        j = 1;
        while (j < l) {
            this.tensor[j] = new double[n][this.pascal[0][j - 1] + this.pascal[0][j]];
            this.trueEdgeName[j - 1] = new int[n][this.tensor[j][0].length];
            i = 0;
            while (i < n) {
                Arrays.fill(this.tensor[j][i], Double.NEGATIVE_INFINITY);
                ++i;
            }
            ++j;
        }
    }

    /*
     * Unable to fully structure code
     */
    public SymmetricTensor(SymmetricTensor[] parts, double[] weights) throws IllegalArgumentException {
        this(parts[0].getNumberOfNodes(), parts[0].getOrder());
        counter1 = 1;
        n = parts.length;
        l = parts[0].getNumberOfNodes();
        k = parts[0].getOrder();
        if (n == weights.length) ** GOTO lbl11
        throw new IllegalArgumentException("The parts and the weights have to have the same dimension.");
lbl-1000:
        // 1 sources

        {
            if (parts[counter1].getNumberOfNodes() != l || parts[counter1].getOrder() != k) {
                throw new IllegalArgumentException("All parts have to have the same order and number of nodes.");
            }
            ++counter1;
lbl11:
            // 2 sources

            ** while (counter1 < n)
        }
lbl12:
        // 1 sources

        counter1 = 0;
        while (counter1 <= k) {
            counter2 = 0;
            while (counter2 < l) {
                counter3 = 0;
                while (counter3 < this.tensor[counter1][counter2].length) {
                    this.tensor[counter1][counter2][counter3] = parts[0].tensor[counter1][counter2][counter3] * weights[0];
                    if (counter1 > 0) {
                        this.trueEdgeName[counter1 - 1][counter2][counter3] = parts[0].trueEdgeName[counter1 - 1][counter2][counter3];
                    }
                    counter4 = 1;
                    while (counter4 < n) {
                        if (counter1 > 0 && this.trueEdgeName[counter1 - 1][counter2][counter3] != parts[counter4].trueEdgeName[counter1 - 1][counter2][counter3]) {
                            throw new IllegalArgumentException("The tensors does not encode the same graph, since at least one edge has a differnet parent permutation.");
                        }
                        v0 = this.tensor[counter1][counter2];
                        v1 = counter3;
                        v0[v1] = v0[v1] + parts[counter4].tensor[counter1][counter2][counter3] * weights[counter4];
                        ++counter4;
                    }
                    ++counter3;
                }
                ++counter2;
            }
            ++counter1;
        }
    }

    public SymmetricTensor(AsymmetricTensor asym_tensor) {
        this(asym_tensor.tensor, asym_tensor.getNumberOfNodes(), asym_tensor.getOrder());
    }

    public SymmetricTensor(double[][][] asym_tensor, int N, byte k) {
        this(N, k);
        int j = 0;
        do {
            this.setRootValue(j, asym_tensor[0][j][0]);
        } while (++j < N);
        int M = N - 1;
        byte i = 1;
        while (i <= this.order) {
            int[] counter = new int[i + 1];
            int[] array = new int[i];
            int l = i - 1;
            j = 0;
            while (l >= 0) {
                counter[l] = j++;
                --l;
            }
            do {
                System.arraycopy(counter, 0, array, 0, i);
                Arrays.sort(array);
                int idx = 0;
                j = 0;
                while (j < i) {
                    idx *= N;
                    idx += counter[j];
                    ++j;
                }
                j = 0;
                while (j < N) {
                    boolean erg = array[0] != j;
                    l = 1;
                    while (l < i && (erg &= array[l] != j && array[l] != array[l - 1])) {
                        ++l;
                    }
                    if (l == i && erg) {
                        this.setValue(i, asym_tensor[i][j][idx], j, counter);
                    }
                    ++j;
                }
                j = 0;
                while (counter[j] == M) {
                    counter[j++] = 0;
                }
                int n = j;
                counter[n] = counter[n] + 1;
            } while (counter[i] == 0);
            i = (byte)(i + 1);
        }
    }

    public double getBest(int child, int[] par, byte k) {
        int i = k;
        int j = 0;
        int b = 0;
        byte l = (byte)par.length;
        int[] current = new int[k];
        int[] parents = new int[k];
        while (b < k) {
            current[b] = b;
            parents[b] = par[current[b]];
            ++b;
        }
        double max = Double.NEGATIVE_INFINITY;
        do {
            if (max < this.tensor[k][child][j = this.getIndices(parents, j, (byte)k)]) {
                max = this.tensor[k][child][j];
                this.idxOfLastBest = j;
            }
            b = l;
            while (--i >= 0 && current[i] == --b) {
            }
            if (i < 0) continue;
            j = i;
            int n = i;
            int n2 = i++;
            int n3 = current[n2] + 1;
            current[n2] = n3;
            parents[n] = par[n3];
            while (i < k) {
                current[i] = current[i - 1];
                int n4 = i;
                int n5 = current[n4] + 1;
                current[n4] = n5;
                parents[i] = par[n5];
                ++i;
            }
        } while (i == k);
        this.idxOfLastBest = this.trueEdgeName[k - 1][child][this.idxOfLastBest];
        return max;
    }

    public int[] getEdgeFromIndex(int idx, int k) {
        int[] erg = new int[k];
        int j = 0;
        while (j < k) {
            erg[j] = idx % this.powers[1];
            idx /= this.powers[1];
            ++j;
        }
        return erg;
    }

    @Override
    public int[] getMaximalEdgeFor(byte k, int child, int ... parents) {
        return this.getEdgeFromIndex(k == 0 ? child : this.trueEdgeName[k - 1][child][this.getIndex(SymmetricTensor.sortAndClear(child, parents, k), k)], k + 1);
    }

    @Override
    public double getRootValue(int child) {
        return this.tensor[0][child][0];
    }

    public int getTrueIndexForLastGetBest() {
        return this.idxOfLastBest;
    }

    @Override
    public double getValue(byte k, int child, int ... parents) {
        return this.tensor[k][child][this.getIndex(SymmetricTensor.sortAndClear(child, parents, k), k)];
    }

    @Override
    public void resetValue(byte k, int child, int ... parents) {
        int i = this.getIndex(SymmetricTensor.sortAndClear(child, parents, k), k);
        this.tensor[k][child][i] = Double.NEGATIVE_INFINITY;
        this.trueEdgeName[k - 1][child][i] = 0;
    }

    @Override
    public void setRootValue(int child, double val) {
        this.tensor[0][child][0] = val;
    }

    @Override
    public void setValue(byte k, double val, int child, int ... parents) {
        int i = this.getIndex(SymmetricTensor.sortAndClear(child, parents, k), k);
        if (this.tensor[k][child][i] < val) {
            this.tensor[k][child][i] = val;
            if (k > 0) {
                this.trueEdgeName[k - 1][child][i] = this.getAsymIndex(child, parents, k) + this.powers[k] * child;
            }
        }
    }

    private static int[] sortAndClear(int child, int[] parents, int anz) {
        int[] cleared_parents = new int[anz];
        int i = 0;
        int last = 0;
        do {
            cleared_parents[i] = parents[i];
            if (parents[i] <= child) continue;
            int n = i;
            cleared_parents[n] = cleared_parents[n] - 1;
        } while (++i < anz);
        if (anz > 1) {
            while (last != anz) {
                int stop = last;
                last = anz;
                i = anz - 1;
                while (i > stop) {
                    if (cleared_parents[i] < cleared_parents[i - 1]) {
                        int help = cleared_parents[i];
                        cleared_parents[i] = cleared_parents[i - 1];
                        cleared_parents[i - 1] = help;
                        last = i;
                    }
                    --i;
                }
            }
        }
        return cleared_parents;
    }

    private int getIndex(int[] current, byte l) {
        int erg = this.pascal[current[0]][l];
        int i = 1;
        while (i < l) {
            erg += this.pascal[current[i]][l - i];
            ++i;
        }
        return erg;
    }

    private int getIndices(int[] current, int i, byte l) {
        if (i == 0) {
            this.indices[0] = this.pascal[current[0]][l];
        } else {
            this.indices[i] = this.indices[i - 1] + this.pascal[current[i]][l - i];
        }
        while (++i < l) {
            this.indices[i] = this.indices[i - 1] + this.pascal[current[i]][l - i];
        }
        return this.indices[l - 1];
    }
}

