/*
 * Decompiled with CFR 0.152.
 */
package challenges.dream6;

import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.DataSet;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.io.NonParsableException;
import de.jstacs.io.XMLParser;
import de.jstacs.sequenceScores.statisticalModels.differentiable.AbstractDifferentiableStatisticalModel;
import de.jstacs.utils.DoubleList;
import de.jstacs.utils.IntList;
import de.jstacs.utils.random.RandomNumberGenerator;
import de.jtem.numericalMethods.calculus.specialFunctions.Gamma;
import java.text.NumberFormat;

public class SingleGaussianDiffSM
extends AbstractDifferentiableStatisticalModel {
    private static RandomNumberGenerator rand = new RandomNumberGenerator();
    private double ess;
    private double priorMu;
    private double priorAlpha;
    private double priorBeta;
    private double mu;
    private double logPrecision;
    private double precision;
    private boolean initialized;
    private boolean alwaysInitRandomly;
    private double logNorm;

    public SingleGaussianDiffSM(double ess, double priorMu, double priorAlpha, double priorBeta, AlphabetContainer alphabet, boolean alwaysInitRandomly) {
        super(alphabet, 1);
        this.ess = ess;
        this.priorMu = priorMu;
        this.priorAlpha = priorAlpha;
        this.priorBeta = priorBeta;
        this.initialized = false;
        this.alwaysInitRandomly = alwaysInitRandomly;
    }

    public SingleGaussianDiffSM(AlphabetContainer alphabet, double ess, double priorMu, double expectedPrecision, double sdPrecision, boolean alwaysInitRandomly) {
        this(ess, priorMu, (expectedPrecision / (2.0 * sdPrecision * sdPrecision) + Math.sqrt(expectedPrecision / (2.0 * sdPrecision * sdPrecision) * (expectedPrecision / (2.0 * sdPrecision * sdPrecision)) + 1.0 / (sdPrecision * sdPrecision))) * expectedPrecision + 1.0, expectedPrecision / (2.0 * sdPrecision * sdPrecision) + Math.sqrt(expectedPrecision / (2.0 * sdPrecision * sdPrecision) * (expectedPrecision / (2.0 * sdPrecision * sdPrecision)) + 1.0 / (sdPrecision * sdPrecision)), alphabet, alwaysInitRandomly);
    }

    public SingleGaussianDiffSM(StringBuffer buf) throws NonParsableException {
        super(buf);
    }

    @Override
    public SingleGaussianDiffSM clone() throws CloneNotSupportedException {
        return (SingleGaussianDiffSM)super.clone();
    }

    @Override
    protected void fromXML(StringBuffer xml) throws NonParsableException {
        this.length = 1;
        xml = XMLParser.extractForTag(xml, this.getClass().getSimpleName());
        this.alphabets = XMLParser.extractObjectForTags(xml, "alphabet", AlphabetContainer.class);
        this.ess = XMLParser.extractObjectForTags(xml, "ess", Double.TYPE);
        this.priorMu = XMLParser.extractObjectForTags(xml, "priorMu", Double.TYPE);
        this.priorAlpha = XMLParser.extractObjectForTags(xml, "priorAlpha", Double.TYPE);
        this.priorBeta = XMLParser.extractObjectForTags(xml, "priorBeta", Double.TYPE);
        this.mu = XMLParser.extractObjectForTags(xml, "mu", Double.TYPE);
        this.logPrecision = XMLParser.extractObjectForTags(xml, "logPrecision", Double.TYPE);
        this.precision = Math.exp(this.logPrecision);
        this.initialized = XMLParser.extractObjectForTags(xml, "initialized", Boolean.TYPE);
        this.precomputeNormalization();
    }

    @Override
    public StringBuffer toXML() {
        StringBuffer buf = new StringBuffer();
        XMLParser.appendObjectWithTags(buf, this.alphabets, "alphabet");
        XMLParser.appendObjectWithTags(buf, this.ess, "ess");
        XMLParser.appendObjectWithTags(buf, this.priorMu, "priorMu");
        XMLParser.appendObjectWithTags(buf, this.priorAlpha, "priorAlpha");
        XMLParser.appendObjectWithTags(buf, this.priorBeta, "priorBeta");
        XMLParser.appendObjectWithTags(buf, this.mu, "mu");
        XMLParser.appendObjectWithTags(buf, this.logPrecision, "logPrecision");
        XMLParser.appendObjectWithTags(buf, this.initialized, "initialized");
        XMLParser.addTags(buf, this.getClass().getSimpleName());
        return buf;
    }

    @Override
    public void addGradientOfLogPriorTerm(double[] grad, int start) throws Exception {
        double val = this.mu - this.priorMu;
        double gradmu = this.ess * this.precision * val;
        int n = start;
        grad[n] = grad[n] - gradmu;
        int n2 = start + 1;
        grad[n2] = grad[n2] + (0.5 - 0.5 * gradmu * val + this.priorAlpha - this.priorBeta * this.precision);
    }

    @Override
    public double getESS() {
        return this.ess;
    }

    @Override
    public double getLogPriorTerm() {
        double val = this.mu - this.priorMu;
        return 0.5 * (Math.log(this.ess / (Math.PI * 2)) + this.logPrecision - this.ess * this.precision * val * val) + this.priorAlpha * Math.log(this.priorBeta) - Gamma.logOfGamma(this.priorAlpha) + this.priorAlpha * this.logPrecision - this.priorBeta * this.precision;
    }

    @Override
    public double getLogNormalizationConstant() {
        return 0.0;
    }

    @Override
    public double getLogPartialNormalizationConstant(int parameterIndex) throws Exception {
        return Double.NEGATIVE_INFINITY;
    }

    @Override
    public int getSizeOfEventSpaceForRandomVariablesOfParameter(int index) {
        return 0;
    }

    @Override
    public double[] getCurrentParameterValues() throws Exception {
        return new double[]{this.mu, this.logPrecision};
    }

    @Override
    public String getInstanceName() {
        return String.valueOf(this.getClass().getSimpleName()) + " with " + this.mu + " and " + this.precision;
    }

    @Override
    public double getLogScoreFor(Sequence seq, int start) {
        double val = seq.continuousVal(start) - this.mu;
        return this.logNorm - 0.5 * val * val * this.precision;
    }

    @Override
    public double getLogScoreAndPartialDerivation(Sequence seq, int start, IntList indices, DoubleList partialDer) {
        double val = seq.continuousVal(start) - this.mu;
        indices.add(0);
        partialDer.add(this.precision * val);
        indices.add(1);
        partialDer.add(0.5 * (1.0 - this.precision * val * val));
        return this.logNorm - 0.5 * val * val * this.precision;
    }

    @Override
    public int getNumberOfParameters() {
        return 2;
    }

    @Override
    public void initializeFunction(int index, boolean freeParams, DataSet[] data, double[][] weights) throws Exception {
        if (this.alwaysInitRandomly) {
            this.initializeFunctionRandomly(freeParams);
        } else {
            double x = 0.0;
            double xsq = 0.0;
            double norm = 0.0;
            int i = 0;
            while (i < data[index].getNumberOfElements()) {
                double w = weights == null || weights[index] == null ? 1.0 : weights[index][i];
                double temp = data[index].getElementAt(i).continuousVal(0);
                x += w * temp;
                xsq += w * temp * temp;
                norm += w;
                ++i;
            }
            double var = xsq / norm - x / norm * (x / norm);
            this.mu = (x + this.ess * this.priorMu) / (norm + this.ess);
            double betap = this.priorBeta + 0.5 * norm * var + this.ess * norm * (x / norm - this.priorMu) * (x / norm - this.priorMu) / (2.0 * (this.ess + norm));
            this.precision = (2.0 * this.priorAlpha + norm - 1.0) / (2.0 * betap);
            this.logPrecision = Math.log(this.precision);
            this.precomputeNormalization();
            this.initialized = true;
        }
    }

    @Override
    public void initializeFunctionRandomly(boolean freeParams) throws Exception {
        this.precision = rand.nextGamma(this.priorAlpha, 1.0 / this.priorBeta);
        this.logPrecision = Math.log(this.precision);
        this.mu = rand.nextGaussian() / this.precision + this.priorMu;
        System.out.println("prec: " + this.precision + ", mu: " + this.mu);
        this.precomputeNormalization();
        this.initialized = true;
    }

    @Override
    public boolean isInitialized() {
        return this.initialized;
    }

    @Override
    public void setParameters(double[] params, int start) {
        this.mu = params[start];
        this.logPrecision = params[start + 1];
        this.precision = Math.exp(this.logPrecision);
        this.precomputeNormalization();
    }

    private void precomputeNormalization() {
        this.logNorm = 0.5 * (this.logPrecision - Math.log(Math.PI * 2));
    }

    @Override
    public String toString() {
        throw new Error("Unresolved compilation problem: \n\tCannot override the final method from AbstractDifferentiableStatisticalModel\n");
    }

    @Override
    public /* synthetic */ String toString(NumberFormat numberFormat) {
        throw new Error("Unresolved compilation problem: \n\tThe type SingleGaussianDiffSM must implement the inherited abstract method SequenceScore.toString(NumberFormat)\n");
    }
}

