/*
 * Decompiled with CFR 0.152.
 */
package challenges.dream5.paper;

import de.jstacs.data.DataSet;
import de.jstacs.utils.REnvironment;
import de.jstacs.utils.ToolBox;
import java.util.Arrays;

public enum Interpolation {
    LOG_LINEAR,
    LINEAR_jens,
    LINEAR,
    RANK_OUTLIER,
    RANK_OUTLIER_REPEATED,
    RANK_LOG,
    RANK_SIGMOID,
    SIGMOID;


    public static double[] getWeight(DataSet data, double[] intensa, double aPrioriWeight, Interpolation interpol) throws Exception {
        double[] weights = new double[intensa.length];
        double[] help = (double[])intensa.clone();
        Arrays.sort(help);
        double min = help[0];
        double max = help[help.length - 1];
        double thresh = help[(int)Math.ceil((1.0 - aPrioriWeight) * (double)help.length)];
        double c = 1.0E-10;
        double m = 0.0;
        int idx = -1;
        switch (interpol) {
            case LOG_LINEAR: {
                min = Math.log(min);
                max = Math.log(max) - min;
                int i = 0;
                while (i < intensa.length) {
                    weights[i] = aPrioriWeight + (1.0 - 2.0 * aPrioriWeight) * (Math.log(intensa[i]) - min) / max;
                    ++i;
                }
                break;
            }
            case LINEAR_jens: {
                max -= min;
                int i = 0;
                while (i < intensa.length) {
                    weights[i] = (intensa[i] - min) / max;
                    ++i;
                }
                break;
            }
            case LINEAR: {
                double distAbove = max - thresh;
                double distBelow = thresh - min;
                int i = 0;
                while (i < intensa.length) {
                    double temp;
                    if (intensa[i] >= thresh) {
                        temp = intensa[i] - thresh;
                        weights[i] = 0.5 + 0.5 * temp / distAbove;
                    } else {
                        temp = thresh - intensa[i];
                        weights[i] = 0.5 - 0.5 * temp / distBelow;
                    }
                    ++i;
                }
                break;
            }
            case RANK_OUTLIER: 
            case RANK_OUTLIER_REPEATED: {
                int n2;
                boolean repeat = interpol == RANK_OUTLIER_REPEATED;
                int idx1 = 0;
                int idx2 = -1000;
                do {
                    int n1;
                    if (idx2 < 0) {
                        n1 = 0;
                        n2 = help.length;
                    } else {
                        n1 = idx1;
                        n2 = idx2;
                    }
                    double q25 = help[n1 + (int)(0.25 * (double)(n2 - n1))];
                    double q75 = help[n1 + (int)(0.75 * (double)(n2 - n1))];
                    thresh = q75 + 1.5 * (q75 - q25);
                    idx2 = Arrays.binarySearch(help, thresh);
                    if (idx2 >= 0) continue;
                    idx2 = -idx2 + 1;
                } while (repeat && idx2 < n2);
                aPrioriWeight = 1.0 - (double)idx2 / (double)intensa.length;
                System.out.println(aPrioriWeight);
            }
            case RANK_LOG: {
                int[] rank = ToolBox.rank(intensa, true);
                int i = 0;
                while (i < intensa.length) {
                    if (m <= (double)rank[i]) {
                        m = rank[i];
                    }
                    ++i;
                }
                i = 0;
                while (i < intensa.length) {
                    double h = (double)rank[i] / m;
                    weights[i] = 1.0 / (1.0 + h / (1.0 - h) * (1.0 - aPrioriWeight) / aPrioriWeight);
                    ++i;
                }
                break;
            }
            case SIGMOID: {
                double b1 = (Math.log(c) - Math.log1p(-c)) / (1.0 - max / thresh);
                double a1 = b1 / thresh;
                int i = 0;
                while (i < intensa.length) {
                    weights[i] = 1.0 / (1.0 + Math.exp(-a1 * intensa[i] + b1));
                    ++i;
                }
                break;
            }
            case RANK_SIGMOID: {
                int[] rank = ToolBox.rank(intensa, true);
                int[] rankSorted = (int[])rank.clone();
                Arrays.sort(rankSorted);
                min = -rankSorted[rankSorted.length - 1];
                max = -rankSorted[0];
                thresh = -rankSorted[(int)Math.floor(aPrioriWeight * (double)rankSorted.length)];
                System.out.println(String.valueOf(min) + " " + max + " " + thresh);
                double b1 = (Math.log1p(-c) - Math.log(c)) / (1.0 - min / thresh);
                double a1 = b1 / thresh;
                int i = 0;
                while (i < intensa.length) {
                    weights[i] = 1.0 / (1.0 + Math.exp(-a1 * (double)(-rank[i]) + b1));
                    ++i;
                }
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
        return weights;
    }

    public static double getThreshold(REnvironment re, double[] intensa, double aPrioriWeight) throws Exception {
        re.createVector("x", intensa);
        re.voidEval("alpha = " + aPrioriWeight);
        re.voidEval("mean=median(x,na.rm=T); sd=mad(x,na.rm=T);");
        re.voidEval("th=qnorm(1-alpha,mean=mean,sd=sd);");
        return re.eval("sum( x >= th ) / length(x)").asDouble();
    }

    public static double[] getBgWeight(double[] weights) {
        double[] bgWeights = new double[weights.length];
        int i = 0;
        while (i < bgWeights.length) {
            bgWeights[i] = 1.0 - weights[i];
            ++i;
        }
        return bgWeights;
    }
}

