/*
 * Decompiled with CFR 0.152.
 */
package challenges.dream5.paper;

import challenges.dream5.paper.KMerStatistics;
import de.jstacs.classifiers.AbstractScoreBasedClassifier;
import de.jstacs.data.DataSet;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.utils.DoubleList;
import de.jstacs.utils.IntList;
import de.jstacs.utils.ToolBox;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.LinkedList;

public class Evaluation {
    public static int getNumberOfResults() {
        return 6;
    }

    public static String getHeading() {
        return "spearman\tpearson\tpearson log\tauc-PR\tauc-ROC\tCC_8";
    }

    public static void fillResults(double[] pred, double[] signal, DataSet data, LinkedList<Sequence> positives, DoubleList results) throws Exception {
        results.add(ToolBox.spearmanCorrelation(pred, signal));
        results.add(ToolBox.pearsonCorrelation(pred, signal));
        double[] logPred = new double[pred.length];
        double[] logSignal = (double[])logPred.clone();
        int i = 0;
        while (i < pred.length) {
            logPred[i] = Math.log(pred[i]);
            logSignal[i] = Math.log(signal[i]);
            ++i;
        }
        results.add(ToolBox.pearsonCorrelation(logPred, logSignal));
        KMerStatistics kmerStat = new KMerStatistics(data, signal, true, 0, 8, false);
        kmerStat.fillStatistics(data, pred, positives, results);
    }

    public static void printResults(PrintStream out, DoubleList results) throws IOException {
        if (results.length() > 0) {
            out.append("" + results.get(0));
            int i = 1;
            while (i < results.length()) {
                out.append("\t" + results.get(i));
                ++i;
            }
        }
        out.append("\n");
    }

    public static double[] getPred(AbstractScoreBasedClassifier cl, DataSet data) throws Exception {
        double[] pred = cl.getScores(data);
        int i = 0;
        while (i < pred.length) {
            pred[i] = 1.0 / (1.0 + Math.exp(-pred[i]));
            ++i;
        }
        return pred;
    }

    public static double[] transformScores2(double[] pred, double[] train, double[][][][] intensities, int array, int tf, Mapping mapping) throws Exception {
        train = (double[])train.clone();
        Arrays.sort(train);
        double[] result = null;
        Object ex = null;
        int maxLength = 0;
        int k = 0;
        while (k < intensities[1][1 - array].length) {
            if (k != tf && intensities[1][1 - array][k].length > maxLength) {
                maxLength = intensities[1][1 - array][k].length;
            }
            ++k;
        }
        double[] transformed = new double[maxLength];
        int[] ns = new int[maxLength];
        switch (mapping) {
            case MEAN: {
                int k2 = 0;
                while (k2 < intensities[1][1 - array].length) {
                    if (k2 != tf) {
                        int i = intensities[1][1 - array][k2].length - 1;
                        int j = maxLength - 1;
                        while (i >= 0) {
                            int n = j;
                            transformed[n] = transformed[n] + intensities[1][1 - array][k2][i];
                            int n2 = j--;
                            ns[n2] = ns[n2] + 1;
                            --i;
                        }
                    }
                    ++k2;
                }
                int i = 0;
                while (i < transformed.length) {
                    int n = i;
                    transformed[n] = transformed[n] / (double)ns[i];
                    ++i;
                }
                break;
            }
            case MEDIAN: {
                int i;
                double[] values = null;
                int k3 = 0;
                while (k3 < intensities[1][1 - array].length) {
                    if (k3 != tf) {
                        i = intensities[1][1 - array][k3].length - 1;
                        int j = maxLength - 1;
                        while (i >= 0) {
                            int n = j--;
                            ns[n] = ns[n] + 1;
                            --i;
                        }
                    }
                    ++k3;
                }
                int z = 0;
                i = transformed.length - 1;
                while (i >= 0) {
                    if (values == null || values.length != ns[i]) {
                        values = new double[ns[i]];
                    }
                    int a = ns[i];
                    int k4 = 0;
                    while (k4 < intensities[1][1 - array].length) {
                        int idx;
                        if (k4 != tf && (idx = intensities[1][1 - array][k4].length - 1 - z) >= 0) {
                            values[--a] = intensities[1][1 - array][k4][idx];
                        }
                        ++k4;
                    }
                    Arrays.sort(values);
                    transformed[i] = values.length % 2 == 0 ? (values[(int)Math.floor((double)(ns[i] - 1) / 2.0)] + values[(int)Math.ceil((double)(ns[i] - 1) / 2.0)]) / 2.0 : values[(ns[i] - 1) / 2];
                    --i;
                    ++z;
                }
                break;
            }
            case NEAREST_NEIGHBOUR: 
            case WEIGHTED: {
                int idx = -1;
                double best = Double.POSITIVE_INFINITY;
                double curr = 0.0;
                DoubleList rmses = new DoubleList();
                IntList idxs = new IntList();
                int k5 = 0;
                while (k5 < intensities[1][array].length) {
                    if (k5 != tf) {
                        curr = Evaluation.rmse(train, intensities[1][array][k5]);
                        rmses.add(curr);
                        idxs.add(k5);
                        if (curr > 0.0 && curr < best) {
                            best = curr;
                            idx = k5;
                        }
                    }
                    ++k5;
                }
                if (mapping == Mapping.NEAREST_NEIGHBOUR) {
                    transformed = intensities[1][1 - array][idx];
                    break;
                }
                double[] weights = rmses.toArray();
                double min = ToolBox.min(weights);
                double max = ToolBox.max(weights);
                int i = 0;
                while (i < weights.length) {
                    weights[i] = max - (weights[i] - min);
                    ++i;
                }
                int g = 0;
                int k6 = 0;
                while (k6 < intensities[1][1 - array].length) {
                    if (k6 != tf) {
                        int i2 = intensities[1][1 - array][k6].length - 1;
                        int j = maxLength - 1;
                        while (i2 >= 0) {
                            int n = j;
                            transformed[n] = transformed[n] + weights[g] * intensities[1][1 - array][k6][i2];
                            int n3 = j--;
                            ns[n3] = (int)((double)ns[n3] + weights[g]);
                            --i2;
                        }
                    } else {
                        --g;
                    }
                    ++k6;
                    ++g;
                }
                i = 0;
                while (i < transformed.length) {
                    int n = i;
                    transformed[n] = transformed[n] / (double)ns[i];
                    ++i;
                }
                break;
            }
            case DIRECT: {
                transformed = train;
                break;
            }
            default: {
                throw new Exception();
            }
        }
        result = Evaluation.transformScores(pred, transformed);
        return result;
    }

    public static double[] transformScores2(String home, double[] pred, double[] train, double[][][][] intensities, int array, int tf, Mapping mapping) throws Exception {
        train = (double[])train.clone();
        Arrays.sort(train);
        double[] result = null;
        Object ex = null;
        int maxLength = 0;
        int k = 0;
        while (k < intensities[1][1 - array].length) {
            if (k != tf && intensities[1][1 - array][k].length > maxLength) {
                maxLength = intensities[1][1 - array][k].length;
            }
            ++k;
        }
        double[] transformed = new double[maxLength];
        int[] ns = new int[maxLength];
        switch (mapping) {
            case MEAN: {
                int k2 = 0;
                while (k2 < intensities[1][1 - array].length) {
                    if (k2 != tf) {
                        int i = intensities[1][1 - array][k2].length - 1;
                        int j = maxLength - 1;
                        while (i >= 0) {
                            int n = j;
                            transformed[n] = transformed[n] + intensities[1][1 - array][k2][i];
                            int n2 = j--;
                            ns[n2] = ns[n2] + 1;
                            --i;
                        }
                    }
                    ++k2;
                }
                int i = 0;
                while (i < transformed.length) {
                    int n = i;
                    transformed[n] = transformed[n] / (double)ns[i];
                    ++i;
                }
                break;
            }
            case MEDIAN: {
                int i;
                double[] values = null;
                int k3 = 0;
                while (k3 < intensities[1][1 - array].length) {
                    if (k3 != tf) {
                        i = intensities[1][1 - array][k3].length - 1;
                        int j = maxLength - 1;
                        while (i >= 0) {
                            int n = j--;
                            ns[n] = ns[n] + 1;
                            --i;
                        }
                    }
                    ++k3;
                }
                int z = 0;
                i = transformed.length - 1;
                while (i >= 0) {
                    if (values == null || values.length != ns[i]) {
                        values = new double[ns[i]];
                    }
                    int a = ns[i];
                    int k4 = 0;
                    while (k4 < intensities[1][1 - array].length) {
                        int idx;
                        if (k4 != tf && (idx = intensities[1][1 - array][k4].length - 1 - z) >= 0) {
                            values[--a] = intensities[1][1 - array][k4][idx];
                        }
                        ++k4;
                    }
                    Arrays.sort(values);
                    transformed[i] = values.length % 2 == 0 ? (values[(int)Math.floor((double)(ns[i] - 1) / 2.0)] + values[(int)Math.ceil((double)(ns[i] - 1) / 2.0)]) / 2.0 : values[(ns[i] - 1) / 2];
                    --i;
                    ++z;
                }
                break;
            }
            case NEAREST_NEIGHBOUR: 
            case WEIGHTED: {
                int idx = -1;
                double best = Double.POSITIVE_INFINITY;
                double curr = 0.0;
                DoubleList rmses = new DoubleList();
                IntList idxs = new IntList();
                int k5 = 0;
                while (k5 < intensities[1][array].length) {
                    if (k5 != tf) {
                        curr = Evaluation.rmse(train, intensities[1][array][k5]);
                        rmses.add(curr);
                        idxs.add(k5);
                        if (curr > 0.0 && curr < best) {
                            best = curr;
                            idx = k5;
                        }
                    }
                    ++k5;
                }
                if (mapping == Mapping.NEAREST_NEIGHBOUR) {
                    transformed = intensities[1][1 - array][idx];
                    break;
                }
                double[] weights = rmses.toArray();
                double min = ToolBox.min(weights);
                double max = ToolBox.max(weights);
                int i = 0;
                while (i < weights.length) {
                    weights[i] = max - (weights[i] - min);
                    ++i;
                }
                int g = 0;
                int k6 = 0;
                while (k6 < intensities[1][1 - array].length) {
                    if (k6 != tf) {
                        int i2 = intensities[1][1 - array][k6].length - 1;
                        int j = maxLength - 1;
                        while (i2 >= 0) {
                            int n = j;
                            transformed[n] = transformed[n] + weights[g] * intensities[1][1 - array][k6][i2];
                            int n3 = j--;
                            ns[n3] = (int)((double)ns[n3] + weights[g]);
                            --i2;
                        }
                    } else {
                        --g;
                    }
                    ++k6;
                    ++g;
                }
                i = 0;
                while (i < transformed.length) {
                    int n = i;
                    transformed[n] = transformed[n] / (double)ns[i];
                    ++i;
                }
                break;
            }
            case DIRECT: {
                transformed = train;
                break;
            }
            default: {
                throw new Exception();
            }
        }
        result = Evaluation.transformScores(pred, transformed);
        return result;
    }

    public static double[] transformScores(double[] pred, double[] trainIntens) {
        int[] predRanks = ToolBox.rank(pred, false);
        trainIntens = (double[])trainIntens.clone();
        Arrays.sort(trainIntens);
        double[] transformed = new double[pred.length];
        double fac = (double)trainIntens.length / (double)pred.length;
        int i = 0;
        while (i < transformed.length) {
            int downIdx;
            int upIdx = (int)Math.ceil(fac * (double)predRanks[i]);
            if (upIdx >= trainIntens.length) {
                upIdx = trainIntens.length - 1;
            }
            if ((downIdx = (int)Math.floor(fac * (double)predRanks[i])) < 0) {
                downIdx = 0;
            }
            double p = fac * (double)predRanks[i] - (double)downIdx;
            transformed[i] = p * trainIntens[trainIntens.length - 1 - upIdx] + (1.0 - p) * trainIntens[trainIntens.length - 1 - downIdx];
            ++i;
        }
        return transformed;
    }

    public static double rmse(double[] pred, double[] truth) {
        double rmse = 0.0;
        double n = Math.min(pred.length, truth.length);
        int i = 0;
        while ((double)i < n) {
            rmse += (pred[(int)n - i - 1] - truth[(int)n - i - 1]) * (pred[(int)n - i - 1] - truth[(int)n - i - 1]) / n;
            ++i;
        }
        return Math.sqrt(rmse);
    }

    public static enum Mapping {
        DIRECT,
        NEAREST_NEIGHBOUR,
        MEAN,
        MEDIAN,
        WEIGHTED;

    }
}

