/*
 * Decompiled with CFR 0.152.
 */
import de.jstacs.utils.ComparableElement;
import de.jstacs.utils.ToolBox;
import java.util.Arrays;
import java.util.Random;

public class Thresholding {
    public static void main(String[] args) {
        Random r = new Random();
        Object[] els = new ComparableElement[1];
        int i = 0;
        while (i < els.length) {
            els[i] = new ComparableElement<Double, Double>(r.nextDouble(), r.nextGaussian() * 10.0);
            ++i;
        }
        Arrays.sort(els);
        double[] sortedReferenceScores = new double[els.length];
        double[] referenceWeights = new double[els.length];
        int i2 = 0;
        while (i2 < els.length) {
            sortedReferenceScores[i2] = (Double)((ComparableElement)els[i2]).getWeight();
            referenceWeights[i2] = (Double)((ComparableElement)els[i2]).getElement();
            ++i2;
        }
        double[] sortedMeasureScores = new double[10];
        int i3 = 0;
        while (i3 < sortedMeasureScores.length) {
            sortedMeasureScores[i3] = r.nextGaussian() * 10.0 + 5.0;
            ++i3;
        }
        Arrays.sort(sortedMeasureScores);
        double t = Thresholding.findThreshold(sortedReferenceScores, sortedMeasureScores, referenceWeights, 0.5, false);
        System.out.println(t);
        System.out.println(Thresholding.getRate(sortedReferenceScores, referenceWeights, t));
    }

    protected static double findThreshold(double[] sortedReferenceScores, double[] sortedMeasureScores, double[] referenceWeights, double percentage, boolean atLeast) {
        double sum = ToolBox.sum(0, sortedReferenceScores.length, referenceWeights);
        double hypThreshWeight = sum * percentage;
        double curr = 0.0;
        int i = 0;
        while (curr < hypThreshWeight && i < referenceWeights.length) {
            curr += referenceWeights[i];
            ++i;
        }
        if (curr != hypThreshWeight && !atLeast) {
            --i;
        }
        if (i == sortedReferenceScores.length) {
            double min = sortedReferenceScores[sortedReferenceScores.length - 1];
            int j = 0;
            while (j < sortedMeasureScores.length && sortedMeasureScores[j] <= min) {
                ++j;
            }
            min = j == sortedMeasureScores.length ? (min += 1.0) : (min + sortedMeasureScores[j]) / 2.0;
            return min;
        }
        return sortedReferenceScores[i];
    }

    protected static double getRate(double[] sortedScores, double[] w, double thresh) {
        double count = 0.0;
        int i = 0;
        while (i < sortedScores.length && sortedScores[i] < thresh) {
            count += w[i];
            ++i;
        }
        return count / ToolBox.sum(w);
    }
}

