/*
 * Decompiled with CFR 0.152.
 */
import de.jstacs.clustering.hierachical.ClusterTree;
import de.jstacs.clustering.hierachical.Hclust;
import de.jstacs.io.FileManager;
import de.jstacs.sequenceScores.statisticalModels.StatisticalModel;
import de.jstacs.utils.SeqLogoPlotter;
import java.io.File;
import projects.motifComp.DeBruijnMotifComparison;
import projects.motifComp.PFMWrapperTrainSM;

public class TestMotifRepresentation {
    public static void main(String[] args) throws Exception {
        String path = "/Users/dev/Desktop/motifcomp/sample/";
        double cut = 0.9;
        ClusterTree<StatisticalModel> tree = new ClusterTree<StatisticalModel>(FileManager.readFile("/Users/dev/Downloads/tree_sample.xml"));
        ClusterTree<T>[] subs = Hclust.cutTree(cut, tree);
        System.out.println(subs.length);
        String dir = String.valueOf(path) + "/cut" + cut + "/";
        new File(dir).mkdir();
        int j = 0;
        while (j < subs.length) {
            tree = subs[j];
            if (tree.getNumberOfElements() > 1) {
                StatisticalModel[] els = (StatisticalModel[])tree.getClusterElements();
                int i = 0;
                while (i < els.length) {
                    double[][] pwm = ((PFMWrapperTrainSM)els[i]).getPWM();
                    String name = els[i].getInstanceName().trim();
                    System.out.println(name);
                    name = name.substring(0, name.indexOf("\t"));
                    SeqLogoPlotter.plotLogoToPNG(String.valueOf(dir) + "/cl_" + j + "motif" + i + "_" + name + ".png", 300, pwm);
                    ++i;
                }
                double[][] rep = DeBruijnMotifComparison.getClusterRepresentative(tree, 8);
                SeqLogoPlotter.plotLogoToPNG(String.valueOf(dir) + "/cl_" + j + "rep.png", 300, rep);
            }
            ++j;
        }
    }
}

