/*
 * Decompiled with CFR 0.152.
 */
import de.jstacs.data.DNADataSet;
import de.jstacs.data.DataSet;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.data.sequences.annotation.SequenceAnnotationParser;
import de.jstacs.data.sequences.annotation.SimpleSequenceAnnotationParser;
import de.jstacs.io.AbstractStringExtractor;
import de.jstacs.io.FileManager;
import de.jstacs.io.SparseStringExtractor;
import de.jstacs.io.XMLParser;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.HashMap;
import projects.tals.TALgetterDiffSM;

public class TargetSiteScores {
    public static void main(String[] args) throws Exception {
        String modelPath = args[0];
        String talPath = args[1];
        String targetPath = args[2];
        String outPath = args[3];
        TALgetterDiffSM model = (TALgetterDiffSM)XMLParser.extractObjectForTags(FileManager.readFile(modelPath), "model");
        model.fix();
        DataSet tals = new DataSet(model.getRVDAlphabet(), (AbstractStringExtractor)new SparseStringExtractor(talPath, '>', (SequenceAnnotationParser)new SimpleSequenceAnnotationParser()), "-");
        HashMap<String, Sequence> talMap = new HashMap<String, Sequence>();
        int i = 0;
        while (i < tals.getNumberOfElements()) {
            Sequence tal = tals.getElementAt(i);
            String key = (String)tal.getSequenceAnnotationByType("unparsed comment line", 0).getResultForName("unparsed comment").getValue();
            key = key.trim();
            talMap.put(key, tal);
            ++i;
        }
        DNADataSet targets = new DNADataSet(targetPath, '>', new SimpleSequenceAnnotationParser());
        int maxLen = targets.getMaximalElementLength();
        double[][] scores = new double[targets.getNumberOfElements()][maxLen];
        int i2 = 0;
        while (i2 < targets.getNumberOfElements()) {
            Sequence target = targets.getElementAt(i2);
            String key = (String)target.getSequenceAnnotationByType("unparsed comment line", 0).getResultForName("unparsed comment").getValue();
            key = key.substring(0, key.indexOf("|"));
            key = key.trim();
            Sequence tal = (Sequence)talMap.get(key);
            Arrays.fill(scores[i2], Double.NaN);
            int j = 0;
            while (j < target.getLength()) {
                scores[i2][j] = model.getPartialLogScoreFor(tal, target, 0, j, 1);
                ++j;
            }
            ++i2;
        }
        PrintWriter wr = new PrintWriter(outPath);
        int i3 = 0;
        while (i3 < scores.length) {
            wr.print(scores[i3][0]);
            int j = 1;
            while (j < scores[i3].length) {
                wr.print("\t" + scores[i3][j]);
                ++j;
            }
            wr.println();
            ++i3;
        }
        wr.close();
    }
}

