/*
 * Decompiled with CFR 0.152.
 */
import de.jstacs.classifiers.differentiableSequenceScoreBased.gendismix.GenDisMixClassifier;
import de.jstacs.classifiers.performanceMeasures.PositivePredictiveValueForFixedSensitivity;
import de.jstacs.data.DNADataSet;
import de.jstacs.data.DataSet;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.data.sequences.annotation.ReferenceSequenceAnnotation;
import de.jstacs.data.sequences.annotation.SequenceAnnotation;
import de.jstacs.data.sequences.annotation.SimpleSequenceAnnotationParser;
import de.jstacs.data.sequences.annotation.SplitSequenceAnnotationParser;
import de.jstacs.io.FileManager;
import de.jstacs.results.Result;
import de.jstacs.utils.DoubleList;
import de.jstacs.utils.IntList;
import de.jstacs.utils.ToolBox;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;

public class PredictTargetsThreshold {
    public static void main(String[] args) throws Exception {
        int i;
        DNADataSet miRNAs = new DNADataSet(args[0], '>', new SimpleSequenceAnnotationParser());
        DNADataSet all = new DNADataSet(args[1], '>', new SplitSequenceAnnotationParser(":", ","));
        ArrayList<Sequence> utrSeqs = new ArrayList<Sequence>();
        ArrayList<Sequence> cdsSeqs = new ArrayList<Sequence>();
        int co = 0;
        for (Sequence seq : all) {
            String type = seq.getAnnotation()[1].getIdentifier().trim();
            if ("UTR3".equals(type)) {
                utrSeqs.add(seq);
                ++co;
                continue;
            }
            cdsSeqs.add(seq);
        }
        DataSet cds = new DataSet("cds", cdsSeqs.toArray(new Sequence[0]));
        DataSet utr = new DataSet("utr", utrSeqs.toArray(new Sequence[0]));
        System.out.println("Read data...");
        GenDisMixClassifier cl = new GenDisMixClassifier(FileManager.readFile(args[3]));
        System.out.println("Read classifier...");
        double[] threshes = new double[41];
        int i2 = 0;
        while (i2 < threshes.length) {
            threshes[i2] = 2.0 + (double)i2 * 0.1;
            ++i2;
        }
        double[][][] scores = new double[threshes.length][miRNAs.getNumberOfElements()][utr.getNumberOfElements()];
        System.out.println("Computing scores...");
        int i3 = 0;
        while (i3 < utr.getNumberOfElements()) {
            System.out.println(i3);
            Sequence seq = utr.getElementAt(i3);
            int j = 0;
            while (j < miRNAs.getNumberOfElements()) {
                double[] temp = new double[seq.getLength()];
                int k = 0;
                while (k < seq.getLength()) {
                    temp[k] = PredictTargetsThreshold.getScore(k, seq, cl, miRNAs.getElementAt(j));
                    ++k;
                }
                k = 0;
                while (k < threshes.length) {
                    scores[k][j][i3] = PredictTargetsThreshold.getTotalScore(temp, threshes[k]);
                    ++k;
                }
                ++j;
            }
            ++i3;
        }
        PrintWriter[] wrs = new PrintWriter[miRNAs.getNumberOfElements()];
        int i4 = 0;
        while (i4 < wrs.length) {
            String key = (String)miRNAs.getElementAt(i4).getAnnotation()[0].getResults()[0].getValue();
            key = key.substring(0, key.indexOf(" "));
            wrs[i4] = new PrintWriter(String.valueOf(args[4]) + "_" + key + ".txt");
            ++i4;
        }
        System.out.println("Finished.");
        double[][] perfs = new double[miRNAs.getNumberOfElements()][threshes.length];
        System.out.println("Choosing threshold");
        int k = 0;
        while (k < threshes.length) {
            DoubleList[][] lists = new DoubleList[miRNAs.getNumberOfElements()][];
            i = 0;
            while (i < miRNAs.getNumberOfElements()) {
                lists[i] = new DoubleList[]{new DoubleList(), new DoubleList()};
                String key = (String)miRNAs.getElementAt(i).getAnnotation()[0].getResults()[0].getValue();
                key = key.substring(0, key.indexOf(" "));
                BufferedReader read = new BufferedReader(new FileReader(args[2]));
                String str = null;
                HashMap<String, Double> map = new HashMap<String, Double>();
                while ((str = read.readLine()) != null) {
                    String[] parts = str.split("\\|");
                    if (!parts[0].equals(key)) continue;
                    map.put(parts[1], Double.parseDouble(parts[2]));
                }
                IntList[] lengths = new IntList[]{new IntList(), new IntList()};
                int j = 0;
                while (j < utr.getNumberOfElements()) {
                    double score = scores[k][i][j];
                    String temp = utr.getElementAt(j).getSequenceAnnotationByType("transcript", 0).getIdentifier();
                    if (map.containsKey(temp = temp.substring(temp.lastIndexOf("|") + 1))) {
                        if ((Double)map.get(temp) <= -0.2) {
                            lists[i][0].add(score);
                            lengths[0].add(utr.getElementAt(j).getLength());
                        } else {
                            lists[i][1].add(score);
                            lengths[1].add(utr.getElementAt(j).getLength());
                        }
                    }
                    ++j;
                }
                wrs[i].print(String.valueOf(threshes[k]) + "\t" + lists[i][0].length() + "\t" + lists[i][1].length());
                j = 0;
                while (j < lists[i][0].length()) {
                    wrs[i].print("\t" + lists[i][0].get(j));
                    ++j;
                }
                j = 0;
                while (j < lists[i][1].length()) {
                    wrs[i].print("\t" + lists[i][1].get(j));
                    ++j;
                }
                j = 0;
                while (j < lengths[0].length()) {
                    wrs[i].print("\t" + lengths[0].get(j));
                    ++j;
                }
                j = 0;
                while (j < lengths[1].length()) {
                    wrs[i].print("\t" + lengths[1].get(j));
                    ++j;
                }
                wrs[i].println();
                ++i;
            }
            i = 0;
            while (i < lists.length) {
                double perf = 0.0;
                DoubleList pos = new DoubleList();
                DoubleList neg = new DoubleList();
                int j = 0;
                while (j < lists.length) {
                    if (j != i) {
                        pos.addAll(lists[j][0]);
                        neg.addAll(lists[j][1]);
                    }
                    ++j;
                }
                double[] allPos = pos.toArray();
                double[] allNeg = neg.toArray();
                Arrays.sort(allPos);
                Arrays.sort(allNeg);
                try {
                    perfs[i][k] = (Double)new PositivePredictiveValueForFixedSensitivity(0.05).compute(allPos, allNeg).getResultAt(0).getValue() * (Double)new PositivePredictiveValueForFixedSensitivity(0.1).compute(allPos, allNeg).getResultAt(0).getValue();
                }
                catch (Exception e) {
                    perfs[i][k] = 0.0;
                }
                ++i;
            }
            ++k;
        }
        int i5 = 0;
        while (i5 < wrs.length) {
            wrs[i5].close();
            ++i5;
        }
        int[] chosen = new int[miRNAs.getNumberOfElements()];
        int i6 = 0;
        while (i6 < miRNAs.getNumberOfElements()) {
            chosen[i6] = ToolBox.getMaxIndex(perfs[i6]);
            ++i6;
        }
        i6 = 0;
        while (i6 < perfs.length) {
            System.out.println(String.valueOf(i6) + " " + Arrays.toString(perfs[i6]));
            ++i6;
        }
        System.out.println();
        System.out.println(Arrays.toString(chosen));
        PrintWriter wr = new PrintWriter(args[4]);
        System.out.println("Predicting...");
        i = 0;
        while (i < miRNAs.getNumberOfElements()) {
            int j = 0;
            while (j < utr.getNumberOfElements()) {
                String key = (String)miRNAs.getElementAt(i).getAnnotation()[0].getResults()[0].getValue();
                String gene = utr.getElementAt(j).getSequenceAnnotationByType("transcript", 0).getIdentifier();
                gene = gene.substring(gene.lastIndexOf("|") + 1);
                wr.println(String.valueOf(key) + "|" + gene + "|" + scores[chosen[i]][i][j]);
                ++j;
            }
            ++i;
        }
        wr.close();
        System.out.println("Finished.");
    }

    private static double getTotalScore(double[] scores, double thresh) {
        double score = 0.0;
        int i = 0;
        while (i < scores.length) {
            if (scores[i] > thresh) {
                score += -Math.log1p(Math.exp(scores[i]));
            }
            ++i;
        }
        if (Double.isInfinite(score = Math.log1p(-Math.exp(score)))) {
            score = -1.0E10;
        }
        return score;
    }

    private static float getScore(int j, Sequence seq, GenDisMixClassifier cl, Sequence miRNA) throws Exception {
        if (j < 18) {
            return Float.NaN;
        }
        Sequence temp = seq.reverse(j - 18, j);
        temp = temp.annotate(true, new ReferenceSequenceAnnotation("seq", miRNA, new Result[0]));
        return (float)(cl.getScore(temp, 0) - cl.getScore(temp, 1));
    }

    private static String toString(SequenceAnnotation[] annotation) {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < annotation.length - 1) {
            buf.append(String.valueOf(annotation[i].getIdentifier()) + "|");
            ++i;
        }
        if (annotation.length > 0) {
            buf.append(annotation[annotation.length - 1].getIdentifier());
        }
        return buf.toString();
    }
}

