/*
 * Decompiled with CFR 0.152.
 */
import de.jstacs.classifiers.differentiableSequenceScoreBased.gendismix.GenDisMixClassifier;
import de.jstacs.classifiers.differentiableSequenceScoreBased.gendismix.GenDisMixClassifierParameterSet;
import de.jstacs.classifiers.differentiableSequenceScoreBased.gendismix.LearningPrinciple;
import de.jstacs.classifiers.differentiableSequenceScoreBased.logPrior.CompositeLogPrior;
import de.jstacs.classifiers.differentiableSequenceScoreBased.logPrior.LogPrior;
import de.jstacs.data.DNADataSet;
import de.jstacs.data.DataSet;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.data.sequences.annotation.SequenceAnnotation;
import de.jstacs.data.sequences.annotation.SimpleSequenceAnnotationParser;
import de.jstacs.data.sequences.annotation.SplitSequenceAnnotationParser;
import de.jstacs.io.FileManager;
import de.jstacs.sequenceScores.statisticalModels.differentiable.DifferentiableStatisticalModel;
import de.jstacs.sequenceScores.statisticalModels.differentiable.UniformDiffSM;
import de.jstacs.utils.Pair;
import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import projects.mirnas.MiRNAPredictor;

public class PredictTargetSites {
    public static void main(String[] args) throws Exception {
        DNADataSet miRNAs = new DNADataSet(args[0], '>', new SimpleSequenceAnnotationParser());
        int windowWidth = Integer.parseInt(args[6]);
        boolean replaceUniform = Boolean.parseBoolean(args[7]);
        double pVal = Double.parseDouble(args[8]);
        boolean allBest = Boolean.parseBoolean(args[9]);
        DNADataSet all = new DNADataSet(args[1], '>', new SplitSequenceAnnotationParser(":", ","));
        ArrayList<Sequence> utrSeqs = new ArrayList<Sequence>();
        ArrayList<Sequence> cdsSeqs = new ArrayList<Sequence>();
        for (Sequence seq : all) {
            String type = seq.getAnnotation()[1].getIdentifier().trim();
            if ("UTR3".equals(type)) {
                utrSeqs.add(seq);
                continue;
            }
            cdsSeqs.add(seq);
        }
        DataSet cds = new DataSet("cds", cdsSeqs.toArray(new Sequence[0]));
        DataSet utr = new DataSet("utr", utrSeqs.toArray(new Sequence[0]));
        GenDisMixClassifier cl = new GenDisMixClassifier(FileManager.readFile(new File(args[2])));
        if (replaceUniform) {
            double[] cw = cl.getClassWeights();
            cl = new GenDisMixClassifier((GenDisMixClassifierParameterSet)cl.getCurrentParameterSet(), (LogPrior)new CompositeLogPrior(), LearningPrinciple.MSP, (DifferentiableStatisticalModel)cl.getDifferentiableSequenceScore(0), new UniformDiffSM(all.getAlphabetContainer(), 0, ((DifferentiableStatisticalModel)cl.getDifferentiableSequenceScore(1)).getESS()));
            cl.setClassWeights(false, cw);
        }
        int idx = Integer.parseInt(args[3]);
        String libPrefix = args[4];
        String outfile = args[5];
        DNADataSet bg = null;
        if (args.length > 10) {
            bg = new DNADataSet(args[10]);
        }
        MiRNAPredictor predCDS = null;
        MiRNAPredictor predUTR = null;
        if (bg == null) {
            predCDS = new MiRNAPredictor(cds, 1000000, new DataSet("", miRNAs.getElementAt(idx)), windowWidth, cl);
            predUTR = new MiRNAPredictor(utr, 1000000, new DataSet("", miRNAs.getElementAt(idx)), windowWidth, cl);
        } else {
            predCDS = new MiRNAPredictor(bg, miRNAs, windowWidth, cl);
            predUTR = new MiRNAPredictor(bg, miRNAs, windowWidth, cl);
        }
        PrintWriter out = new PrintWriter(new File(String.valueOf(outfile) + "-" + pVal + "-" + idx + "-" + replaceUniform + "-" + allBest + ".txt"));
        int i = 0;
        while (i < all.getNumberOfElements()) {
            Sequence seq = all.getElementAt(i);
            String type = seq.getAnnotation()[1].getIdentifier().trim();
            Pair<Integer, double[]>[] pairs = null;
            pairs = "UTR3".equals(type) ? (allBest ? predUTR.predictBest(miRNAs.getElementAt(idx), seq) : predUTR.predict(miRNAs.getElementAt(idx), seq, pVal)) : (allBest ? predCDS.predictBest(miRNAs.getElementAt(idx), seq) : predCDS.predict(miRNAs.getElementAt(idx), seq, pVal));
            int j = 0;
            while (j < pairs.length) {
                out.println(String.valueOf(PredictTargetSites.toString(seq.getAnnotation())) + "|" + miRNAs.getElementAt(idx).getAnnotation()[0].getResults()[0].getValue() + "|" + pairs[j].getFirstElement() + "|" + pairs[j].getSecondElement()[0] + "|" + pairs[j].getSecondElement()[1] + "|" + pairs[j].getSecondElement()[2]);
                ++j;
            }
            out.flush();
            ++i;
        }
        out.close();
    }

    private static String toString(SequenceAnnotation[] annotation) {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < annotation.length - 1) {
            buf.append(String.valueOf(annotation[i].getIdentifier()) + "|");
            ++i;
        }
        if (annotation.length > 0) {
            buf.append(annotation[annotation.length - 1].getIdentifier());
        }
        return buf.toString();
    }
}

