/*
 * Decompiled with CFR 0.152.
 */
import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.DataSet;
import de.jstacs.data.alphabets.Alphabet;
import de.jstacs.data.alphabets.DNAAlphabetContainer;
import de.jstacs.data.alphabets.DiscreteAlphabet;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.data.sequences.annotation.SequenceAnnotationParser;
import de.jstacs.data.sequences.annotation.SimpleSequenceAnnotationParser;
import de.jstacs.io.SparseStringExtractor;
import de.jstacs.utils.PFMComparator;
import de.jstacs.utils.REnvironment;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PlotLogo {
    public static void main(String[] args) throws Exception {
        DataSet ds = new DataSet(new AlphabetContainer((Alphabet)new DiscreteAlphabet(true, "A", "C", "G", "T", "N", "W", "S", "M", "K", "R", "Y", "B", "D", "H", "V")), new SparseStringExtractor("/Users/dev/Desktop/TAL-Chips/rice/eval_tlstss/motifs/positions_pos.txt_after.fa", '>', (SequenceAnnotationParser)new SimpleSequenceAnnotationParser()));
        ds = PlotLogo.preprocess(ds);
        DataSet.WeightedDataSetFactory wds = new DataSet.WeightedDataSetFactory(DataSet.WeightedDataSetFactory.SortOperation.SORT_BY_WEIGHTS, ds, null, 8);
        int i = 0;
        while (i < wds.getNumberOfElements()) {
            System.out.println(wds.getElementAt(i) + " " + wds.getWeight(i));
            ++i;
        }
        double[][] pfm = PFMComparator.getPFM(ds);
        int i2 = 0;
        while (i2 < pfm.length) {
            PFMComparator.normalize(pfm[i2]);
            ++i2;
        }
        REnvironment re = new REnvironment();
        re.createMatrix("pwm", pfm);
        re.voidEval("library(seqLogo)");
        re.plotToPDF("seqLogo(t(pwm));", 20.0, 4.0, "/Users/dev/Desktop/TAL-Chips/rice/eval_tlstss/motifs/positions_pos.txt_after.pdf", true);
    }

    public static DataSet preprocess(DataSet data) throws Exception {
        Pattern acgt = Pattern.compile("[ACGT]+", 2);
        LinkedList<Sequence> seqs = new LinkedList<Sequence>();
        int i = 0;
        while (i < data.getNumberOfElements()) {
            Sequence seq = data.getElementAt(i);
            String seqStr = seq.toString();
            Matcher match = acgt.matcher(seqStr);
            while (match.find()) {
                int start = match.start();
                int end = match.end();
                if (start != 0 || end != seq.getLength()) continue;
                seqs.add(Sequence.create(DNAAlphabetContainer.SINGLETON, seq.getAnnotation(), seqStr.substring(start, end), ""));
            }
            ++i;
        }
        return new DataSet("", seqs.toArray(new Sequence[0]));
    }
}

