/*
 * Decompiled with CFR 0.152.
 */
import de.jstacs.classifiers.neuralNetworks.activationFunctions.HyperbolicTangentActivationFunction;
import de.jstacs.classifiers.neuralNetworks.neurons.InputNeuron;
import de.jstacs.classifiers.neuralNetworks.neurons.MSEOutputNeuron;
import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.DataSet;
import de.jstacs.data.alphabets.Alphabet;
import de.jstacs.data.alphabets.ContinuousAlphabet;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.io.AbstractStringExtractor;
import de.jstacs.io.SparseStringExtractor;
import de.jstacs.utils.REnvironment;

public class MK10 {
    public static void main(String[] args) throws Exception {
        double output;
        Sequence input;
        double currErr;
        AlphabetContainer con = new AlphabetContainer((Alphabet)new ContinuousAlphabet());
        DataSet fg = new DataSet(con, (AbstractStringExtractor)new SparseStringExtractor(args[0]), " ");
        DataSet bg = new DataSet(con, (AbstractStringExtractor)new SparseStringExtractor(args[1]), " ");
        DataSet fgTest = new DataSet(con, (AbstractStringExtractor)new SparseStringExtractor(args[2]), " ");
        DataSet bgTest = new DataSet(con, (AbstractStringExtractor)new SparseStringExtractor(args[3]), " ");
        InputNeuron i1 = new InputNeuron(0);
        InputNeuron i2 = new InputNeuron(1);
        MSEOutputNeuron out = new MSEOutputNeuron(new HyperbolicTangentActivationFunction(0.1), 0, i1, i2);
        double initEta = 0.1;
        out.initializeRandomly();
        double[] b1 = new double[]{1.0};
        double[] b2 = new double[]{-1.0};
        REnvironment re = new REnvironment();
        double[][] matrix = new double[fg.getNumberOfElements() + bg.getNumberOfElements()][2];
        int k = 0;
        int j = 0;
        while (j < fg.getNumberOfElements()) {
            matrix[k][0] = fg.getElementAt(j).continuousVal(0);
            matrix[k][1] = fg.getElementAt(j).continuousVal(1);
            ++j;
            ++k;
        }
        j = 0;
        while (j < bg.getNumberOfElements()) {
            matrix[k][0] = bg.getElementAt(j).continuousVal(0);
            matrix[k][1] = bg.getElementAt(j).continuousVal(1);
            ++j;
            ++k;
        }
        re.createMatrix("data", matrix);
        re.voidEval("pdf(\"/Users/dev/Desktop/old/Lehre/Muster_WS12/Uebung10/plots.pdf\");");
        double[] outs = new double[matrix.length];
        double lastErr = currErr = Double.NEGATIVE_INFINITY;
        int iteration = 1;
        do {
            double output2;
            Sequence input2;
            lastErr = currErr;
            currErr = 0.0;
            k = 0;
            int i = 0;
            while (i < fg.getNumberOfElements()) {
                out.reset();
                input2 = fg.getElementAt(i);
                outs[k] = output2 = out.getOutput(input2);
                out.getError(input2, 1.0, b1);
                currErr += 0.5 * (output2 - b1[0]) * (output2 - b1[0]);
                ++i;
                ++k;
            }
            i = 0;
            while (i < fg.getNumberOfElements()) {
                out.reset();
                input2 = bg.getElementAt(i);
                outs[k] = output2 = out.getOutput(input2);
                out.getError(input2, 1.0, b2);
                currErr += 0.5 * (output2 - b2[0]) * (output2 - b2[0]);
                ++i;
                ++k;
            }
            double eta = initEta;
            out.adaptWeights(eta);
            if ((++iteration - 2) % 100 != 0) continue;
            System.out.println(String.valueOf(iteration) + "\t" + currErr + "\t" + (currErr - lastErr));
            re.createVector("outs", outs);
            re.voidEval("outs<-(outs-min(outs))/(max(outs)-min(outs));");
            re.voidEval("plot(data[,1],data[,2],col=rgb(outs,0,0));");
        } while (currErr > 1.0);
        System.out.println(out);
        re.createVector("outs", outs);
        re.voidEval("outs<-(outs-min(outs))/(max(outs)-min(outs));");
        re.voidEval("plot(data[,1],data[,2],col=rgb(outs,0,0));");
        re.voidEval("plot(data[,1],data[,2],col=c(rep(2," + fg.getNumberOfElements() + "),rep(1," + bg.getNumberOfElements() + ")),pch=\"x\");");
        re.voidEval("dev.off();");
        int corr = 0;
        int wro = 0;
        int i = 0;
        while (i < fgTest.getNumberOfElements()) {
            input = fgTest.getElementAt(i);
            output = out.getOutput(input);
            if (output < 0.0) {
                ++wro;
            } else {
                ++corr;
            }
            ++i;
        }
        i = 0;
        while (i < bgTest.getNumberOfElements()) {
            input = bgTest.getElementAt(i);
            output = out.getOutput(input);
            if (output < 0.0) {
                ++corr;
            } else {
                ++wro;
            }
            ++i;
        }
        System.out.println(String.valueOf(corr) + " " + wro);
    }
}

