/*
 * Decompiled with CFR 0.152.
 */
import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.DiscreteSequenceEnumerator;
import de.jstacs.data.alphabets.Alphabet;
import de.jstacs.data.alphabets.DNAAlphabetContainer;
import de.jstacs.data.alphabets.DiscreteAlphabet;
import de.jstacs.data.sequences.Sequence;
import java.util.Arrays;
import projects.dnaInstability.DNAInstability;

public class InstabilityTest {
    public static void main(String[] args) throws Exception {
        Sequence seq = Sequence.create(DNAAlphabetContainer.SINGLETON, "AAGCTTT");
        AlphabetContainer con = new AlphabetContainer((Alphabet)new DiscreteAlphabet(0, 1));
        DiscreteSequenceEnumerator en = new DiscreteSequenceEnumerator(con, seq.getLength(), false);
        DNAInstability inst = new DNAInstability(310.15);
        double full = 0.0;
        double part = 0.0;
        while (en.hasMoreElements()) {
            Object curr = en.nextElement();
            System.out.println(curr);
            double currVal = 1.0;
            int i = 0;
            while (i < ((Sequence)curr).getLength()) {
                currVal *= Math.exp(inst.computeLogG(i, seq, ((Sequence)curr).discreteVal(i), i + 1 < ((Sequence)curr).getLength() ? ((Sequence)curr).discreteVal(i + 1) : 1));
                ++i;
            }
            full += currVal;
            if (((Sequence)curr).discreteVal(0) == 1 && ((Sequence)curr).discreteVal(1) == 1) {
                part += currVal;
                continue;
            }
            System.out.println(currVal);
        }
        System.out.println(Math.log(part / full));
        double[][] res = inst.computeOpeningProfile(seq, 2);
        int i = 0;
        while (i < res.length) {
            System.out.println(Arrays.toString(res[i]));
            ++i;
        }
        System.out.println("+++++++++++++++++++++++++");
        double[][] fwd = inst.computeBackward(seq);
        int i2 = 0;
        while (i2 < fwd.length) {
            System.out.println(Arrays.toString(fwd[i2]));
            ++i2;
        }
        System.out.println("############################");
        Forward.main(null);
        fwd = Forward.backward(seq);
        i2 = 0;
        while (i2 < fwd.length) {
            System.out.println(Arrays.toString(fwd[i2]));
            ++i2;
        }
        System.out.println("---------------------");
        fwd = inst.computeOpeningProfile(seq, 4);
        i2 = 0;
        while (i2 < fwd.length) {
            int j = 0;
            while (j < fwd[i2].length) {
                System.out.print(String.valueOf(Math.exp(fwd[i2][j])) + ", ");
                ++j;
            }
            System.out.println();
            ++i2;
        }
        System.out.println("+++++++++++++++++++++++++++++");
        double[] prof = Forward.computeProfile(seq, 3);
        System.out.println(Arrays.toString(prof));
    }
}

