/*
 * Decompiled with CFR 0.152.
 */
import de.jstacs.data.DNADataSet;
import de.jstacs.data.DataSet;
import de.jstacs.io.RegExFilenameFilter;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class Dream5DataProvider {
    private static String prefix = "answers-detrend";
    private static String[] name = new String[]{String.valueOf(prefix) + "-split/", String.valueOf(prefix) + "-data/"};
    private static HashMap<String, DataSet> hash;

    public static void main(String[] args) throws Exception {
        File[] file;
        String home = args[0];
        new File(String.valueOf(home) + name[0]).mkdirs();
        new File(String.valueOf(home) + name[1]).mkdirs();
        Dream5DataProvider.createResource(home, args[1]);
        Dream5DataProvider.createSequenceSources(String.valueOf(home) + name[0]);
        RegExFilenameFilter filter = new RegExFilenameFilter("signal files", RegExFilenameFilter.Directory.FORBIDDEN, true, ".*-signals\\.txt");
        File[] fileArray = file = new File(String.valueOf(home) + name[0]).listFiles(filter);
        int n = file.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            Dream5DataProvider.createFastaFile(f, 0);
            ++n2;
        }
    }

    private static void createResource(String home, String input) throws Exception {
        ZipFile zipFile = new ZipFile(String.valueOf(home) + input);
        ZipEntry ze = zipFile.entries().nextElement();
        InputStreamReader reader = new InputStreamReader(zipFile.getInputStream(ze));
        BufferedReader r = new BufferedReader(reader);
        String line = r.readLine();
        BufferedWriter[] w = new BufferedWriter[2];
        Object[] last = new String[2];
        while ((line = r.readLine()) != null) {
            int i;
            String[] split = line.split("\t");
            if (!split[0].equals(last[0]) || !split[1].equals(last[1])) {
                i = 0;
                while (i < w.length) {
                    if (w[i] != null) {
                        w[i].close();
                    }
                    ++i;
                }
                w[0] = new BufferedWriter(new FileWriter(String.valueOf(home) + name[0] + split[0] + "-" + split[1] + "-flags.txt"));
                w[1] = new BufferedWriter(new FileWriter(String.valueOf(home) + name[0] + split[0] + "-" + split[1] + "-signals.txt"));
                last[0] = split[0];
                last[1] = split[1];
                System.out.println(Arrays.toString(last));
            }
            w[0].write(split[split.length - 1]);
            w[0].newLine();
            i = 3;
            while (i < split.length - 1) {
                w[1].write(String.valueOf(i == 3 ? "" : "\t") + split[i]);
                ++i;
            }
            w[1].newLine();
        }
        int i = 0;
        while (i < w.length) {
            if (w[i] != null) {
                w[i].close();
            }
            ++i;
        }
        r.close();
    }

    private static void createSequenceSources(String home) throws Exception {
        hash = new HashMap();
        String[] type = new String[]{"HK", "ME"};
        int i = 0;
        while (i < type.length) {
            hash.put(type[i], new DNADataSet(String.valueOf(home) + "/../" + type[i] + "-seqs.txt", '#'));
            ++i;
        }
    }

    private static void createFastaFile(File f, int index) throws IOException {
        String s;
        String fName = f.getAbsolutePath();
        String n = fName.substring(0, fName.length() - 11);
        System.out.println(n);
        fName = String.valueOf(fName.substring(0, fName.length() - 11)) + "flags.txt";
        int l = n.length();
        DataSet d = hash.get(n.substring(l - 3, l - 1));
        BufferedReader flags = new BufferedReader(new FileReader(fName));
        BufferedReader signals = new BufferedReader(new FileReader(f));
        BufferedWriter fasta = new BufferedWriter(new FileWriter(String.valueOf(f.getParent()) + "/../" + name[1] + n.substring(n.lastIndexOf("/"), n.length() - 1) + ".fa"));
        int i = 0;
        while ((s = signals.readLine()) != null) {
            if (flags.readLine().equals("0")) {
                fasta.write(">signal:" + s.split("\t")[index] + "; peak: 17.5;");
                fasta.newLine();
                fasta.write(d.getElementAt(i).getSubSequence(0, 40).toString());
                fasta.newLine();
            }
            ++i;
        }
        flags.close();
        signals.close();
        fasta.close();
    }
}

