/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.util;

import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.impl.DenseDoubleMatrix2D;
import cern.colt.matrix.linalg.CholeskyDecomposition;
import cern.colt.matrix.linalg.SingularValueDecomposition;
import umontreal.iro.lecuyer.util.PrintfFormat;

public class DMatrix {
    private double[][] mat;
    private int r;
    private int c;

    public DMatrix(int r, int c) {
        this.mat = new double[r][c];
        this.r = r;
        this.c = c;
    }

    public DMatrix(double[][] data, int r, int c) {
        this(r, c);
        for (int i = 0; i < r; ++i) {
            for (int j = 0; j < c; ++j) {
                this.mat[i][j] = data[i][j];
            }
        }
    }

    public DMatrix(DMatrix that) {
        this(that.mat, that.r, that.c);
    }

    public static void CholeskyDecompose(double[][] M, double[][] L) {
        int j;
        int i;
        int d = M.length;
        DenseDoubleMatrix2D myM = new DenseDoubleMatrix2D(M);
        DoubleMatrix2D myL = new DenseDoubleMatrix2D(d, d);
        CholeskyDecomposition decomp = new CholeskyDecomposition(myM);
        myL = decomp.getL();
        for (i = 0; i < L.length; ++i) {
            for (j = 0; j <= i; ++j) {
                L[i][j] = myL.get(i, j);
            }
        }
        for (i = 0; i < L.length; ++i) {
            for (j = i + 1; j < L.length; ++j) {
                L[i][j] = 0.0;
            }
        }
    }

    public static DoubleMatrix2D CholeskyDecompose(DoubleMatrix2D M) {
        CholeskyDecomposition decomp = new CholeskyDecomposition(M);
        return decomp.getL();
    }

    public static void PCADecompose(double[][] M, double[][] A, double[] lambda) {
        int d = M.length;
        DenseDoubleMatrix2D myM = new DenseDoubleMatrix2D(M);
        DoubleMatrix2D myA = new DenseDoubleMatrix2D(d, d);
        myA = DMatrix.PCADecompose(myM, lambda);
        for (int i = 0; i < d; ++i) {
            for (int j = 0; j < d; ++j) {
                A[i][j] = myA.get(i, j);
            }
        }
    }

    public static DoubleMatrix2D PCADecompose(DoubleMatrix2D M, double[] lambda) {
        int i;
        SingularValueDecomposition sv = new SingularValueDecomposition(M);
        DoubleMatrix2D D = sv.getS();
        for (i = 0; i < D.rows(); ++i) {
            lambda[i] = D.getQuick(i, i);
        }
        for (i = 0; i < D.rows(); ++i) {
            D.setQuick(i, i, Math.sqrt(lambda[i]));
        }
        DoubleMatrix2D P = sv.getV();
        return P.zMult(D, null);
    }

    public static String toString(double[][] M) {
        StringBuffer sb = new StringBuffer();
        sb.append("{ ");
        for (int i = 0; i < M.length; ++i) {
            sb.append("{ ");
            for (int j = 0; j < M[i].length; ++j) {
                sb.append(M[i][j] + "  ");
            }
            sb.append("  }" + PrintfFormat.LINE_SEPARATOR + "  ");
        }
        sb.append(" }");
        return sb.toString();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("  { ");
        for (int i = 0; i < this.r; ++i) {
            sb.append("{ ");
            for (int j = 0; j < this.c; ++j) {
                sb.append(this.mat[i][j] + "  ");
            }
            sb.append("  }" + PrintfFormat.LINE_SEPARATOR + "  ");
        }
        sb.append("}");
        return sb.toString();
    }

    public int numRows() {
        return this.r;
    }

    public int numColumns() {
        return this.c;
    }

    public double get(int row, int column) {
        if (row >= this.r || column >= this.c) {
            throw new IndexOutOfBoundsException();
        }
        return this.mat[row][column];
    }

    public void set(int row, int column, double value) {
        if (row >= this.r || column >= this.c) {
            throw new IndexOutOfBoundsException();
        }
        this.mat[row][column] = value;
    }

    public DMatrix transpose() {
        DMatrix result = new DMatrix(this.c, this.r);
        for (int i = 0; i < this.r; ++i) {
            for (int j = 0; j < this.c; ++j) {
                result.mat[j][i] = this.mat[i][j];
            }
        }
        return result;
    }
}

