/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.simevents.eventlist;

import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import umontreal.iro.lecuyer.simevents.Event;
import umontreal.iro.lecuyer.simevents.eventlist.EventList;
import umontreal.iro.lecuyer.util.PrintfFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Henriksen
implements EventList {
    private static final double MIN_VALUE = -1.0E39;
    private static final double MAX_VALUE = 1.0E39;
    private static final int ARRAY_LENGTH_INIT = 256;
    private int modCount = 0;
    private Entry firstEntry;
    private Entry[] entryVec;
    private int vectSize;
    private int arrayLength;

    public Henriksen() {
        Entry lastEntry = new Entry(null, null, null, 1.0E39);
        lastEntry.left = this.firstEntry = new Entry(null, null, lastEntry, -1.0E39);
        this.arrayLength = 256;
        this.entryVec = new Entry[this.arrayLength];
        this.changeSize(1);
        this.entryVec[0] = lastEntry;
    }

    @Override
    public boolean isEmpty() {
        return this.firstEntry.right == this.entryVec[0];
    }

    @Override
    public void clear() {
        if (this.isEmpty()) {
            return;
        }
        this.firstEntry.right = this.entryVec[0];
        this.entryVec[0].left = this.firstEntry;
        this.changeSize(1);
        for (int i = 1; i < this.arrayLength; ++i) {
            this.entryVec[i] = null;
        }
        ++this.modCount;
    }

    @Override
    public void add(Event ev) {
        Entry e;
        Entry prec = this.findEntry(ev, false);
        e.right.left = e = new Entry(ev, prec, prec.right, ev.time());
        prec.right = e;
        ++this.modCount;
    }

    @Override
    public void addFirst(Event ev) {
        Entry e;
        this.firstEntry.right.left = e = new Entry(ev, this.firstEntry, this.firstEntry.right, ev.time());
        this.firstEntry.right = e;
        ++this.modCount;
    }

    @Override
    public void addBefore(Event ev, Event other) {
        Entry e;
        Entry otherEntry = this.findEntry(other, true);
        if (otherEntry == null) {
            throw new IllegalArgumentException("Event not in list.");
        }
        otherEntry.left.right = e = new Entry(ev, otherEntry.left, otherEntry, ev.time());
        otherEntry.left = e;
        ++this.modCount;
    }

    @Override
    public void addAfter(Event ev, Event other) {
        Entry e;
        Entry otherEntry = this.findEntry(other, true);
        if (otherEntry == null) {
            throw new IllegalArgumentException("Event not in list.");
        }
        otherEntry.left.right = e = new Entry(ev, otherEntry, otherEntry.right, ev.time());
        otherEntry.left = e;
        ++this.modCount;
    }

    @Override
    public Event getFirst() {
        return this.firstEntry.right.event;
    }

    @Override
    public Event getFirstOfClass(String cl) {
        Entry e = this.firstEntry.right;
        while (e.right != null) {
            if (e.event.getClass().getName().equals(cl)) {
                return e.event;
            }
            e = e.right;
        }
        return null;
    }

    @Override
    public <E extends Event> E getFirstOfClass(Class<E> cl) {
        Entry e = this.firstEntry.right;
        while (e.right != null) {
            if (e.event.getClass() == cl) {
                return (E)e.event;
            }
            e = e.right;
        }
        return null;
    }

    @Override
    public Iterator<Event> iterator() {
        return this.listIterator();
    }

    @Override
    public ListIterator<Event> listIterator() {
        return new HItr();
    }

    @Override
    public boolean remove(Event ev) {
        Entry e = this.findEntry(ev, true);
        if (e == null) {
            return false;
        }
        double evtime = ev.time();
        int i = this.findIndex(evtime);
        ++i;
        while (i < this.vectSize && this.entryVec[i].time == evtime) {
            if (this.entryVec[i].event == ev) {
                this.entryVec[i] = e.left;
            }
            ++i;
        }
        e.left.right = e.right;
        e.right.left = e.left;
        e.right = null;
        e.left = null;
        e.event = null;
        ++this.modCount;
        return true;
    }

    @Override
    public Event removeFirst() {
        Entry e;
        if (this.entryVec[this.vectSize / 2].time <= this.firstEntry.right.time && this.vectSize > 2) {
            this.changeSize(this.vectSize / 2);
        }
        if ((e = this.firstEntry.right) == this.entryVec[0]) {
            return null;
        }
        this.firstEntry.right = e.right;
        e.right.left = this.firstEntry;
        e.right = null;
        e.left = null;
        Event ev = e.event;
        e.event = null;
        ++this.modCount;
        return ev;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("Contents of the event list Henriksen :");
        Entry e = this.firstEntry.right;
        while (e.right != null) {
            sb.append(PrintfFormat.LINE_SEPARATOR + PrintfFormat.g(8, 4, e.event.time()) + " : " + e.event.toString());
            e = e.right;
        }
        return sb.toString();
    }

    private void changeSize(int newSize) {
        if (newSize > this.arrayLength) {
            Entry[] newVec = new Entry[newSize];
            for (int i = 0; i < this.vectSize; ++i) {
                newVec[i] = this.entryVec[i];
            }
            this.entryVec = newVec;
            this.arrayLength = newSize;
        }
        for (int i = this.vectSize; i < newSize; ++i) {
            this.entryVec[i] = this.firstEntry;
        }
        this.vectSize = newSize;
    }

    private int findIndex(double evtime) {
        int i = this.vectSize / 2;
        for (int j = this.vectSize / 4; j > 0; j /= 2) {
            if (evtime >= this.entryVec[i].time) {
                i -= j;
                continue;
            }
            i += j;
        }
        if (evtime >= this.entryVec[i].time) {
            --i;
        }
        return i;
    }

    private Entry findEntry(Event ev, boolean findEvent) {
        double evtime = ev.time();
        int i = this.findIndex(evtime);
        Entry e = this.entryVec[i].left;
        int count = 0;
        while (e.time > evtime) {
            if (++count == 4) {
                if (i + 1 >= this.vectSize) {
                    this.changeSize(this.vectSize * 2);
                }
                count = 0;
                this.entryVec[++i] = e;
            }
            e = e.left;
        }
        if (findEvent) {
            Entry start = e;
            while (e != this.firstEntry && e.time == evtime && e.event != ev) {
                e = e.left;
            }
            if (e.event != ev) {
                return null;
            }
        }
        return e;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class HItr
    implements ListIterator<Event> {
        private Entry prev;
        private Entry next;
        private Entry lastRet;
        private int expectedModCount;
        private int nextIndex;

        private HItr() {
            this.prev = Henriksen.this.firstEntry;
            this.next = ((Henriksen)Henriksen.this).firstEntry.right;
            this.expectedModCount = Henriksen.this.modCount;
            this.lastRet = null;
            this.nextIndex = 0;
        }

        @Override
        public void add(Event ev) {
            Entry e;
            if (Henriksen.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            if (ev.time() > this.next.time) {
                ev.setTime(this.next.time);
            }
            if (ev.time() < this.prev.time) {
                ev.setTime(this.prev.time);
            }
            this.prev.right = e = new Entry(ev, this.prev, this.next, ev.time());
            this.next.left = e;
            this.prev = e;
            ++this.nextIndex;
            this.lastRet = null;
            Henriksen.this.modCount++;
            ++this.expectedModCount;
        }

        @Override
        public boolean hasNext() {
            if (Henriksen.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            return this.next != Henriksen.this.entryVec[0];
        }

        @Override
        public boolean hasPrevious() {
            if (Henriksen.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            return this.next != Henriksen.this.firstEntry;
        }

        @Override
        public Event next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            ++this.nextIndex;
            Event ev = this.next.event;
            this.lastRet = this.next;
            this.next = this.next.right;
            this.prev = this.prev.right;
            return ev;
        }

        @Override
        public int nextIndex() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.nextIndex;
        }

        @Override
        public Event previous() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            --this.nextIndex;
            Event ev = this.prev.event;
            this.lastRet = this.prev;
            this.prev = this.prev.left;
            this.next = this.next.left;
            return ev;
        }

        @Override
        public int previousIndex() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            return this.nextIndex - 1;
        }

        @Override
        public void remove() {
            if (Henriksen.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            if (this.lastRet == null) {
                throw new IllegalStateException();
            }
            if (this.lastRet == this.next) {
                if (this.next != Henriksen.this.entryVec[0]) {
                    this.next = this.next.right;
                }
            } else if (this.prev != Henriksen.this.firstEntry) {
                this.prev = this.prev.left;
                --this.nextIndex;
            }
            double evtime = this.lastRet.time;
            int i = Henriksen.this.findIndex(evtime);
            ++i;
            while (i < Henriksen.this.vectSize && ((Henriksen)Henriksen.this).entryVec[i].time == evtime) {
                if (((Henriksen)Henriksen.this).entryVec[i].event == this.lastRet.event) {
                    ((Henriksen)Henriksen.this).entryVec[i] = this.lastRet.left;
                }
                ++i;
            }
            this.lastRet.event = null;
            this.lastRet.left.right = this.lastRet.right;
            this.lastRet.right.left = this.lastRet.left;
            this.lastRet.left = null;
            this.lastRet.right = null;
            this.lastRet = null;
            Henriksen.this.modCount++;
            ++this.expectedModCount;
        }

        @Override
        public void set(Event ev) {
            if (Henriksen.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            if (this.lastRet == null) {
                throw new IllegalStateException();
            }
            if (ev.time() < this.lastRet.left.time) {
                ev.setTime(this.lastRet.left.time);
            }
            if (ev.time() > this.lastRet.right.time) {
                ev.setTime(this.lastRet.right.time);
            }
            this.lastRet.event = ev;
        }
    }

    private static class Entry {
        public Event event;
        public Entry left;
        public Entry right;
        public double time;

        Entry(Event event, Entry left, Entry right, double time) {
            this.event = event;
            this.left = left;
            this.right = right;
            this.time = time;
        }

        public String toString() {
            return "[" + this.event + " |" + this.time + "|]";
        }
    }
}

