/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.probdist;

import optimization.Uncmin_f77;
import optimization.Uncmin_methods;
import umontreal.iro.lecuyer.probdist.ContinuousDistribution;
import umontreal.iro.lecuyer.probdist.EmpiricalDist;
import umontreal.iro.lecuyer.util.Misc;

public class LoglogisticDist
extends ContinuousDistribution {
    private double alpha;
    private double beta;

    public LoglogisticDist(double alpha, double beta) {
        this.setParams(alpha, beta);
    }

    public double density(double x) {
        return LoglogisticDist.density(this.alpha, this.beta, x);
    }

    public double cdf(double x) {
        return LoglogisticDist.cdf(this.alpha, this.beta, x);
    }

    public double barF(double x) {
        return LoglogisticDist.barF(this.alpha, this.beta, x);
    }

    public double inverseF(double u) {
        return LoglogisticDist.inverseF(this.alpha, this.beta, u);
    }

    public double getMean() {
        return LoglogisticDist.getMean(this.alpha, this.beta);
    }

    public double getVariance() {
        return LoglogisticDist.getVariance(this.alpha, this.beta);
    }

    public double getStandardDeviation() {
        return LoglogisticDist.getStandardDeviation(this.alpha, this.beta);
    }

    public static double density(double alpha, double beta, double x) {
        if (alpha <= 0.0) {
            throw new IllegalArgumentException("alpha <= 0");
        }
        if (beta <= 0.0) {
            throw new IllegalArgumentException("beta <= 0");
        }
        if (x <= 0.0 || x >= 8.988465674311579E307) {
            return 0.0;
        }
        if (x <= beta) {
            double v = Math.pow(x / beta, alpha);
            double denominateur = 1.0 + v;
            denominateur *= denominateur * beta;
            return alpha * v * beta / (x * denominateur);
        }
        double v = Math.pow(beta / x, alpha);
        double denominateur = 1.0 + v;
        denominateur *= denominateur * beta;
        return alpha * v * beta / (x * denominateur);
    }

    public static double cdf(double alpha, double beta, double x) {
        if (alpha <= 0.0) {
            throw new IllegalArgumentException("alpha <= 0");
        }
        if (beta <= 0.0) {
            throw new IllegalArgumentException("beta <= 0");
        }
        if (x <= 0.0) {
            return 0.0;
        }
        if (x >= 8.988465674311579E307) {
            return 1.0;
        }
        double z = x / beta;
        if (z >= 1.0) {
            return 1.0 / (1.0 + Math.pow(1.0 / z, alpha));
        }
        double v = Math.pow(z, alpha);
        return v / (v + 1.0);
    }

    public static double barF(double alpha, double beta, double x) {
        if (alpha <= 0.0) {
            throw new IllegalArgumentException("alpha <= 0");
        }
        if (beta <= 0.0) {
            throw new IllegalArgumentException("beta <= 0");
        }
        if (x <= 0.0) {
            return 1.0;
        }
        if (x >= 8.988465674311579E307) {
            return 0.0;
        }
        double z = x / beta;
        if (z <= 1.0) {
            return 1.0 / (1.0 + Math.pow(z, alpha));
        }
        double v = Math.pow(1.0 / z, alpha);
        return v / (v + 1.0);
    }

    public static double inverseF(double alpha, double beta, double u) {
        if (alpha <= 0.0) {
            throw new IllegalArgumentException("alpha <= 0");
        }
        if (beta <= 0.0) {
            throw new IllegalArgumentException("beta <= 0");
        }
        if (u < 0.0 || u > 1.0) {
            throw new IllegalArgumentException("u not in (0, 1]");
        }
        if (u >= 1.0) {
            return Double.POSITIVE_INFINITY;
        }
        if (u <= 0.0) {
            return 0.0;
        }
        if (u <= 0.5) {
            return beta * Math.pow(u / (1.0 - u), 1.0 / alpha);
        }
        return beta / Math.pow((1.0 - u) / u, 1.0 / alpha);
    }

    public static double[] getMLE(double[] x, int n) {
        int m;
        double q1;
        double sum = 0.0;
        if (n <= 0) {
            throw new IllegalArgumentException("n <= 0");
        }
        Optim system = new Optim(x, n);
        double[] parameters = new double[2];
        double[] xpls = new double[3];
        double[] param = new double[3];
        double[] fpls = new double[3];
        double[] gpls = new double[3];
        int[] itrcmd = new int[2];
        double[][] a = new double[3][3];
        double[] udiag = new double[3];
        param[2] = EmpiricalDist.getMedian(x, n);
        if (param[2] < 0.0) {
            throw new IllegalArgumentException("median < 0");
        }
        if (param[2] <= 0.0) {
            param[2] = 1.0;
        }
        if ((q1 = Misc.quickSelect(x, n, m = Math.round((float)n / 4.0f))) < 0.0) {
            throw new IllegalArgumentException("x[i] < 0");
        }
        param[1] = q1 > 0.0 ? Math.log(3.0) / (Math.log(param[2]) - Math.log(q1)) : 1.0;
        Uncmin_f77.optif0_f77((int)2, (double[])param, (Uncmin_methods)system, (double[])xpls, (double[])fpls, (double[])gpls, (int[])itrcmd, (double[][])a, (double[])udiag);
        for (int i = 0; i < 2; ++i) {
            parameters[i] = xpls[i + 1];
        }
        return parameters;
    }

    @Deprecated
    public static double[] getMaximumLikelihoodEstimate(double[] x, int n) {
        return LoglogisticDist.getMLE(x, n);
    }

    public static LoglogisticDist getInstanceFromMLE(double[] x, int n) {
        double[] parameters = LoglogisticDist.getMaximumLikelihoodEstimate(x, n);
        return new LoglogisticDist(parameters[0], parameters[1]);
    }

    public static double getMean(double alpha, double beta) {
        if (alpha <= 1.0) {
            throw new IllegalArgumentException("alpha <= 1");
        }
        if (beta <= 0.0) {
            throw new IllegalArgumentException("beta <= 0");
        }
        double theta = Math.PI / alpha;
        return beta * theta / Math.sin(theta);
    }

    public static double getVariance(double alpha, double beta) {
        if (alpha <= 2.0) {
            throw new IllegalArgumentException("alpha <= 2");
        }
        if (beta <= 0.0) {
            throw new IllegalArgumentException("beta <= 0");
        }
        double theta = Math.PI / alpha;
        return beta * beta * theta * (2.0 / Math.sin(2.0 * theta) - theta / (Math.sin(theta) * Math.sin(theta)));
    }

    public static double getStandardDeviation(double alpha, double beta) {
        return Math.sqrt(LoglogisticDist.getVariance(alpha, beta));
    }

    public double getAlpha() {
        return this.alpha;
    }

    public double getBeta() {
        return this.beta;
    }

    public void setParams(double alpha, double beta) {
        if (alpha <= 0.0) {
            throw new IllegalArgumentException("alpha <= 0");
        }
        if (beta <= 0.0) {
            throw new IllegalArgumentException("beta <= 0");
        }
        this.alpha = alpha;
        this.beta = beta;
        this.supportA = 0.0;
    }

    public double[] getParams() {
        double[] retour = new double[]{this.alpha, this.beta};
        return retour;
    }

    public String toString() {
        return this.getClass().getName() + " : alpha = " + this.alpha + ", beta = " + this.beta;
    }

    private static class Optim
    implements Uncmin_methods {
        private int n;
        private double[] xi;

        public Optim(double[] x, int n) {
            this.n = n;
            this.xi = new double[n];
            System.arraycopy(x, 0, this.xi, 0, n);
        }

        public double f_to_minimize(double[] p) {
            if (p[1] <= 0.0 || p[2] <= 0.0) {
                return 1.0E200;
            }
            double sum = 0.0;
            for (int i = 0; i < this.n; ++i) {
                double tmp = LoglogisticDist.density(p[1], p[2], this.xi[i]);
                if (tmp > 0.0) {
                    sum -= Math.log(tmp);
                    continue;
                }
                sum += 709.0;
            }
            return sum;
        }

        public void gradient(double[] x, double[] g) {
        }

        public void hessian(double[] x, double[][] h) {
        }
    }
}

