/*
 * Decompiled with CFR 0.152.
 */
package supplementary.cookbook.recipes;

import de.jstacs.classifiers.performanceMeasures.NumericalPerformanceMeasureParameterSet;
import de.jstacs.classifiers.performanceMeasures.PerformanceMeasureParameterSet;
import de.jstacs.classifiers.trainSMBased.TrainSMBasedClassifier;
import de.jstacs.data.DNADataSet;
import de.jstacs.data.DataSet;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.sequenceScores.statisticalModels.trainable.TrainableStatisticalModelFactory;
import de.jstacs.sequenceScores.statisticalModels.trainable.discrete.homogeneous.HomogeneousMM;
import de.jstacs.sequenceScores.statisticalModels.trainable.discrete.inhomogeneous.FSDAGTrainSM;

public class TrainClassifier {
    public static void main(String[] args) throws Exception {
        DataSet[] data = new DataSet[]{new DNADataSet(args[0]), new DNADataSet(args[1])};
        FSDAGTrainSM pwm = TrainableStatisticalModelFactory.createPWM(data[0].getAlphabetContainer(), data[0].getElementLength(), 4.0);
        HomogeneousMM hmm = TrainableStatisticalModelFactory.createHomogeneousMarkovModel(data[1].getAlphabetContainer(), 4.0, (byte)1);
        TrainSMBasedClassifier cl = new TrainSMBasedClassifier(pwm, hmm);
        cl.train(data);
        System.out.println(cl);
        Sequence seq = data[0].getElementAt(0);
        byte res = cl.classify(seq);
        System.out.println(seq + " -> " + res);
        NumericalPerformanceMeasureParameterSet params = PerformanceMeasureParameterSet.createFilledParameters();
        System.out.println(cl.evaluate((PerformanceMeasureParameterSet)params, true, data));
    }
}

