/*
 * Decompiled with CFR 0.152.
 */
package projects.dispom;

import de.jstacs.classifiers.utils.PValueComputation;
import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.DataSet;
import de.jstacs.data.alphabets.ComplementableDiscreteAlphabet;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.utils.ComparableElement;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Random;

public class PFMComparator {
    private static Random r = new Random();

    public static String matrixToString(double[][] matrix) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < matrix.length) {
            sb.append(matrix[i][0]);
            int j = 1;
            while (j < matrix[i].length) {
                sb.append('\t');
                sb.append(matrix[i][j]);
                ++j;
            }
            sb.append('\n');
            ++i;
        }
        return sb.toString();
    }

    public static String getConsensus(AlphabetContainer con, double[][] pfm) {
        String c = "";
        int l = 0;
        while (l < pfm.length) {
            int m = 0;
            int p = 1;
            while (p < pfm[l].length) {
                if (pfm[l][m] < pfm[l][p]) {
                    m = p;
                }
                ++p;
            }
            c = String.valueOf(c) + con.getSymbol(l, m);
            ++l;
        }
        return c;
    }

    public static double[] getCounts(DataSet ... data) {
        double[] counts = new double[(int)data[0].getAlphabetContainer().getAlphabetLengthAt(0)];
        int d = 0;
        while (d < data.length) {
            int n = 0;
            while (n < data[d].getNumberOfElements()) {
                Sequence seq = data[d].getElementAt(n);
                int l = 0;
                while (l < seq.getLength()) {
                    int n2 = seq.discreteVal(l);
                    counts[n2] = counts[n2] + 1.0;
                    ++l;
                }
                ++n;
            }
            ++d;
        }
        return counts;
    }

    public static void normalize(double[] counts) {
        double sum = 0.0;
        int l = 0;
        while (l < counts.length) {
            sum += counts[l];
            ++l;
        }
        l = 0;
        while (l < counts.length) {
            int n = l++;
            counts[n] = counts[n] / sum;
        }
    }

    public static double[][] getPFM(DataSet data) {
        if (data == null) {
            return null;
        }
        double[][] pfm = new double[data.getElementLength()][];
        AlphabetContainer con = data.getAlphabetContainer();
        int l = 0;
        while (l < pfm.length) {
            pfm[l] = new double[(int)con.getAlphabetLengthAt(l)];
            ++l;
        }
        int n = 0;
        while (n < data.getNumberOfElements()) {
            Sequence seq = data.getElementAt(n);
            int l2 = 0;
            while (l2 < pfm.length) {
                double[] dArray = pfm[l2];
                int n2 = seq.discreteVal(l2);
                dArray[n2] = dArray[n2] + 1.0;
                ++l2;
            }
            ++n;
        }
        return pfm;
    }

    public static double[][] getPFM(DataSet data, double[] weights) {
        if (data == null) {
            return null;
        }
        double[][] pfm = new double[data.getElementLength()][];
        AlphabetContainer con = data.getAlphabetContainer();
        int l = 0;
        while (l < pfm.length) {
            pfm[l] = new double[(int)con.getAlphabetLengthAt(l)];
            ++l;
        }
        int n = 0;
        while (n < data.getNumberOfElements()) {
            Sequence seq = data.getElementAt(n);
            int l2 = 0;
            while (l2 < pfm.length) {
                double[] dArray = pfm[l2];
                int n2 = seq.discreteVal(l2);
                dArray[n2] = dArray[n2] + weights[n];
                ++l2;
            }
            ++n;
        }
        return pfm;
    }

    public static double[][] getReverseComplement(ComplementableDiscreteAlphabet abc, double[][] pfm) {
        int length = pfm.length;
        int symbols = (int)abc.length();
        double[][] pfmRC = new double[length][symbols];
        int l = 0;
        while (l < length) {
            int a = 0;
            while (a < symbols) {
                pfmRC[l][a] = pfm[length - 1 - l][abc.getComplementaryCode(a)];
                ++a;
            }
            ++l;
        }
        return pfmRC;
    }

    public static ArrayList<AbstractMap.SimpleEntry<String, double[][]>> readPFMsFromUniprobe(String startdir) throws IOException {
        LinkedList<File> dirs = new LinkedList<File>();
        dirs.add(new File(startdir));
        ArrayList<AbstractMap.SimpleEntry<String, double[][]>> res = new ArrayList<AbstractMap.SimpleEntry<String, double[][]>>();
        ArrayList<String> strs = new ArrayList<String>();
        while (dirs.size() > 0) {
            File dir = (File)dirs.pop();
            File[] files = dir.listFiles();
            int i = 0;
            while (i < files.length) {
                if (files[i].isDirectory() && !files[i].isHidden()) {
                    dirs.add(files[i]);
                } else if (files[i].getName().endsWith(".txt") || files[i].getName().endsWith(".pwm")) {
                    String annot = String.valueOf(dir.getName()) + "-" + files[i].getName().substring(0, files[i].getName().lastIndexOf(46));
                    BufferedReader read = new BufferedReader(new FileReader(files[i]));
                    annot = String.valueOf(annot) + ": " + read.readLine().trim();
                    String line = null;
                    while ((line = read.readLine()) != null) {
                        if ((line = line.trim()).length() <= 0) continue;
                        strs.add(line);
                    }
                    String[] strings = new String[4];
                    int j = strs.size() - 4;
                    int k = 0;
                    while (j < strs.size()) {
                        strings[k] = (String)strs.get(j);
                        if (strings[k].indexOf(58) >= 0) {
                            strings[k] = strings[k].substring(strings[k].indexOf(58) + 1).trim();
                        }
                        ++j;
                        ++k;
                    }
                    String[] parts = strings[0].split("\\s+");
                    double[][] pwm = new double[parts.length][4];
                    int j2 = 0;
                    while (j2 < strings.length) {
                        parts = strings[j2].split("\\s+");
                        if (parts.length != pwm.length) {
                            throw new RuntimeException();
                        }
                        int k2 = 0;
                        while (k2 < parts.length) {
                            pwm[k2][j2] = Double.parseDouble(parts[k2]);
                            ++k2;
                        }
                        ++j2;
                    }
                    res.add(new AbstractMap.SimpleEntry<String, double[][]>(annot, pwm));
                }
                ++i;
            }
        }
        return res;
    }

    public static ArrayList<AbstractMap.SimpleEntry<String, double[][]>> readPFMsFromJasparFastA(String filename) throws IOException {
        String line;
        ArrayList<AbstractMap.SimpleEntry<String, double[][]>> res = new ArrayList<AbstractMap.SimpleEntry<String, double[][]>>();
        BufferedReader r = new BufferedReader(new FileReader(new File(filename)));
        String annot = null;
        double[][] mat = null;
        int i = 0;
        while ((line = r.readLine()) != null) {
            if ((line = line.trim()).startsWith(">")) {
                if (mat != null) {
                    res.add(new AbstractMap.SimpleEntry<String, Object>(annot, mat));
                    annot = null;
                    mat = null;
                }
                annot = line.substring(1).trim();
                i = 0;
                continue;
            }
            line = line.substring(line.indexOf(91) + 1, line.lastIndexOf(93)).trim();
            String[] parts = line.split("\\s+");
            if (mat == null) {
                mat = new double[parts.length][4];
            }
            int j = 0;
            while (j < parts.length) {
                mat[j][i] = Double.parseDouble(parts[j]);
                ++j;
            }
            ++i;
        }
        if (mat != null) {
            res.add(new AbstractMap.SimpleEntry<Object, Object>(annot, mat));
        }
        return res;
    }

    public static ArrayList<AbstractMap.SimpleEntry<String, double[][]>> readPFMsFromEMBL(String fileName, int max) throws IOException {
        String line;
        ArrayList<AbstractMap.SimpleEntry<String, double[][]>> res = new ArrayList<AbstractMap.SimpleEntry<String, double[][]>>();
        ArrayList<double[]> pfm = new ArrayList<double[]>();
        double[][] tooSmall = new double[][]{};
        BufferedReader r = new BufferedReader(new FileReader(new File(fileName)));
        while (res.size() < max && (line = r.readLine()) != null) {
            if (!line.startsWith("AC")) continue;
            String annot = line.substring(line.indexOf(32)).trim();
            while (!(line = r.readLine()).startsWith("ID")) {
            }
            annot = String.valueOf(annot) + " (" + line.substring(line.indexOf(32)).trim() + ")";
            while (!(line = r.readLine()).startsWith("01")) {
            }
            pfm.clear();
            do {
                String[] split = line.split("[ ]+");
                double[] positionalFrequencies = new double[split.length - 2];
                int a = 0;
                while (a < positionalFrequencies.length) {
                    positionalFrequencies[a] = Double.parseDouble(split[1 + a]);
                    ++a;
                }
                pfm.add(positionalFrequencies);
            } while (!(line = r.readLine()).startsWith("XX"));
            res.add(new AbstractMap.SimpleEntry<String, double[][]>(annot, (double[][])pfm.toArray((T[])tooSmall)));
            while (!(line = r.readLine()).startsWith("//")) {
            }
        }
        r.close();
        return res;
    }

    public static ComparableElement<String, Double>[] find(ComplementableDiscreteAlphabet abc, double[][] pfm, ArrayList<AbstractMap.SimpleEntry<String, double[][]>> knownPFMs, PFMDistance distance, int minOverlap, int allowMiniShift, boolean pValues, double threshold) {
        int i;
        ArrayList<ComparableElement<String, Double>> list = new ArrayList<ComparableElement<String, Double>>(10);
        double[][] pfmRC = PFMComparator.getReverseComplement(abc, pfm);
        int m = Math.min(minOverlap, pfm.length - allowMiniShift);
        int columns = 0;
        Hashtable<Integer, double[]> scores = new Hashtable<Integer, double[]>();
        if (pValues) {
            i = 0;
            while (i < knownPFMs.size()) {
                columns += knownPFMs.get(i).getValue().length;
                ++i;
            }
        }
        i = 0;
        while (i < knownPFMs.size()) {
            double[][] currentCand = knownPFMs.get(i).getValue();
            int myMinimalOverlap = Math.min(m, currentCand.length - allowMiniShift);
            double d = Math.min(distance.compare(pfm, currentCand, myMinimalOverlap), distance.compare(pfmRC, currentCand, myMinimalOverlap));
            if (pValues) {
                double[] values = (double[])scores.get(currentCand.length);
                if (values == null) {
                    values = new double[1000];
                    double[][] randomPFM = new double[currentCand.length][];
                    int n = 0;
                    while (n < values.length) {
                        int l = 0;
                        while (l < randomPFM.length) {
                            int len;
                            int c = r.nextInt(columns);
                            int idx = 0;
                            while ((len = knownPFMs.get(idx).getValue().length) <= c) {
                                c -= len;
                                ++idx;
                            }
                            randomPFM[l] = knownPFMs.get(idx).getValue()[c];
                            ++l;
                        }
                        values[n] = Math.min(distance.compare(pfm, randomPFM, myMinimalOverlap), distance.compare(pfmRC, randomPFM, myMinimalOverlap));
                        ++n;
                    }
                    Arrays.sort(values);
                    scores.put(currentCand.length, values);
                }
                d = PValueComputation.getPValue(values, d);
            }
            if (d <= threshold) {
                list.add(new ComparableElement<String, Double>(knownPFMs.get(i).getKey(), d));
            }
            ++i;
        }
        Object[] res = list.toArray(new ComparableElement[0]);
        Arrays.sort(res);
        return res;
    }

    public static class NormalizedEuclideanDistance
    extends PFMDistance {
        @Override
        protected double getDistance(double[][] pfm1, double[][] pfm2, int l1, int l2) {
            double res = 0.0;
            int l = 0;
            while (l1 < pfm1.length && l2 < pfm2.length) {
                if (pfm1[l1].length != pfm2[l2].length) {
                    throw new IllegalArgumentException("The PFMs are not comparable at column " + l1 + " and " + l2 + ".");
                }
                double sum2 = 0.0;
                double sum1 = 0.0;
                int a = 0;
                while (a < pfm1[l1].length) {
                    sum1 += pfm1[l1][a];
                    sum2 += pfm2[l2][a];
                    ++a;
                }
                double sum = 0.0;
                a = 0;
                while (a < pfm1[l1].length) {
                    double diff = pfm1[l1][a] / sum1 - pfm2[l2][a] / sum2;
                    sum += diff * diff;
                    ++a;
                }
                res += Math.sqrt(sum);
                ++l1;
                ++l2;
                ++l;
            }
            return res / (Math.sqrt(2.0) * (double)l);
        }
    }

    public static class OneMinusPearsonCorrelationCoefficient
    extends PFMDistance {
        @Override
        protected double getDistance(double[][] pfm1, double[][] pfm2, int l1, int l2) {
            double res = 0.0;
            int l = 0;
            while (l1 < pfm1.length && l2 < pfm2.length) {
                if (pfm1[l1].length != pfm2[l2].length) {
                    throw new IllegalArgumentException("The PFMs are not comparable at column " + l1 + " and " + l2 + ".");
                }
                double sum2 = 0.0;
                double sum1 = 0.0;
                int a = 0;
                while (a < pfm1[l1].length) {
                    sum1 += pfm1[l1][a];
                    sum2 += pfm2[l2][a];
                    ++a;
                }
                double s2 = 0.0;
                double s1 = 0.0;
                double s = 0.0;
                a = 0;
                while (a < pfm1[l1].length) {
                    double d1 = pfm1[l1][a] / sum1 - 0.25;
                    double d2 = pfm2[l2][a] / sum2 - 0.25;
                    s += d1 * d2;
                    s1 += d1 * d1;
                    s2 += d2 * d2;
                    ++a;
                }
                res += s / Math.sqrt(s1 * s2);
                ++l1;
                ++l2;
                ++l;
            }
            return 1.0 - 1.0 / (double)l * res;
        }
    }

    public static abstract class PFMDistance {
        public final double getDistance(double[][] pfm1, double[][] pfm2, int offset) {
            if (offset >= 0) {
                return this.getDistance(pfm1, pfm2, offset, 0);
            }
            return this.getDistance(pfm1, pfm2, 0, -offset);
        }

        protected abstract double getDistance(double[][] var1, double[][] var2, int var3, int var4);

        public double compare(double[][] pfm1, double[][] pfm2, int minimalOverlap) {
            int l1 = pfm1.length;
            int l2 = pfm2.length;
            if (l1 < minimalOverlap || l2 < minimalOverlap) {
                throw new IllegalArgumentException("The PFM are too small to have a minimal overlap of " + minimalOverlap + ".");
            }
            double best = Double.POSITIVE_INFINITY;
            int offset = minimalOverlap - l2;
            while (offset <= l1 - minimalOverlap) {
                double current = this.getDistance(pfm1, pfm2, offset);
                if (current < best) {
                    best = current;
                }
                ++offset;
            }
            return best;
        }
    }

    public static class SymmetricKullbackLeiblerDivergence
    extends PFMDistance {
        private double ess;

        public SymmetricKullbackLeiblerDivergence(double ess) throws IllegalArgumentException {
            if (ess < 0.0) {
                throw new IllegalArgumentException("The ess has to be non-negative.");
            }
            this.ess = ess;
        }

        @Override
        protected double getDistance(double[][] pfm1, double[][] pfm2, int l1, int l2) {
            double res = 0.0;
            int l = 0;
            while (l1 < pfm1.length && l2 < pfm2.length) {
                double sum2;
                if (pfm1[l1].length != pfm2[l2].length) {
                    throw new IllegalArgumentException("The PFMs are not comparable at column " + l1 + " and " + l2 + ".");
                }
                double sum1 = sum2 = this.ess;
                double pc = this.ess / (double)pfm1[l1].length;
                int a = 0;
                while (a < pfm1[l1].length) {
                    sum1 += pfm1[l1][a];
                    sum2 += pfm2[l2][a];
                    ++a;
                }
                a = 0;
                while (a < pfm1[l1].length) {
                    double p1_a = (pc + pfm1[l1][a]) / sum1;
                    double p2_a = (pc + pfm2[l2][a]) / sum2;
                    res += (p1_a - p2_a) * Math.log(p1_a / p2_a);
                    ++a;
                }
                ++l1;
                ++l2;
                ++l;
            }
            return 1.0 / (2.0 * (double)l) * res;
        }
    }
}

