/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.numericalMethods.calculus.differentiation;

import de.jtem.numericalMethods.calculus.differentiation.Ridders;
import de.jtem.numericalMethods.calculus.function.RealFunctionOfOneVariable;
import de.jtem.numericalMethods.calculus.function.RealFunctionOfSeveralVariables;
import de.jtem.numericalMethods.calculus.function.RealFunctionOfSeveralVariablesWithGradient;
import de.jtem.numericalMethods.calculus.function.RealVectorValuedFunctionOfSeveralVariables;
import de.jtem.numericalMethods.calculus.function.RealVectorValuedFunctionOfSeveralVariablesWithJacobien;
import java.util.HashMap;

public class NumericalDerivative {
    static final int DEFALUT_MAX_TABLE_LENGTH = 10;

    NumericalDerivative() {
    }

    public static RealVectorValuedFunctionOfSeveralVariablesWithJacobien createDerivativeNumerically(RealVectorValuedFunctionOfSeveralVariables realVectorValuedFunctionOfSeveralVariables, double d) {
        return NumericalDerivative.createDerivativeNumerically(realVectorValuedFunctionOfSeveralVariables, d, 10, false);
    }

    public static RealVectorValuedFunctionOfSeveralVariablesWithJacobien createDerivativeNumerically(final RealVectorValuedFunctionOfSeveralVariables realVectorValuedFunctionOfSeveralVariables, final double d, final int n, final boolean bl) {
        return new RealVectorValuedFunctionOfSeveralVariablesWithJacobien(){

            public void eval(double[] dArray, double[] dArray2, int n2, double[][] dArray3) {
                realVectorValuedFunctionOfSeveralVariables.eval(dArray, dArray2, n2);
                NumericalDerivative.computeJacobienByRidders(realVectorValuedFunctionOfSeveralVariables, dArray, dArray3, null, d, n, bl);
            }

            public int getDimensionOfTargetSpace() {
                return realVectorValuedFunctionOfSeveralVariables.getDimensionOfTargetSpace();
            }

            public int getNumberOfVariables() {
                return realVectorValuedFunctionOfSeveralVariables.getNumberOfVariables();
            }

            public void eval(double[] dArray, double[] dArray2, int n2) {
                realVectorValuedFunctionOfSeveralVariables.eval(dArray, dArray2, n2);
            }
        };
    }

    public static void computeJacobienByRidders(RealVectorValuedFunctionOfSeveralVariables realVectorValuedFunctionOfSeveralVariables, double[] dArray, double[][] dArray2, double[][] dArray3, double d) {
        NumericalDerivative.computeJacobienByRidders(realVectorValuedFunctionOfSeveralVariables, dArray, dArray2, dArray3, d, 10, false);
    }

    public static void computeJacobienByRidders(RealVectorValuedFunctionOfSeveralVariables realVectorValuedFunctionOfSeveralVariables, double[] dArray, double[][] dArray2, double[][] dArray3, double d, int n, boolean bl) {
        CoordinateVariableProjection coordinateVariableProjection = new CoordinateVariableProjection(realVectorValuedFunctionOfSeveralVariables, dArray, bl);
        double[] dArray4 = new double[1];
        coordinateVariableProjection.variable = 0;
        while (coordinateVariableProjection.variable < coordinateVariableProjection.numberOfVariables) {
            if (bl) {
                coordinateVariableProjection.hashMap.clear();
            }
            coordinateVariableProjection.coordinate = 0;
            while (coordinateVariableProjection.coordinate < coordinateVariableProjection.dimensionOfTargetSpace) {
                dArray2[coordinateVariableProjection.coordinate][coordinateVariableProjection.variable] = Ridders.compute(coordinateVariableProjection, 0.0, d, dArray4);
                if (dArray3 != null) {
                    dArray3[coordinateVariableProjection.coordinate][coordinateVariableProjection.variable] = dArray4[0];
                }
                ++coordinateVariableProjection.coordinate;
            }
            ++coordinateVariableProjection.variable;
        }
    }

    public static RealFunctionOfSeveralVariablesWithGradient createDerivativeNumerically(RealFunctionOfSeveralVariables realFunctionOfSeveralVariables, double d) {
        return NumericalDerivative.createDerivativeNumerically(realFunctionOfSeveralVariables, d, 10);
    }

    public static RealFunctionOfSeveralVariablesWithGradient createDerivativeNumerically(final RealFunctionOfSeveralVariables realFunctionOfSeveralVariables, final double d, final int n) {
        return new RealFunctionOfSeveralVariablesWithGradient(){

            public double eval(double[] dArray, double[] dArray2) {
                NumericalDerivative.computeGradientByRidders(realFunctionOfSeveralVariables, dArray, dArray2, null, d, n);
                return realFunctionOfSeveralVariables.eval(dArray);
            }

            public int getNumberOfVariables() {
                return realFunctionOfSeveralVariables.getNumberOfVariables();
            }

            public double eval(double[] dArray) {
                return realFunctionOfSeveralVariables.eval(dArray);
            }
        };
    }

    public static void computeGradientByRidders(RealFunctionOfSeveralVariables realFunctionOfSeveralVariables, double[] dArray, double[] dArray2, double[] dArray3, double d) {
        NumericalDerivative.computeGradientByRidders(realFunctionOfSeveralVariables, dArray, dArray2, dArray3, d, 10);
    }

    public static void computeGradientByRidders(RealFunctionOfSeveralVariables realFunctionOfSeveralVariables, double[] dArray, double[] dArray2, double[] dArray3, double d, int n) {
        VariableProjection variableProjection = new VariableProjection(realFunctionOfSeveralVariables, dArray);
        double[] dArray4 = new double[1];
        variableProjection.variable = 0;
        while (variableProjection.variable < variableProjection.numberOfVariables) {
            dArray2[variableProjection.variable] = Ridders.compute(variableProjection, 0.0, d, dArray4);
            if (dArray3 != null) {
                dArray3[variableProjection.variable] = dArray4[0];
            }
            ++variableProjection.variable;
        }
    }

    static class VariableProjection
    implements RealFunctionOfOneVariable {
        final RealFunctionOfSeveralVariables F;
        final int numberOfVariables;
        int variable = 0;
        final double[] x;

        VariableProjection(RealFunctionOfSeveralVariables realFunctionOfSeveralVariables, double[] dArray) {
            this.F = realFunctionOfSeveralVariables;
            this.x = dArray;
            this.numberOfVariables = realFunctionOfSeveralVariables.getNumberOfVariables();
        }

        public double eval(double d) {
            double d2 = this.x[this.variable];
            int n = this.variable;
            this.x[n] = this.x[n] + d;
            double d3 = this.F.eval(this.x);
            this.x[this.variable] = d2;
            return d3;
        }
    }

    static class CoordinateVariableProjection
    implements RealFunctionOfOneVariable {
        final RealVectorValuedFunctionOfSeveralVariables F;
        final int numberOfVariables;
        final int dimensionOfTargetSpace;
        int coordinate = 0;
        int variable = 0;
        final double[] x;
        final double[] values;
        final HashMap hashMap;

        CoordinateVariableProjection(RealVectorValuedFunctionOfSeveralVariables realVectorValuedFunctionOfSeveralVariables, double[] dArray, boolean bl) {
            this.F = realVectorValuedFunctionOfSeveralVariables;
            this.x = dArray;
            this.hashMap = bl ? new HashMap() : null;
            this.numberOfVariables = realVectorValuedFunctionOfSeveralVariables.getNumberOfVariables();
            this.dimensionOfTargetSpace = realVectorValuedFunctionOfSeveralVariables.getDimensionOfTargetSpace();
            this.values = new double[this.dimensionOfTargetSpace];
        }

        public double eval(double d) {
            double[] dArray;
            Double d2 = null;
            if (this.hashMap != null && (dArray = (double[])this.hashMap.get(d2 = new Double(d))) != null) {
                return dArray[this.coordinate];
            }
            double d3 = this.x[this.variable];
            int n = this.variable;
            this.x[n] = this.x[n] + d;
            this.F.eval(this.x, this.values, 0);
            this.x[this.variable] = d3;
            if (this.hashMap != null) {
                this.hashMap.put(d2, this.values.clone());
            }
            return this.values[this.coordinate];
        }
    }
}

