/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.classifiers;

import de.jstacs.Storable;
import de.jstacs.classifiers.ClassDimensionException;
import de.jstacs.classifiers.performanceMeasures.AbstractPerformanceMeasure;
import de.jstacs.classifiers.performanceMeasures.PerformanceMeasureParameterSet;
import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.DataSet;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.io.NonParsableException;
import de.jstacs.io.XMLParser;
import de.jstacs.results.CategoricalResult;
import de.jstacs.results.NumericalResultSet;
import de.jstacs.results.ResultSet;
import de.jstacs.results.StorableResult;
import java.util.LinkedList;

public abstract class AbstractClassifier
implements Storable,
Cloneable {
    private AlphabetContainer alphabets;
    private int length;

    public AbstractClassifier(AlphabetContainer abc) {
        this(abc, 0);
    }

    public AbstractClassifier(AlphabetContainer abc, int length) throws IllegalArgumentException {
        int l = abc.getPossibleLength();
        if (l != 0 && l != length) {
            throw new IllegalArgumentException("The length and the possible length of the AlphabetContainer does not match.");
        }
        this.alphabets = abc;
        this.length = length;
    }

    public AbstractClassifier(StringBuffer xml) throws NonParsableException {
        this.alphabets = null;
        this.length = -1;
        this.fromXML(xml);
        if (this.length < 0 || this.alphabets == null) {
            throw new NonParsableException("The alphabets or the length were not set.");
        }
    }

    public abstract byte classify(Sequence var1) throws Exception;

    public byte[] classify(DataSet s) throws Exception {
        byte[] clazz = new byte[s.getNumberOfElements()];
        DataSet.ElementEnumerator ei = new DataSet.ElementEnumerator(s);
        int i = 0;
        while (i < clazz.length) {
            clazz[i] = this.classify(ei.nextElement());
            ++i;
        }
        return clazz;
    }

    public AbstractClassifier clone() throws CloneNotSupportedException {
        return (AbstractClassifier)super.clone();
    }

    public final ResultSet evaluate(PerformanceMeasureParameterSet params, boolean exceptionIfNotComputeable, DataSet ... s) throws Exception {
        return this.evaluate(params, exceptionIfNotComputeable, s, (double[][])null);
    }

    public final ResultSet evaluate(PerformanceMeasureParameterSet params, boolean exceptionIfNotComputeable, DataSet[] s, double[][] weights) throws Exception {
        LinkedList list = new LinkedList();
        boolean isNumeric = this.getResults(list, s, weights, params, exceptionIfNotComputeable);
        if (isNumeric) {
            return new NumericalResultSet(list);
        }
        return new ResultSet(list);
    }

    protected boolean getResults(LinkedList list, DataSet[] s, double[][] weights, PerformanceMeasureParameterSet params, boolean exceptionIfNotComputeable) throws Exception {
        AbstractPerformanceMeasure[] m;
        if (s.length != this.getNumberOfClasses()) {
            throw new ClassDimensionException();
        }
        double[][][] scores = this.getMultiClassScores(s);
        boolean isNumeric = true;
        AbstractPerformanceMeasure[] abstractPerformanceMeasureArray = m = params.getAllMeasures();
        int n = m.length;
        int n2 = 0;
        while (n2 < n) {
            ResultSet r;
            block6: {
                AbstractPerformanceMeasure current = abstractPerformanceMeasureArray[n2];
                r = null;
                try {
                    r = current.compute(scores, weights);
                }
                catch (Exception e) {
                    if (!exceptionIfNotComputeable) break block6;
                    throw e;
                }
            }
            if (r != null) {
                isNumeric &= r instanceof NumericalResultSet;
                int j = 0;
                while (j < r.getNumberOfResults()) {
                    list.add(r.getResultAt(j));
                    ++j;
                }
            }
            ++n2;
        }
        return isNumeric;
    }

    protected double[][][] getMultiClassScores(DataSet[] s) throws Exception {
        double[][][] scores = new double[this.getNumberOfClasses()][][];
        int d = 0;
        while (d < s.length) {
            scores[d] = new double[s[d].getNumberOfElements()][scores.length];
            int n = 0;
            while (n < scores[d].length) {
                scores[d][n][this.classify((Sequence)s[d].getElementAt((int)n))] = 1.0;
                ++n;
            }
            ++d;
        }
        return scores;
    }

    public final AlphabetContainer getAlphabetContainer() {
        return this.alphabets;
    }

    public ResultSet getCharacteristics() throws Exception {
        return new ResultSet(this.getNumericalCharacteristics().getResults(), {new StorableResult("classifer", "the xml representation of the classifier", this)});
    }

    public abstract String getInstanceName();

    public abstract CategoricalResult[] getClassifierAnnotation();

    public final int getLength() {
        return this.length;
    }

    public abstract NumericalResultSet getNumericalCharacteristics() throws Exception;

    public abstract int getNumberOfClasses();

    public abstract boolean isInitialized();

    public void train(DataSet ... s) throws Exception {
        this.train(s, new double[s.length][]);
    }

    public abstract void train(DataSet[] var1, double[][] var2) throws Exception;

    protected abstract String getXMLTag();

    private void fromXML(StringBuffer representation) throws NonParsableException {
        StringBuffer xml = XMLParser.extractForTag(representation, this.getXMLTag());
        this.alphabets = (AlphabetContainer)XMLParser.extractObjectForTags(xml, "alphabetcontainer");
        this.length = XMLParser.extractObjectForTags(xml, "length", Integer.TYPE);
        this.extractFurtherClassifierInfosFromXML(xml);
    }

    protected abstract void extractFurtherClassifierInfosFromXML(StringBuffer var1) throws NonParsableException;

    @Override
    public final StringBuffer toXML() {
        StringBuffer xml = new StringBuffer(100000);
        XMLParser.appendObjectWithTags(xml, this.alphabets, "alphabetcontainer");
        XMLParser.appendObjectWithTags(xml, this.length, "length");
        xml.append(this.getFurtherClassifierInfos());
        XMLParser.addTags(xml, this.getXMLTag());
        return xml;
    }

    protected abstract StringBuffer getFurtherClassifierInfos();
}

