/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.algorithms.alignment;

import de.jstacs.algorithms.alignment.PairwiseStringAlignment;
import de.jstacs.algorithms.alignment.cost.AffineCosts;
import de.jstacs.algorithms.alignment.cost.Costs;
import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.sequences.Sequence;

public class Alignment {
    private AlignmentType type;
    private int startS1;
    private int startS2;
    private Sequence s1;
    private Sequence s2;
    int l1;
    int l2;
    private Costs costs;
    private AffineCosts aCosts;
    private AlignmentAlgorithm algorithm;
    private double[][][] d;
    private int offDiagonal;

    public Alignment(AlignmentType type, Costs costs) {
        this(type, costs, Integer.MAX_VALUE);
    }

    public Alignment(AlignmentType type, Costs costs, int offDiagonal) {
        this.type = type;
        this.costs = costs;
        if (costs instanceof AffineCosts) {
            this.aCosts = (AffineCosts)costs;
            this.algorithm = new AffineAlignment();
        } else {
            this.aCosts = null;
            this.algorithm = new SimpleAlgorithm();
        }
        this.offDiagonal = offDiagonal;
    }

    public PairwiseStringAlignment getAlignment(Sequence s1, Sequence s2) {
        return this.getAlignment(s1, 0, s1.getLength(), s2, 0, s2.getLength());
    }

    public PairwiseStringAlignment getAlignment(Sequence s1, int startS1, int endS1, Sequence s2, int startS2, int endS2) {
        int endPos;
        int end;
        int h;
        int start;
        this.s1 = s1;
        this.startS1 = startS1;
        this.s2 = s2;
        this.startS2 = startS2;
        this.l1 = endS1 - startS1;
        this.l2 = endS2 - startS2;
        if (Math.abs(this.l1 - this.l2) > this.offDiagonal) {
            throw new IllegalArgumentException("The number of secondary diagonals must be at least as large as the difference of the lengths, but is " + this.offDiagonal + " < " + Math.abs(this.l1 - this.l2) + ".");
        }
        if (this.d == null || this.d[0].length < this.l1 + 1 || this.d[0][0].length < this.l2 + 1) {
            this.d = new double[this.aCosts == null ? 1 : 3][this.l1 + 1][this.l2 + 1];
        }
        int i = 0;
        while (i <= this.l1) {
            start = Math.max(0, i - this.offDiagonal);
            h = i + this.offDiagonal;
            end = h > 0 ? Math.min(this.l2, h) : this.l2;
            this.algorithm.reset(i, 0, start);
            int j = start;
            while (j <= end) {
                this.algorithm.compute(i, j);
                ++j;
            }
            if (end != this.l2) {
                this.algorithm.reset(i, end + 1, this.l2);
            }
            ++i;
        }
        int[] index = new int[]{-1, -1, -1};
        int startPos = 0;
        if (this.type == AlignmentType.LOCAL) {
            endPos = -1;
            index[0] = 0;
            int i2 = 0;
            while (i2 <= this.l1) {
                start = Math.max(0, i2 - this.offDiagonal);
                h = i2 + this.offDiagonal;
                end = h > 0 ? Math.min(this.l2, h) : this.l2;
                int j = start;
                while (j <= end) {
                    if (index[1] < 0 || this.d[0][i2][j] < this.d[0][index[1]][index[2]]) {
                        index[1] = i2;
                        index[2] = j;
                        endPos = startS1 + i2;
                    }
                    ++j;
                }
                ++i2;
            }
        } else {
            endPos = this.l1;
            index[1] = this.l1;
            index[2] = this.l2;
            index[0] = this.aCosts == null ? 0 : (this.d[1][this.l1][this.l2] < this.d[2][this.l1][this.l2] && this.d[1][this.l1][this.l2] < this.d[0][this.l1][this.l2] ? 1 : (this.d[2][this.l1][this.l2] < this.d[0][this.l1][this.l2] ? 2 : 0));
        }
        double cost = this.d[index[0]][index[1]][index[2]];
        StringBuffer b1 = new StringBuffer();
        StringBuffer b2 = new StringBuffer();
        AlphabetContainer cont = s1.getAlphabetContainer();
        int[] next = (int[])index.clone();
        while (true) {
            this.algorithm.next(index, next);
            if (next[0] < 0) break;
            int row = next[1] - index[1];
            int column = next[2] - index[2];
            if (row == -1 && column == -1) {
                b1.insert(0, cont.getSymbol(startS1 + index[1] - 1, s1.discreteVal(startS1 + index[1] - 1)));
                b2.insert(0, cont.getSymbol(startS2 + index[2] - 1, s2.discreteVal(startS2 + index[2] - 1)));
            } else if (column == -1) {
                b1.insert(0, '-');
                b2.insert(0, cont.getSymbol(startS2 + index[2] - 1, s2.discreteVal(startS2 + index[2] - 1)));
            } else if (row == -1) {
                b1.insert(0, cont.getSymbol(startS1 + index[1] - 1, s1.discreteVal(startS1 + index[1] - 1)));
                b2.insert(0, '-');
            }
            if (index[2] == this.l2 && column == -1) {
                endPos = startS1 + index[1];
            }
            if ((this.type == AlignmentType.LOCAL || index[2] == 1) && row == -1) {
                startPos = startS1 + index[1] - 1;
            }
            System.arraycopy(next, 0, index, 0, 3);
        }
        return new PairwiseStringAlignment(b1.toString(), b2.toString(), cost, startPos, endPos);
    }

    private class AffineAlignment
    implements AlignmentAlgorithm {
        private AffineAlignment() {
        }

        @Override
        public void compute(int i, int j) {
            this.computeGap1(i, j);
            this.computeGap2(i, j);
            this.computeMatchMisMatch(i, j);
        }

        public byte computeMatchMisMatch(int i, int j) {
            int direction = -99;
            if (i == 0 && j == 0) {
                ((Alignment)Alignment.this).d[0][i][j] = 0.0;
            } else if (i == 0 && j > 0) {
                ((Alignment)Alignment.this).d[0][i][j] = Alignment.this.d[1][i][j];
                direction = 1;
            } else if (i > 0 && j == 0) {
                ((Alignment)Alignment.this).d[0][i][j] = Alignment.this.d[2][i][j];
                direction = 2;
            } else {
                double diag = Alignment.this.d[0][i - 1][j - 1] + Alignment.this.costs.getCostFor(Alignment.this.s1, Alignment.this.s2, Alignment.this.startS1 + i, Alignment.this.startS2 + j);
                double left = Alignment.this.d[1][i][j];
                double top = Alignment.this.d[2][i][j];
                if (diag < left && diag < top) {
                    ((Alignment)Alignment.this).d[0][i][j] = diag;
                    direction = 0;
                } else if (left < top) {
                    ((Alignment)Alignment.this).d[0][i][j] = left;
                    direction = 1;
                } else {
                    ((Alignment)Alignment.this).d[0][i][j] = top;
                    direction = 2;
                }
            }
            if (Alignment.this.type == AlignmentType.LOCAL && 0.0 < Alignment.this.d[0][i][j]) {
                ((Alignment)Alignment.this).d[0][i][j] = 0.0;
                direction = -1;
            }
            return (byte)direction;
        }

        public byte computeGap1(int i, int j) {
            int direction = -100;
            if (j == 0) {
                ((Alignment)Alignment.this).d[1][i][j] = Double.POSITIVE_INFINITY;
            } else if (i == 0 && j > 0) {
                if (Alignment.this.type == AlignmentType.LOCAL) {
                    ((Alignment)Alignment.this).d[1][i][j] = 0.0;
                    direction = -1;
                } else {
                    direction = 1;
                    ((Alignment)Alignment.this).d[1][i][j] = Alignment.this.aCosts.getGapCostsFor(j);
                }
            } else {
                double start;
                double elong = Alignment.this.d[1][i][j - 1] + Alignment.this.aCosts.getElongateCosts();
                if (elong < (start = Alignment.this.d[0][i][j - 1] + Alignment.this.aCosts.getGapCostsFor(1))) {
                    ((Alignment)Alignment.this).d[1][i][j] = elong;
                    direction = 1;
                } else {
                    ((Alignment)Alignment.this).d[1][i][j] = start;
                    direction = 0;
                }
            }
            return (byte)direction;
        }

        public byte computeGap2(int i, int j) {
            int direction = -101;
            if (i == 0) {
                ((Alignment)Alignment.this).d[2][i][j] = Double.POSITIVE_INFINITY;
            } else if (i > 0 && j == 0) {
                direction = (byte)(Alignment.this.type == AlignmentType.LOCAL ? -1 : 2);
                ((Alignment)Alignment.this).d[2][i][j] = Alignment.this.type != AlignmentType.GLOBAL ? 0.0 : Alignment.this.aCosts.getGapCostsFor(i);
            } else if (Alignment.this.type == AlignmentType.SEMI_GLOBAL && i > 0 && j == Alignment.this.l2) {
                direction = 0;
                ((Alignment)Alignment.this).d[2][i][j] = Alignment.this.d[0][i - 1][j];
            } else {
                double start;
                double elong = Alignment.this.d[2][i - 1][j] + Alignment.this.aCosts.getElongateCosts();
                if (elong < (start = Alignment.this.d[0][i - 1][j] + Alignment.this.aCosts.getGapCostsFor(1))) {
                    ((Alignment)Alignment.this).d[2][i][j] = elong;
                    direction = 2;
                } else {
                    ((Alignment)Alignment.this).d[2][i][j] = start;
                    direction = 0;
                }
            }
            return (byte)direction;
        }

        @Override
        public void next(int[] index, int[] next) {
            switch (index[0]) {
                case 0: {
                    byte b = this.computeMatchMisMatch(index[1], index[2]);
                    if (b < 0) {
                        next[0] = -1;
                        break;
                    }
                    System.arraycopy(index, 0, next, 0, 3);
                    if (b == 0) {
                        next[1] = next[1] - 1;
                        next[2] = next[2] - 1;
                        break;
                    }
                    next[0] = b;
                    break;
                }
                case 1: {
                    byte b = this.computeGap1(index[1], index[2]);
                    if (b < 0) {
                        next[0] = -1;
                        break;
                    }
                    System.arraycopy(index, 0, next, 0, 3);
                    next[2] = next[2] - 1;
                    next[0] = b;
                    break;
                }
                case 2: {
                    byte b = this.computeGap2(index[1], index[2]);
                    if (b < 0) {
                        next[0] = -1;
                        break;
                    }
                    System.arraycopy(index, 0, next, 0, 3);
                    next[1] = next[1] - 1;
                    next[0] = b;
                }
            }
        }

        @Override
        public void reset(int i, int startJ, int endJ) {
            int k = 0;
            while (k < Alignment.this.d.length) {
                if (startJ >= 0 && startJ < Alignment.this.d[k][i].length) {
                    ((Alignment)Alignment.this).d[k][i][startJ] = Double.POSITIVE_INFINITY;
                }
                if (endJ > 0 && endJ <= Alignment.this.d[k][i].length) {
                    ((Alignment)Alignment.this).d[k][i][endJ - 1] = Double.POSITIVE_INFINITY;
                }
                ++k;
            }
        }
    }

    private static interface AlignmentAlgorithm {
        public void compute(int var1, int var2);

        public void reset(int var1, int var2, int var3);

        public void next(int[] var1, int[] var2);
    }

    public static enum AlignmentType {
        GLOBAL,
        SEMI_GLOBAL,
        LOCAL;

    }

    private class SimpleAlgorithm
    implements AlignmentAlgorithm {
        private SimpleAlgorithm() {
        }

        @Override
        public void compute(int i, int j) {
            this.computeDirection(i, j);
        }

        public byte computeDirection(int i, int j) {
            int direction = -1;
            if (i == 0 && j == 0) {
                ((Alignment)Alignment.this).d[0][i][j] = 0.0;
            } else if (i == 0 && j > 0) {
                direction = 1;
                ((Alignment)Alignment.this).d[0][i][j] = Alignment.this.d[0][i][j - 1] + Alignment.this.costs.getGapCosts();
            } else if (i > 0 && j == 0) {
                if (Alignment.this.type != AlignmentType.LOCAL) {
                    direction = 2;
                }
                ((Alignment)Alignment.this).d[0][i][j] = Alignment.this.type != AlignmentType.GLOBAL ? 0.0 : Alignment.this.d[0][i - 1][j] + Alignment.this.costs.getGapCosts();
            } else {
                double diag = Alignment.this.d[0][i - 1][j - 1] + Alignment.this.costs.getCostFor(Alignment.this.s1, Alignment.this.s2, Alignment.this.startS1 + i, Alignment.this.startS2 + j);
                double left = Alignment.this.d[0][i][j - 1] + Alignment.this.costs.getGapCosts();
                double top = Alignment.this.d[0][i - 1][j];
                if (Alignment.this.type != AlignmentType.SEMI_GLOBAL || j != Alignment.this.l2) {
                    top += Alignment.this.costs.getGapCosts();
                }
                if (diag < left && diag < top) {
                    ((Alignment)Alignment.this).d[0][i][j] = diag;
                    direction = 0;
                } else if (left < top) {
                    ((Alignment)Alignment.this).d[0][i][j] = left;
                    direction = 1;
                } else {
                    ((Alignment)Alignment.this).d[0][i][j] = top;
                    direction = 2;
                }
            }
            if (Alignment.this.type == AlignmentType.LOCAL && 0.0 < Alignment.this.d[0][i][j]) {
                ((Alignment)Alignment.this).d[0][i][j] = 0.0;
                direction = -1;
            }
            return (byte)direction;
        }

        @Override
        public void reset(int i, int startJ, int endJ) {
            if (startJ >= 0 && startJ < Alignment.this.d[0][i].length) {
                ((Alignment)Alignment.this).d[0][i][startJ] = Double.POSITIVE_INFINITY;
            }
            if (endJ > 0 && endJ <= Alignment.this.d[0][i].length) {
                ((Alignment)Alignment.this).d[0][i][endJ - 1] = Double.POSITIVE_INFINITY;
            }
        }

        @Override
        public void next(int[] index, int[] next) {
            byte res = this.computeDirection(index[1], index[2]);
            if (res < 0) {
                next[0] = -1;
            } else {
                System.arraycopy(index, 0, next, 0, 3);
                switch (res) {
                    case 0: {
                        next[1] = next[1] - 1;
                        next[2] = next[2] - 1;
                        break;
                    }
                    case 2: {
                        next[1] = next[1] - 1;
                        break;
                    }
                    case 1: {
                        next[2] = next[2] - 1;
                    }
                }
            }
        }
    }
}

